/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.network.IMessage;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class MessageWireSync
implements IMessage {
    public static final ResourceLocation ID = IEApi.ieLoc("wire_sync");
    private final ConnectionPoint start;
    private final ConnectionPoint end;
    private final WireType type;
    private final Operation operation;
    private final Vec3 offsetStart;
    private final Vec3 offsetEnd;

    public MessageWireSync(Connection conn, Operation operation) {
        this.start = conn.getEndA();
        this.end = conn.getEndB();
        this.type = conn.type;
        this.operation = operation;
        this.offsetStart = conn.getEndAOffset();
        this.offsetEnd = conn.getEndBOffset();
    }

    public MessageWireSync(FriendlyByteBuf buf) {
        this.operation = Operation.VALUES[buf.readByte()];
        this.start = this.readConnPoint(buf);
        this.end = this.readConnPoint(buf);
        this.type = WireType.getValue(buf.readUtf(128));
        this.offsetStart = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.offsetEnd = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    private ConnectionPoint readConnPoint(FriendlyByteBuf buf) {
        return new ConnectionPoint(buf.readBlockPos(), buf.readInt());
    }

    private void writeConnPoint(ConnectionPoint cp, FriendlyByteBuf buf) {
        buf.writeBlockPos(cp.position());
        buf.writeInt(cp.index());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.operation.ordinal());
        this.writeConnPoint(this.start, buf);
        this.writeConnPoint(this.end, buf);
        buf.writeUtf(this.type.getUniqueName());
        buf.writeDouble(this.offsetStart.x).writeDouble(this.offsetStart.y).writeDouble(this.offsetStart.z);
        buf.writeDouble(this.offsetEnd.x).writeDouble(this.offsetEnd.y).writeDouble(this.offsetEnd.z);
    }

    @Override
    public void process(PlayPayloadContext context) {
        context.workHandler().execute(() -> {
            WireLogger.logger.debug("Processing sync for connection from {} to {}, type {}, op {}", (Object)this.start, (Object)this.end, (Object)this.type, (Object)this.operation.name());
            Player player = ImmersiveEngineering.proxy.getClientPlayer();
            Level w = player.level();
            GlobalWireNetwork globalNet = GlobalWireNetwork.getNetwork(w);
            Connection connection = new Connection(this.type, this.start, this.end, this.offsetStart, this.offsetEnd);
            if (this.operation != Operation.ADD && globalNet.getNullableLocalNet(this.start) != null && globalNet.getNullableLocalNet(this.end) != null) {
                globalNet.removeConnection(connection);
                this.removeProxyIfNoWires(this.start, globalNet);
                this.removeProxyIfNoWires(this.end, globalNet);
            }
            if (this.operation != Operation.REMOVE) {
                globalNet.addConnection(connection);
            }
            ObjectArraySet sectionsToRerender = new ObjectArraySet();
            WireUtils.forEachRenderPoint(connection, (arg_0, arg_1, arg_2) -> MessageWireSync.lambda$process$0((Set)sectionsToRerender, arg_0, arg_1, arg_2));
            for (SectionPos section : sectionsToRerender) {
                Minecraft.getInstance().levelRenderer.setSectionDirty(section.x(), section.y(), section.z());
            }
        });
    }

    private void removeProxyIfNoWires(ConnectionPoint point, GlobalWireNetwork globalNet) {
        LocalWireNetwork localNet = globalNet.getLocalNet(point);
        IImmersiveConnectable iic = localNet.getConnector(point);
        if (iic.isProxy() && !WireUtils.hasAnyConnections(globalNet, iic)) {
            globalNet.removeConnector(iic);
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    private static /* synthetic */ void lambda$process$0(Set sectionsToRerender, int $, Vec3 $2, SectionPos section) {
        sectionsToRerender.add(section);
    }

    public static enum Operation {
        ADD,
        REMOVE,
        UPDATE;

        private static final Operation[] VALUES;

        static {
            VALUES = Operation.values();
        }
    }
}

