/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.register;

import blusunrize.immersiveengineering.common.blocks.metal.WarningSignBlock;
import blusunrize.immersiveengineering.common.register.IEItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class IEBannerPatterns {
    private static final DeferredRegister<BannerPattern> REGISTER = DeferredRegister.create((ResourceKey)Registries.BANNER_PATTERN, (String)"immersiveengineering");
    public static final List<BannerEntry> ALL_BANNERS = new ArrayList<BannerEntry>();
    public static final BannerEntry HAMMER = IEBannerPatterns.addBanner("hammer", "hmr", "head", "grip");
    public static final BannerEntry WIRECUTTER = IEBannerPatterns.addBanner("wirecutter", "wct", "head", "grip");
    public static final BannerEntry SCREWDRIVER = IEBannerPatterns.addBanner("screwdriver", "scd", "head", "grip");
    public static final BannerEntry BEVELS = IEBannerPatterns.addBanner("bevels", "bvl", new String[0]);
    public static final BannerEntry ORNATE = IEBannerPatterns.addBanner("ornate", "orn", new String[0]);
    public static final BannerEntry TREATED_WOOD = IEBannerPatterns.addBanner("treated_wood", "twd", new String[0]);
    public static final BannerEntry WINDMILL = IEBannerPatterns.addBanner("windmill", "wnd", new String[0]);
    public static final BannerEntry WARNING = IEBannerPatterns.addBanner("warning", "wrn", (String[])Arrays.stream(WarningSignBlock.WarningSignIcon.values()).filter(WarningSignBlock.WarningSignIcon::hasBanner).map(WarningSignBlock.WarningSignIcon::getSerializedName).toArray(String[]::new));
    public static final BannerEntry WOLF = IEBannerPatterns.addBanner("wolf", "wlf", "r", "l");

    public static void init(IEventBus modBus) {
        REGISTER.register(modBus);
    }

    private static BannerEntry addBanner(String name, String hashName, String ... subdesigns) {
        DeferredHolder pattern = REGISTER.register(name, () -> new BannerPattern("ie_" + hashName));
        TagKey tag = TagKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)((ResourceKey)pattern.unwrapKey().get()).location());
        IEItems.ItemRegObject<BannerPatternItem> item = IEItems.register("bannerpattern_" + name, () -> new BannerPatternItem(tag, new Item.Properties()));
        BannerEntry result = new BannerEntry(name, (Holder<BannerPattern>)pattern, (TagKey<BannerPattern>)tag, item);
        for (String design : subdesigns) {
            result.patterns().add((Holder<BannerPattern>)REGISTER.register(name + "_" + design, () -> new BannerPattern("ie_" + hashName + "_" + design)));
        }
        ALL_BANNERS.add(result);
        return result;
    }

    public record BannerEntry(String name, List<Holder<BannerPattern>> patterns, TagKey<BannerPattern> tag, IEItems.ItemRegObject<BannerPatternItem> item) {
        public BannerEntry(String name, Holder<BannerPattern> pattern, TagKey<BannerPattern> tag, IEItems.ItemRegObject<BannerPatternItem> item) {
            this(name, new ArrayList<Holder<BannerPattern>>(), tag, item);
            this.patterns.add(pattern);
        }
    }
}

