/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.register;

import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IECreativeTabs {
    public static final DeferredRegister<CreativeModeTab> REGISTER = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"immersiveengineering");
    private static Holder<CreativeModeTab> TAB = REGISTER.register("main", () -> new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 0).icon(() -> IEItems.Misc.WIRE_COILS.get(WireType.COPPER).get().getDefaultInstance()).title((Component)Component.translatable((String)"itemGroup.immersiveengineering")).displayItems(IECreativeTabs::fillIETab).build());

    @SubscribeEvent
    public static void fillTab(BuildCreativeModeTabContentsEvent ev) {
        if (ev.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
            IEItems.Misc.POTION_BUCKET.get().fillCreativeTab((CreativeModeTab.Output)ev);
        }
        if (ev.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            ev.accept((ItemLike)IEItems.SpawnEggs.EGG_FUSILIER.get());
            ev.accept((ItemLike)IEItems.SpawnEggs.EGG_COMMANDO.get());
            ev.accept((ItemLike)IEItems.SpawnEggs.EGG_BULWARK.get());
        }
    }

    private static void fillIETab(CreativeModeTab.ItemDisplayParameters parms, CreativeModeTab.Output out) {
        for (Holder itemRef : IEItems.REGISTER.getEntries()) {
            BlockItem blockItem;
            Block block;
            Item item = (Item)itemRef.value();
            if (item == IEItems.Misc.POTION_BUCKET.get()) continue;
            if (item instanceof IEBaseItem) {
                IEBaseItem ieItem = (IEBaseItem)item;
                ieItem.fillCreativeTab(out);
                continue;
            }
            if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof IEBaseBlock) {
                IEBaseBlock ieBlock = (IEBaseBlock)block;
                ieBlock.fillCreativeTab(out);
                continue;
            }
            out.accept((ItemLike)itemRef.value());
        }
    }
}

