/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyHelper {
    public static final String LEGACY_ENERGY_KEY = "ifluxEnergy";
    public static final String ENERGY_KEY = "energy";
    static HashMap<Item, Boolean> reverseInsertion = new HashMap();

    public static void deserializeFrom(EnergyStorage storage, CompoundTag mainTag) {
        Object subtag = mainTag.contains(LEGACY_ENERGY_KEY, 3) ? mainTag.get(LEGACY_ENERGY_KEY) : (mainTag.contains(ENERGY_KEY, 3) ? mainTag.get(ENERGY_KEY) : IntTag.valueOf((int)0));
        storage.deserializeNBT(subtag);
    }

    public static void serializeTo(EnergyStorage storage, CompoundTag mainTag) {
        mainTag.put(ENERGY_KEY, storage.serializeNBT());
    }

    public static int forceExtractFlux(ItemStack stack, int energy, boolean simulate) {
        IEnergyStorage stackEnergy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (stackEnergy == null) {
            return 0;
        }
        Boolean b = reverseInsertion.get(stack.getItem());
        if (b == Boolean.TRUE) {
            int stored = stackEnergy.getEnergyStored();
            EnergyHelper.insertFlux(stack, -energy, simulate);
            return stored - stackEnergy.getEnergyStored();
        }
        int drawn = stackEnergy.extractEnergy(energy, simulate);
        if (b == null) {
            int stored = stackEnergy.getEnergyStored();
            EnergyHelper.insertFlux(stack, -energy, simulate);
            drawn = stored - stackEnergy.getEnergyStored();
            reverseInsertion.put(stack.getItem(), drawn > 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        return drawn;
    }

    public static int getEnergyStored(ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        return storage != null ? storage.getEnergyStored() : 0;
    }

    public static int getMaxEnergyStored(ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        return storage != null ? storage.getMaxEnergyStored() : 0;
    }

    public static boolean isFluxReceiver(ItemStack stack) {
        return stack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
    }

    public static boolean isFluxRelated(ItemStack stack) {
        return stack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
    }

    public static int insertFlux(ItemStack stack, int energy, boolean simulate) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (storage != null) {
            return storage.receiveEnergy(energy, simulate);
        }
        return 0;
    }

    public static int distributeFlux(Collection<IEnergyStorage> storages, int amount, boolean simulate) {
        int finalAmount = amount;
        storages = storages.stream().filter(Objects::nonNull).map(storage -> Pair.of((Object)storage, (Object)storage.receiveEnergy(finalAmount, true))).sorted(Comparator.comparingInt(Pair::getSecond)).map(Pair::getFirst).collect(Collectors.toList());
        int remainingOutputs = storages.size();
        for (IEnergyStorage storage2 : storages) {
            int possibleOutput = (int)Math.ceil((float)amount / (float)remainingOutputs);
            int inserted = storage2.receiveEnergy(possibleOutput, simulate);
            amount -= inserted;
            --remainingOutputs;
        }
        return amount;
    }

    public static class ItemEnergyStorage
    implements IEnergyStorage {
        private final ItemStack stack;
        private final ToIntFunction<ItemStack> getCapacity;

        public ItemEnergyStorage(ItemStack item, ToIntFunction<ItemStack> getCapacity) {
            this.stack = item;
            this.getCapacity = getCapacity;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int stored = this.getEnergyStored();
            int accepted = Math.min(maxReceive, this.getMaxEnergyStored() - stored);
            if (!simulate) {
                ItemNBTHelper.putInt(this.stack, EnergyHelper.ENERGY_KEY, stored += accepted);
            }
            return accepted;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int stored = this.getEnergyStored();
            int extracted = Math.min(maxExtract, stored);
            if (!simulate) {
                ItemNBTHelper.putInt(this.stack, EnergyHelper.ENERGY_KEY, stored -= extracted);
            }
            return extracted;
        }

        public int getEnergyStored() {
            return ItemNBTHelper.getInt(this.stack, EnergyHelper.ENERGY_KEY);
        }

        public int getMaxEnergyStored() {
            return this.getCapacity.applyAsInt(this.stack);
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

