/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.utils.Raytracer;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEPotions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpawnInterdictionHandler {
    private static final Map<ResourceKey<Level>, Set<IEBlockInterfaces.ISpawnInterdiction>> interdictionTiles = new HashMap<ResourceKey<Level>, Set<IEBlockInterfaces.ISpawnInterdiction>>();

    @SubscribeEvent
    public static void onEnderTeleport(EntityTeleportEvent.EnderEntity event) {
        LivingEntity living = event.getEntityLiving();
        if (SpawnInterdictionHandler.shouldCancel((Entity)living) || living.getEffect((MobEffect)IEPotions.STUNNED.value()) != null) {
            event.setCanceled(true);
        } else if (SpawnInterdictionHandler.checkForLeadedBlocks((EntityTeleportEvent)event, living)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEnderpearlTeleport(EntityTeleportEvent.EnderPearl event) {
        if (SpawnInterdictionHandler.checkForLeadedBlocks((EntityTeleportEvent)event, (LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onChorusTeleport(EntityTeleportEvent.ChorusFruit event) {
        if (SpawnInterdictionHandler.checkForLeadedBlocks((EntityTeleportEvent)event, event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    private static boolean checkForLeadedBlocks(EntityTeleportEvent event, LivingEntity living) {
        Level level = living.level();
        Set<BlockPos> blocksBetween = Raytracer.rayTrace(living.getEyePosition(), event.getTarget(), level);
        return blocksBetween.stream().anyMatch(blockPos -> {
            BlockState blockState = level.getBlockState(blockPos);
            return blockState.is((Block)IEBlocks.StoneDecoration.CONCRETE_LEADED.get());
        });
    }

    @SubscribeEvent
    public static void onEntitySpawnCheck(MobSpawnEvent.FinalizeSpawn event) {
        if (event.isSpawnCancelled() || event.getSpawner() != null) {
            return;
        }
        if (SpawnInterdictionHandler.shouldCancel((Entity)event.getEntity())) {
            event.setSpawnCancelled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        Object object;
        if (event.getLevel().isClientSide() || !((object = event.getLevel()) instanceof Level)) {
            return;
        }
        Level realLevel = (Level)object;
        object = interdictionTiles;
        synchronized (object) {
            interdictionTiles.remove(realLevel.dimension());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean shouldCancel(Entity entity) {
        if (entity.getType().getCategory() != MobCategory.MONSTER) {
            return false;
        }
        ResourceKey dimension = entity.level().dimension();
        Map<ResourceKey<Level>, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
        synchronized (map) {
            if (!interdictionTiles.containsKey(dimension)) {
                return false;
            }
            Iterator<IEBlockInterfaces.ISpawnInterdiction> it = interdictionTiles.get(dimension).iterator();
            while (it.hasNext()) {
                Vec3 tilePos;
                IEBlockInterfaces.ISpawnInterdiction interdictor = it.next();
                if (!(interdictor instanceof BlockEntity)) continue;
                BlockEntity interdictorTE = (BlockEntity)interdictor;
                if (interdictorTE.isRemoved() || interdictorTE.getLevel() == null) {
                    it.remove();
                    continue;
                }
                if (!SafeChunkUtils.isChunkSafe((LevelAccessor)interdictorTE.getLevel(), interdictorTE.getBlockPos()) || !((tilePos = Vec3.atCenterOf((Vec3i)interdictorTE.getBlockPos())).distanceToSqr(entity.position()) <= interdictor.getInterdictionRangeSquared())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends BlockEntity> void removeFromInterdictionTiles(T tile) {
        Level level = tile.getLevel();
        if (level != null && !level.isClientSide) {
            Map<ResourceKey<Level>, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
            synchronized (map) {
                Set<IEBlockInterfaces.ISpawnInterdiction> inDimension = interdictionTiles.get(level.dimension());
                if (inDimension != null) {
                    inDimension.remove(tile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends BlockEntity> void addInterdictionTile(T tile) {
        Level world = tile.getLevel();
        if (world != null && !world.isClientSide() && ((Boolean)IEServerConfig.MACHINES.floodlight_spawnPrevent.get()).booleanValue()) {
            Map<ResourceKey<Level>, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
            synchronized (map) {
                Set forDim = interdictionTiles.computeIfAbsent((ResourceKey<Level>)world.dimension(), x -> new HashSet());
                forDim.add((IEBlockInterfaces.ISpawnInterdiction)tile);
            }
        }
    }
}

