/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.commands;

import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.excavator.MineralWorldInfo;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.commands.MineralArgument;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CommandMineral {
    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        LiteralArgumentBuilder main = Commands.literal((String)"mineral");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)main.then(CommandMineral.listMineral())).then(CommandMineral.getMineral())).then(CommandMineral.putMineral())).then(CommandMineral.setMineralDepletion());
        return main;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> listMineral() {
        LiteralArgumentBuilder list = Commands.literal((String)"list");
        list.executes(command -> {
            StringBuilder s = new StringBuilder();
            boolean i = false;
            ((CommandSourceStack)command.getSource()).sendSuccess(() -> Component.literal((String)s.toString()), true);
            return 1;
        });
        return list;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> getMineral() {
        LiteralArgumentBuilder get = Commands.literal((String)"get");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)get.requires(source -> source.hasPermission(2))).executes(command -> {
            ServerPlayer player = ((CommandSourceStack)command.getSource()).getPlayerOrException();
            BlockPos playerPos = player.blockPosition();
            CommandMineral.getMineral((CommandContext<CommandSourceStack>)command, new ColumnPos(playerPos.getX(), playerPos.getZ()));
            return 1;
        })).then(Commands.argument((String)"location", (ArgumentType)ColumnPosArgument.columnPos()).executes(command -> {
            ColumnPos pos = ColumnPosArgument.getColumnPos((CommandContext)command, (String)"location");
            CommandMineral.getMineral((CommandContext<CommandSourceStack>)command, pos);
            return 1;
        }));
        return get;
    }

    private static void getMineral(CommandContext<CommandSourceStack> context, ColumnPos pos) {
        CommandSourceStack sender = (CommandSourceStack)context.getSource();
        MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo((Level)sender.getLevel(), pos);
        MutableComponent ret = Component.literal((String)"");
        if (info == null || info.getTotalWeight() == 0) {
            ret.append((Component)Component.translatable((String)"chat.immersiveengineering.command.mineral.get.none", (Object[])new Object[]{pos.x(), pos.z()}));
        } else {
            ret.append((Component)Component.translatable((String)"chat.immersiveengineering.command.mineral.get", (Object[])new Object[]{pos.x(), pos.z()}));
            for (Pair<MineralVein, Integer> pair : info.getAllVeins()) {
                MineralVein vein = (MineralVein)pair.getFirst();
                double percentage = (double)((Integer)pair.getSecond()).intValue() / (double)info.getTotalWeight();
                MutableComponent component = Component.literal((String)("\n " + Utils.formatDouble(percentage * 100.0, "0.00") + "% "));
                vein.getMineral((Level)((CommandSourceStack)context.getSource()).getLevel());
                component.append((Component)Component.translatable((String)MineralMix.getTranslationKey(vein.getMineralName())));
                ret.append((Component)component.withStyle(ChatFormatting.GRAY));
                component = Component.literal((String)"\n  ");
                component.append((Component)Component.translatable((String)"chat.immersiveengineering.command.mineral.get.pos", (Object[])new Object[]{vein.getPos().x(), vein.getPos().z(), vein.getRadius()}));
                component.append("\n  ");
                if (ExcavatorHandler.mineralVeinYield == 0) {
                    component.append((Component)Component.translatable((String)"desc.immersiveengineering.info.coresample.infinite"));
                } else {
                    component.append((Component)Component.translatable((String)"desc.immersiveengineering.info.coresample.yield", (Object[])new Object[]{ExcavatorHandler.mineralVeinYield - vein.getDepletion()}));
                }
                ret.append((Component)component.withStyle(ChatFormatting.GRAY));
            }
        }
        sender.sendSuccess(() -> ret, true);
    }

    private static LiteralArgumentBuilder<CommandSourceStack> putMineral() {
        LiteralArgumentBuilder set = Commands.literal((String)"put");
        ((LiteralArgumentBuilder)set.requires(source -> source.hasPermission(2))).then(Commands.argument((String)"mineral", (ArgumentType)new MineralArgument()).then(((RequiredArgumentBuilder)Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)8, (int)64)).then(Commands.argument((String)"pos", (ArgumentType)ColumnPosArgument.columnPos()).executes(ctx -> {
            CommandMineral.putMineral((CommandContext<CommandSourceStack>)ctx, ColumnPosArgument.getColumnPos((CommandContext)ctx, (String)"pos"));
            return 1;
        }))).executes(ctx -> {
            CommandMineral.putMineral((CommandContext<CommandSourceStack>)ctx, CommandMineral.columnPos(((CommandSourceStack)ctx.getSource()).getPosition()));
            return 1;
        })));
        return set;
    }

    private static void putMineral(CommandContext<CommandSourceStack> context, ColumnPos pos) {
        CommandSourceStack sender = (CommandSourceStack)context.getSource();
        RecipeHolder mineral = (RecipeHolder)context.getArgument("mineral", RecipeHolder.class);
        int radius = IntegerArgumentType.getInteger(context, (String)"radius");
        if (mineral != null) {
            MineralVein vein = new MineralVein(pos, mineral.id(), radius);
            ExcavatorHandler.addVein((ResourceKey<Level>)sender.getLevel().dimension(), vein);
            IESaveData.markInstanceDirty();
            sender.sendSuccess(() -> Component.translatable((String)"chat.immersiveengineering.command.mineral.put.success", (Object[])new Object[]{mineral.id(), radius, pos.x(), pos.z()}), true);
        } else {
            sender.sendSuccess(() -> Component.translatable((String)"chat.immersiveengineering.command.mineral.put.invalid_mineral", (Object[])new Object[]{mineral.id()}), true);
        }
    }

    private static LiteralArgumentBuilder<CommandSourceStack> setMineralDepletion() {
        LiteralArgumentBuilder setDepletion = Commands.literal((String)"setDepletion");
        ((LiteralArgumentBuilder)setDepletion.requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"depletion", (ArgumentType)IntegerArgumentType.integer((int)0, (int)ExcavatorHandler.mineralVeinYield)).then(Commands.argument((String)"pos", (ArgumentType)ColumnPosArgument.columnPos()).executes(ctx -> {
            CommandMineral.setMineralDepletion((CommandContext<CommandSourceStack>)ctx, ColumnPosArgument.getColumnPos((CommandContext)ctx, (String)"pos"));
            return 1;
        }))).executes(ctx -> {
            CommandMineral.setMineralDepletion((CommandContext<CommandSourceStack>)ctx, CommandMineral.columnPos(((CommandSourceStack)ctx.getSource()).getPosition()));
            return 1;
        }));
        return setDepletion;
    }

    private static void setMineralDepletion(CommandContext<CommandSourceStack> context, ColumnPos pos) {
        CommandSourceStack sender = (CommandSourceStack)context.getSource();
        MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo((Level)sender.getLevel(), pos);
        if (info != null && info.getTotalWeight() > 0) {
            int depletion = IntegerArgumentType.getInteger(context, (String)"depletion");
            for (Pair<MineralVein, Integer> pair : info.getAllVeins()) {
                ((MineralVein)pair.getFirst()).setDepletion(depletion);
            }
            IESaveData.markInstanceDirty();
            sender.sendSuccess(() -> Component.translatable((String)"chat.immersiveengineering.command.mineral.set_depletion.success", (Object[])new Object[]{depletion}), true);
        } else {
            sender.sendSuccess(() -> Component.translatable((String)"chat.immersiveengineering.command.mineral.set_depletion.no_mineral", (Object[])new Object[]{pos.x(), pos.z()}), true);
        }
    }

    private static ColumnPos columnPos(Vec3 vec) {
        return new ColumnPos((int)vec.x, (int)vec.z);
    }
}

