/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.fermenter;

import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIHelper;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIRecipeTypes;
import java.util.Arrays;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.resources.ResourceLocation;

public class FermenterRecipeCategory
extends IERecipeCategory<FermenterRecipe> {
    private final IDrawableStatic tankOverlay;

    public FermenterRecipeCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.FERMENTER, "block.immersiveengineering.fermenter");
        ResourceLocation background = new ResourceLocation("immersiveengineering", "textures/gui/fermenter.png");
        this.setBackground(helper.createDrawable(background, 6, 12, 126, 59));
        this.setIcon(IEMultiblockLogic.FERMENTER.iconStack());
        this.tankOverlay = helper.createDrawable(background, 179, 33, 16, 47);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, FermenterRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 7).addItemStacks(Arrays.asList(recipe.input.getMatchingStacks()));
        IRecipeSlotBuilder outputSlotBuilder = builder.addSlot(RecipeIngredientRole.OUTPUT, 85, 41);
        if (!recipe.itemOutput.get().isEmpty()) {
            outputSlotBuilder.addItemStack(recipe.itemOutput.get());
        }
        if (recipe.fluidOutput != null && !recipe.fluidOutput.isEmpty()) {
            int tankSize = Math.max(250, recipe.fluidOutput.getAmount());
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 106, 9).setFluidRenderer((long)tankSize, false, 16, 47).setOverlay((IDrawable)this.tankOverlay, 0, 0).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)recipe.fluidOutput)).addTooltipCallback(JEIHelper.fluidTooltipCallback);
        }
    }
}

