/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.mixer;

import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIHelper;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIRecipeTypes;
import java.util.Arrays;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class MixerRecipeCategory
extends IERecipeCategory<MixerRecipe> {
    private final IDrawableStatic tankTexture;
    private final IDrawableStatic tankOverlay;
    private final IDrawableStatic arrowDrawable;

    public MixerRecipeCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.MIXER, "block.immersiveengineering.mixer");
        this.setBackground(helper.createBlankDrawable(155, 60));
        this.setIcon(IEMultiblockLogic.MIXER.iconStack());
        ResourceLocation background = new ResourceLocation("immersiveengineering", "textures/gui/mixer.png");
        this.tankTexture = helper.createDrawable(background, 68, 8, 74, 60);
        this.tankOverlay = helper.drawableBuilder(background, 177, 31, 20, 51).addPadding(-2, 2, -2, 2).build();
        this.arrowDrawable = helper.createDrawable(background, 178, 17, 18, 13);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, MixerRecipe recipe, IFocusGroup focuses) {
        int tankSize = Math.max(2000, Math.max(recipe.fluidInput.getAmount(), recipe.fluidOutput.getAmount()));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 48, 3).setFluidRenderer((long)tankSize, false, 58, 47).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, recipe.fluidInput.getMatchingFluidStacks())).addTooltipCallback(JEIHelper.fluidTooltipCallback);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 139, 3).setFluidRenderer((long)tankSize, false, 16, 47).setOverlay((IDrawable)this.tankOverlay, 0, 0).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)recipe.fluidOutput)).addTooltipCallback(JEIHelper.fluidTooltipCallback);
        for (int i = 0; i < recipe.itemInputs.size(); ++i) {
            int x = i % 2 * 18 + 1;
            int y = i / 2 * 18 + 1;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStacks(Arrays.asList(recipe.itemInputs.get(i).getMatchingStacks()))).setBackground((IDrawable)JEIHelper.slotDrawable, -1, -1);
        }
    }

    @Override
    public void draw(MixerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.tankTexture.draw(graphics, 40, 0);
        this.arrowDrawable.draw(graphics, 117, 19);
        GuiHelper.drawSlot(139, 18, 16, 47, graphics);
    }
}

