/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.fakeworld;

import blusunrize.immersiveengineering.common.util.fakeworld.TemplateChunkSection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;

public class TemplateChunk
extends LevelChunk {
    private final Predicate<BlockPos> shouldShow;
    private final Holder<Biome> biome;

    public TemplateChunk(Level worldIn, ChunkPos chunkPos, List<StructureTemplate.StructureBlockInfo> blocksInChunk, Predicate<BlockPos> shouldShow) {
        super(worldIn, chunkPos);
        Registry biomeRegistry = worldIn.registryAccess().registryOrThrow(Registries.BIOME);
        for (int i = 0; i < this.getSections().length; ++i) {
            this.getSections()[i] = new TemplateChunkSection(i, (Registry<Biome>)biomeRegistry, shouldShow, chunkPos);
        }
        this.shouldShow = shouldShow;
        this.biome = worldIn.getUncachedNoiseBiome(0, 0, 0);
        for (StructureTemplate.StructureBlockInfo info : blocksInChunk) {
            BlockEntity tile;
            this.actuallSetBlockState(info.pos(), info.state());
            if (info.nbt() == null || (tile = BlockEntity.loadStatic((BlockPos)info.pos(), (BlockState)info.state(), (CompoundTag)info.nbt())) == null) continue;
            tile.setLevel(worldIn);
            this.getBlockEntities().put(info.pos(), tile);
        }
    }

    @Nonnull
    public FluidState getFluidState(@Nonnull BlockPos pos) {
        return this.getBlockState(pos).getFluidState();
    }

    @Nullable
    public BlockEntity getBlockEntity(@Nonnull BlockPos pos, @Nonnull LevelChunk.EntityCreationType creationMode) {
        if (!this.shouldShow.test(pos)) {
            return null;
        }
        return (BlockEntity)this.getBlockEntities().get(pos);
    }

    @Nullable
    public BlockState setBlockState(@Nonnull BlockPos pos, @Nonnull BlockState state, boolean isMoving) {
        return null;
    }

    public void actuallSetBlockState(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        int sectionIndex = this.getSectionIndex(pos.getY());
        int sectionX = pos.getX() & 0xF;
        int sectionY = pos.getY() & 0xF;
        int sectionZ = pos.getZ() & 0xF;
        TemplateChunkSection section = (TemplateChunkSection)this.getSection(sectionIndex);
        section.actuallySetBlockState(sectionX, sectionY, sectionZ, state);
    }

    public int getLightEmission(@Nonnull BlockPos pos) {
        return 0;
    }

    public void addAndRegisterBlockEntity(@Nonnull BlockEntity blockEntity) {
    }

    public void setBlockEntity(@Nonnull BlockEntity blockEntity) {
    }

    public void removeBlockEntity(@Nonnull BlockPos pos) {
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isYSpaceEmpty(int startY, int endY) {
        return false;
    }

    @Nonnull
    public FullChunkStatus getFullStatus() {
        return FullChunkStatus.INACCESSIBLE;
    }

    @Nonnull
    public Holder<Biome> getNoiseBiome(int p_204426_, int p_204427_, int p_204428_) {
        return this.biome;
    }
}

