/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.inventory;

import blusunrize.immersiveengineering.common.items.InternalStorageItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.ItemStackHandler;

public class IEItemStackHandler
extends ItemStackHandler {
    @Nonnull
    private Runnable onChange;

    public IEItemStackHandler(InternalStorageItem item, @Nullable IEItemStackHandler other) {
        super(item.getSlotCount());
        this.onChange = () -> {};
        if (other != null) {
            for (int i = 0; i < Math.min(this.getSlots(), other.getSlots()); ++i) {
                this.setStackInSlot(i, other.getStackInSlot(i));
            }
        }
    }

    public IEItemStackHandler() {
        this.onChange = () -> {};
    }

    public void setTile(BlockEntity tile) {
        this.onChange = tile != null ? () -> ((BlockEntity)tile).setChanged() : () -> {};
    }

    public void setInventoryForUpdate(Container inv) {
        this.onChange = inv != null ? () -> ((Container)inv).setChanged() : () -> {};
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.onChange.run();
    }

    public NonNullList<ItemStack> getContainedItems() {
        return this.stacks;
    }
}

