/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.loot;

import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBlock;
import blusunrize.immersiveengineering.common.util.loot.IELootFunctions;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ConveyorCoverLootFunction
extends LootItemConditionalFunction {
    public static final Codec<ConveyorCoverLootFunction> CODEC = RecordCodecBuilder.create(inst -> ConveyorCoverLootFunction.commonFields((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, ConveyorCoverLootFunction::new));

    protected ConveyorCoverLootFunction(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected ItemStack run(@Nonnull ItemStack stack, @Nonnull LootContext context) {
        ConveyorHandler.IConveyorBlockEntity conveyorBE;
        Block cover;
        BlockEntity te;
        Block asBlock = Block.byItem((Item)stack.getItem());
        if (ConveyorHandler.isConveyorBlock(asBlock) && context.hasParam(LootContextParams.BLOCK_ENTITY) && (te = (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY)) instanceof ConveyorHandler.IConveyorBlockEntity && (cover = (conveyorBE = (ConveyorHandler.IConveyorBlockEntity)te).getConveyorInstance().getCover()) != Blocks.AIR) {
            return ConveyorBlock.makeCovered((ItemLike)stack.getItem(), cover);
        }
        return stack;
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)IELootFunctions.CONVEYOR_COVER.value();
    }

    public static LootItemFunction.Builder builder() {
        return ConveyorCoverLootFunction.simpleBuilder(ConveyorCoverLootFunction::new);
    }
}

