/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.loot;

import blusunrize.immersiveengineering.common.util.loot.BEDropLootEntry;
import blusunrize.immersiveengineering.common.util.loot.BluprintzLootFunction;
import blusunrize.immersiveengineering.common.util.loot.ConveyorCoverLootFunction;
import blusunrize.immersiveengineering.common.util.loot.DropInventoryLootEntry;
import blusunrize.immersiveengineering.common.util.loot.MultiblockDropsLootContainer;
import blusunrize.immersiveengineering.common.util.loot.PropertyCountLootFunction;
import blusunrize.immersiveengineering.common.util.loot.RevolverperkLootFunction;
import blusunrize.immersiveengineering.common.util.loot.WindmillLootFunction;
import com.mojang.serialization.Codec;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class IELootFunctions {
    private static final DeferredRegister<LootItemFunctionType> FUNCTION_REGISTER = DeferredRegister.create((ResourceKey)Registries.LOOT_FUNCTION_TYPE, (String)"immersiveengineering");
    public static final Holder<LootItemFunctionType> BLUPRINTZ = IELootFunctions.registerFunction("secret_bluprintz", BluprintzLootFunction.CODEC);
    public static final Holder<LootItemFunctionType> REVOLVERPERK = IELootFunctions.registerFunction("revolverperk", RevolverperkLootFunction.CODEC);
    public static final Holder<LootItemFunctionType> WINDMILL = IELootFunctions.registerFunction("windmill", WindmillLootFunction.CODEC);
    public static final Holder<LootItemFunctionType> CONVEYOR_COVER = IELootFunctions.registerFunction("conveyor_cover", ConveyorCoverLootFunction.CODEC);
    public static final Holder<LootItemFunctionType> PROPERTY_COUNT = IELootFunctions.registerFunction("property_count", PropertyCountLootFunction.CODEC);
    private static final DeferredRegister<LootPoolEntryType> ENTRY_REGISTER = DeferredRegister.create((ResourceKey)BuiltInRegistries.LOOT_POOL_ENTRY_TYPE.key(), (String)"immersiveengineering");
    public static final Holder<LootPoolEntryType> DROP_INVENTORY = IELootFunctions.registerEntry("drop_inv", DropInventoryLootEntry.CODEC);
    public static final Holder<LootPoolEntryType> TILE_DROP = IELootFunctions.registerEntry("tile_drop", BEDropLootEntry.CODEC);
    public static final Holder<LootPoolEntryType> MULTIBLOCK_DROPS = IELootFunctions.registerEntry("multiblock", MultiblockDropsLootContainer.CODEC);

    public static void init(IEventBus modBus) {
        FUNCTION_REGISTER.register(modBus);
        ENTRY_REGISTER.register(modBus);
    }

    private static Holder<LootPoolEntryType> registerEntry(String id, Codec<? extends LootPoolEntryContainer> serializer) {
        return ENTRY_REGISTER.register(id, () -> new LootPoolEntryType(serializer));
    }

    private static Holder<LootItemFunctionType> registerFunction(String id, Codec<? extends LootItemFunction> serializer) {
        return FUNCTION_REGISTER.register(id, () -> new LootItemFunctionType(serializer));
    }
}

