/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.loot;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.ComponentInstance;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.MultiblockBEHelperCommon;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.MultiblockBEHelperMaster;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.loot.IELootFunctions;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class MultiblockDropsLootContainer
extends LootPoolSingletonContainer {
    public static final Codec<MultiblockDropsLootContainer> CODEC = RecordCodecBuilder.create(inst -> MultiblockDropsLootContainer.singletonFields((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, MultiblockDropsLootContainer::new));

    protected MultiblockDropsLootContainer(int weightIn, int qualityIn, List<LootItemCondition> conditionsIn, List<LootItemFunction> functionsIn) {
        super(weightIn, qualityIn, conditionsIn, functionsIn);
    }

    protected void createItemStack(@Nonnull Consumer<ItemStack> output, LootContext context) {
        Object object = context.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (object instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)object;
            IMultiblockBEHelper helper = multiblockBE.getHelper();
            this.dropOriginalBlock(helper, context, output);
            this.dropExtraItems(helper, output);
        }
    }

    private void dropOriginalBlock(IMultiblockBEHelper<?> helper, LootContext context, Consumer<ItemStack> drop) {
        BlockState originalBlock = helper.getOriginalBlock((Level)context.getLevel());
        Utils.getDrops(originalBlock, context, drop);
    }

    private <S extends IMultiblockState> void dropExtraItems(IMultiblockBEHelper<S> iHelper, Consumer<ItemStack> drop) {
        if (!(iHelper instanceof MultiblockBEHelperCommon)) {
            return;
        }
        MultiblockBEHelperCommon helper = (MultiblockBEHelperCommon)iHelper;
        IMultiblockBEHelperMaster masterHelper = helper.getMasterHelperDuringDisassembly();
        if (masterHelper instanceof MultiblockBEHelperMaster) {
            MultiblockBEHelperMaster nonAPI = (MultiblockBEHelperMaster)masterHelper;
            for (ComponentInstance<?> component : nonAPI.getComponentInstances()) {
                component.dropExtraItems(drop);
            }
        }
        if (masterHelper != null) {
            helper.getMultiblock().logic().dropExtraItems(masterHelper.getState(), drop);
        }
    }

    public static LootPoolSingletonContainer.Builder<?> builder() {
        return MultiblockDropsLootContainer.simpleBuilder(MultiblockDropsLootContainer::new);
    }

    public LootPoolEntryType getType() {
        return (LootPoolEntryType)IELootFunctions.MULTIBLOCK_DROPS.value();
    }
}

