/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.loot;

import blusunrize.immersiveengineering.common.blocks.wooden.WindmillBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.loot.IELootFunctions;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class WindmillLootFunction
extends LootItemConditionalFunction {
    public static final Codec<WindmillLootFunction> CODEC = RecordCodecBuilder.create(inst -> WindmillLootFunction.commonFields((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, WindmillLootFunction::new));

    protected WindmillLootFunction(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected ItemStack run(@Nonnull ItemStack stack, @Nonnull LootContext context) {
        BlockEntity bEntity;
        if (stack.getItem() == IEBlocks.WoodenDevices.WINDMILL.asItem() && context.hasParam(LootContextParams.BLOCK_ENTITY) && (bEntity = (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY)) instanceof WindmillBlockEntity) {
            WindmillBlockEntity windmill = (WindmillBlockEntity)bEntity;
            if (windmill.sails > 0) {
                ItemNBTHelper.putInt(stack, "sails", windmill.sails);
            }
        }
        return stack;
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)IELootFunctions.WINDMILL.value();
    }

    public static LootItemFunction.Builder builder() {
        return WindmillLootFunction.simpleBuilder(WindmillLootFunction::new);
    }
}

