/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.wires;

import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.WireApi;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.WireDamageHandler;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.ModConfigSpec;

public class IEWireTypes {
    public static double[] renderDiameter = new double[]{0.03125, 0.03125, 0.0625, 0.0625, 0.0625, 0.03125};
    public static ShockingWire COPPER;
    public static ShockingWire ELECTRUM;
    public static ShockingWire STEEL;
    public static WireType STRUCTURE_ROPE;
    public static WireType STRUCTURE_STEEL;
    public static WireType REDSTONE;
    public static EnergyWire COPPER_INSULATED;
    public static EnergyWire ELECTRUM_INSULATED;
    public static InternalConnection INTERNAL_CONNECTION;

    public static void modConstruction() {
        COPPER = new ShockingWire(IEWireType.COPPER);
        WireType.COPPER = COPPER;
        ELECTRUM = new ShockingWire(IEWireType.ELECTRUM);
        WireType.ELECTRUM = ELECTRUM;
        STEEL = new ShockingWire(IEWireType.STEEL);
        WireType.STEEL = STEEL;
        WireType.STRUCTURE_ROPE = STRUCTURE_ROPE = new BasicWire(IEWireType.STRUCTURE_ROPE);
        WireType.STRUCTURE_STEEL = STRUCTURE_STEEL = new BasicWire(IEWireType.STRUCTURE_STEEL);
        WireType.REDSTONE = REDSTONE = new BasicWire(IEWireType.REDSTONE);
        COPPER_INSULATED = new EnergyWire(IEWireType.COPPER_INSULATED);
        WireType.COPPER_INSULATED = COPPER_INSULATED;
        ELECTRUM_INSULATED = new EnergyWire(IEWireType.ELECTRUM_INSULATED);
        WireType.ELECTRUM_INSULATED = ELECTRUM_INSULATED;
        INTERNAL_CONNECTION = new InternalConnection();
        WireType.INTERNAL_CONNECTION = INTERNAL_CONNECTION;
    }

    public static void setup() {
        WireApi.registerFeedthroughForWiretype(COPPER, new ResourceLocation("immersiveengineering", "block/connector/connector_lv"), new double[]{0.0, 4.0, 8.0, 12.0}, 0.5, IEBlocks.Connectors.getEnergyConnector("LV", false).defaultBlockState());
        WireApi.registerFeedthroughForWiretype(ELECTRUM, new ResourceLocation("immersiveengineering", "block/connector/connector_mv"), new double[]{0.0, 4.0, 8.0, 12.0}, 0.5625, IEBlocks.Connectors.getEnergyConnector("MV", false).defaultBlockState());
        WireApi.registerFeedthroughForWiretype(STEEL, new ResourceLocation("immersiveengineering", "block/connector/connector_hv"), new double[]{0.0, 4.0, 8.0, 12.0}, 0.75, IEBlocks.Connectors.getEnergyConnector("HV", false).defaultBlockState());
        WireApi.registerFeedthroughForWiretype(REDSTONE, new ResourceLocation("immersiveengineering", "block/connector/connector_redstone"), new double[]{3.0, 8.0, 11.0, 16.0}, 0.5625, 0.5, IEBlocks.Connectors.CONNECTOR_REDSTONE.defaultBlockState());
    }

    private static class ShockingWire
    extends EnergyWire
    implements WireDamageHandler.IShockingWire {
        private final IElectricEquipment.ElectricSource eSource;

        public ShockingWire(IEWireType type) {
            super(type);
            this.eSource = this.getDamageRadius() > 0.0 ? new IElectricEquipment.ElectricSource(0.5f * (float)(1 + type.ordinal())) : new IElectricEquipment.ElectricSource(-1.0f);
        }

        @Override
        public double getDamageRadius() {
            return switch (this.type) {
                case IEWireType.COPPER -> 0.05;
                case IEWireType.ELECTRUM -> 0.1;
                case IEWireType.STEEL -> 0.3;
                default -> 0.0;
            };
        }

        @Override
        public IElectricEquipment.ElectricSource getElectricSource() {
            return this.eSource;
        }

        @Override
        public float getDamageAmount(Entity e, Connection c, int energy) {
            float factor;
            if (this == COPPER) {
                factor = 2.0f;
            } else if (this == ELECTRUM) {
                factor = 5.0f;
            } else if (this == STEEL) {
                factor = 15.0f;
            } else {
                throw new UnsupportedOperationException("");
            }
            return factor * (float)energy / (float)this.getTransferRate() * 8.0f;
        }

        @Override
        public Collection<ResourceLocation> getRequestedHandlers() {
            return ImmutableList.of((Object)WireDamageHandler.ID);
        }
    }

    public static enum IEWireType {
        COPPER("COPPER", null),
        ELECTRUM("ELECTRUM", null),
        STEEL("STEEL", null),
        STRUCTURE_ROPE("STRUCTURE_ROPE", null),
        STRUCTURE_STEEL("STRUCTURE_STEEL", null),
        REDSTONE("REDSTONE", null),
        COPPER_INSULATED("COPPER_INS", COPPER),
        ELECTRUM_INSULATED("ELECTRUM_INS", ELECTRUM);

        public final String uniqueName;
        public final IEWireType energyBaseType;

        private IEWireType(String name, IEWireType base) {
            this.uniqueName = name;
            this.energyBaseType = base != null ? base : this;
        }
    }

    private static class BasicWire
    extends WireType {
        final IEWireType type;
        final IEServerConfig.Wires.WireConfig config;
        final ModConfigSpec.IntValue color;

        public BasicWire(IEWireType type) {
            this.type = type;
            WireApi.registerWireType(this);
            this.config = IEServerConfig.WIRES.wireConfigs.get((Object)type);
            this.color = IEClientConfig.wireColors.get((Object)type);
        }

        @Override
        public int getColour(Connection connection) {
            return (Integer)this.color.get();
        }

        @Override
        public double getSlack() {
            return 1.005;
        }

        @Override
        public int getMaxLength() {
            return (Integer)this.config.maxLength.get();
        }

        @Override
        public ItemStack getWireCoil(Connection con) {
            return new ItemStack((ItemLike)IEItems.Misc.WIRE_COILS.get(this), 1);
        }

        @Override
        public String getUniqueName() {
            return this.type.uniqueName;
        }

        @Override
        public double getRenderDiameter() {
            return renderDiameter[this.type.ordinal() % 6];
        }

        @Override
        @Nonnull
        public String getCategory() {
            return switch (this.type) {
                default -> throw new IncompatibleClassChangeError();
                case IEWireType.COPPER, IEWireType.COPPER_INSULATED -> "LV";
                case IEWireType.ELECTRUM, IEWireType.ELECTRUM_INSULATED -> "MV";
                case IEWireType.STEEL -> "HV";
                case IEWireType.STRUCTURE_ROPE, IEWireType.STRUCTURE_STEEL -> "STRUCTURE";
                case IEWireType.REDSTONE -> "REDSTONE";
            };
        }

        @Override
        public Collection<ResourceLocation> getRequestedHandlers() {
            return ImmutableList.of();
        }
    }

    private static class EnergyWire
    extends BasicWire
    implements EnergyTransferHandler.IEnergyWire {
        private final IEServerConfig.Wires.EnergyWireConfig config;

        public EnergyWire(IEWireType type) {
            super(type);
            this.config = IEServerConfig.WIRES.energyWireConfigs.get((Object)type.energyBaseType);
        }

        public double getLossRatio() {
            return (Double)this.config.lossRatio.get();
        }

        @Override
        public int getTransferRate() {
            return (Integer)this.config.transferRate.get();
        }

        @Override
        public double getBasicLossRate(Connection c) {
            return this.getLossRatio() * c.getLength() / (double)this.getMaxLength();
        }

        @Override
        public double getLossRate(Connection c, int transferred) {
            return 0.0;
        }
    }

    private static class InternalConnection
    extends WireType {
        private InternalConnection() {
        }

        @Override
        public String getUniqueName() {
            return "INTERNAL";
        }

        @Override
        public int getColour(Connection connection) {
            return 0;
        }

        @Override
        public double getSlack() {
            return 1.001;
        }

        @Override
        public int getMaxLength() {
            return 0;
        }

        @Override
        public ItemStack getWireCoil(Connection con) {
            return ItemStack.EMPTY;
        }

        @Override
        public double getRenderDiameter() {
            return 0.0;
        }

        @Override
        @Nonnull
        public String getCategory() {
            return "INTERNAL";
        }
    }
}

