/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.wires;

import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.proxy.DefaultProxyProvider;
import blusunrize.immersiveengineering.common.register.IEDataAttachments;
import blusunrize.immersiveengineering.common.wires.WireSyncManager;
import blusunrize.immersiveengineering.mixin.accessors.DataStorageAccess;
import java.io.File;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;

public class WireNetworkCreator {
    public static final IAttachmentSerializer<CompoundTag, GlobalWireNetwork> SERIALIZER = new Serializer();
    public static final Function<IAttachmentHolder, GlobalWireNetwork> CREATOR = holder -> {
        if (holder instanceof Level) {
            Level level = (Level)holder;
            return new GlobalWireNetwork(level.isClientSide, new DefaultProxyProvider(level), new WireSyncManager(level));
        }
        throw new RuntimeException("Wire networks should only ever be attached to levels, got " + holder);
    };
    private static final String SAVEDATA_KEY = "immersiveengineering_wire_network";

    public static GlobalWireNetwork getOrCreateNetwork(Level level) {
        WireNetworkCreator.replaceOldWireNetwork(level);
        return (GlobalWireNetwork)level.getData(IEDataAttachments.WIRE_NETWORK.get());
    }

    private static void replaceOldWireNetwork(Level level) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        SavedData.Factory factory = new SavedData.Factory(() -> {
            throw new UnsupportedOperationException();
        }, nbt -> {
            if (nbt.isEmpty()) {
                return null;
            }
            return (GlobalWireNetwork)SERIALIZER.read((IAttachmentHolder)level, (Tag)nbt);
        });
        DimensionDataStorage dataStorage = serverLevel.getDataStorage();
        GlobalWireNetwork oldNet = (GlobalWireNetwork)dataStorage.get(factory, SAVEDATA_KEY);
        if (oldNet == null) {
            return;
        }
        level.setData(IEDataAttachments.WIRE_NETWORK.get(), (Object)oldNet);
        DataStorageAccess access = (DataStorageAccess)dataStorage;
        access.getCache().remove(SAVEDATA_KEY);
        File fileToRemove = access.invokeGetDataFile(SAVEDATA_KEY);
        if (fileToRemove.exists() && !fileToRemove.delete()) {
            throw new RuntimeException("Failed to remove old IE wire network data at " + fileToRemove.getAbsolutePath());
        }
    }

    private static class Serializer
    implements IAttachmentSerializer<CompoundTag, GlobalWireNetwork> {
        private Serializer() {
        }

        @Nullable
        public CompoundTag write(GlobalWireNetwork attachment) {
            return attachment.save(new CompoundTag());
        }

        @Nonnull
        public GlobalWireNetwork read(@Nonnull IAttachmentHolder holder, @Nonnull CompoundTag tag) {
            GlobalWireNetwork baseNet = CREATOR.apply(holder);
            baseNet.readFromNBT(tag);
            return baseNet;
        }
    }
}

