/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.wires;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IWireSyncManager;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.common.network.MessageWireSync;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="immersiveengineering")
public class WireSyncManager
implements IWireSyncManager {
    private static final SetMultimap<UUID, ChunkPos> wireWatchedChunksByPlayer = HashMultimap.create();
    private final Level world;

    private static void sendMessagesForChunk(Level w, ChunkPos pos, ServerPlayer player, boolean add) {
        GlobalWireNetwork net = GlobalWireNetwork.getNetwork(w);
        Collection<ConnectionPoint> connsInChunk = net.getAllConnectorsIn(pos);
        MessageWireSync.Operation operation = add ? MessageWireSync.Operation.ADD : MessageWireSync.Operation.REMOVE;
        for (ConnectionPoint cp : connsInChunk) {
            for (Connection conn : net.getLocalNet(cp).getConnections(cp)) {
                if (!WireSyncManager.shouldSendConnection(conn, pos, player, add, cp)) continue;
                WireLogger.logger.info("Sending connection {} ({}) for chunk change at {}", (Object)conn, (Object)add, (Object)pos);
                PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new MessageWireSync(conn, operation)});
            }
        }
    }

    private static boolean shouldSendConnection(Connection conn, ChunkPos pos, ServerPlayer player, boolean add, ConnectionPoint currEnd) {
        if (conn.isInternal()) {
            return false;
        }
        ConnectionPoint other = conn.getOtherEnd(currEnd);
        ChunkPos otherChunk = new ChunkPos(other.position());
        if (otherChunk.equals((Object)pos)) {
            return conn.isPositiveEnd(currEnd);
        }
        return wireWatchedChunksByPlayer.containsEntry((Object)player.getUUID(), (Object)otherChunk);
    }

    private static void addPlayersTrackingPoint(Set<ServerPlayer> receivers, int x, int z, ServerLevel world) {
        ServerChunkCache chunkProvider = world.getChunkSource();
        for (ServerPlayer e : chunkProvider.chunkMap.getPlayers(new ChunkPos(x >> 4, z >> 4), false)) {
            WireLogger.logger.debug("Watching player for {}, {}: {}", (Object)x, (Object)z, (Object)e);
            receivers.add(e);
        }
    }

    private static void sendToPlayersForConnection(MessageWireSync.Operation operation, Level level, Connection connection) {
        if (connection.isInternal() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ApiUtils.addFutureServerTask((Level)serverLevel, () -> {
            HashSet<ServerPlayer> targets = new HashSet<ServerPlayer>();
            WireSyncManager.addPlayersTrackingPoint(targets, connection.getEndA().getX(), connection.getEndA().getZ(), serverLevel);
            WireSyncManager.addPlayersTrackingPoint(targets, connection.getEndB().getX(), connection.getEndB().getZ(), serverLevel);
            MessageWireSync msg = new MessageWireSync(connection, operation);
            for (ServerPlayer p : targets) {
                PacketDistributor.PLAYER.with((Object)p).send(new CustomPacketPayload[]{msg});
            }
        }, true);
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Watch ev) {
        ApiUtils.addFutureServerTask((Level)ev.getLevel(), () -> {
            if (wireWatchedChunksByPlayer.put((Object)ev.getPlayer().getUUID(), (Object)ev.getPos())) {
                WireSyncManager.sendMessagesForChunk((Level)ev.getLevel(), ev.getPos(), ev.getPlayer(), true);
            }
        }, true);
    }

    @SubscribeEvent
    public static void onChunkUnWatch(ChunkWatchEvent.UnWatch ev) {
        ApiUtils.addFutureServerTask((Level)ev.getLevel(), () -> {
            if (wireWatchedChunksByPlayer.remove((Object)ev.getPlayer().getUUID(), (Object)ev.getPos())) {
                WireSyncManager.sendMessagesForChunk((Level)ev.getLevel(), ev.getPos(), ev.getPlayer(), false);
            }
        }, true);
    }

    public WireSyncManager(Level world) {
        this.world = world;
    }

    @Override
    public void onConnectionAdded(Connection c) {
        WireSyncManager.sendToPlayersForConnection(MessageWireSync.Operation.ADD, this.world, c);
    }

    @Override
    public void onConnectionRemoved(Connection c) {
        WireSyncManager.sendToPlayersForConnection(MessageWireSync.Operation.REMOVE, this.world, c);
    }

    @Override
    public void onConnectionEndpointsChanged(Connection c) {
        WireSyncManager.sendToPlayersForConnection(MessageWireSync.Operation.UPDATE, this.world, c);
    }
}

