/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.ManualScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Lazy;
import org.joml.Quaternionf;

public class ManualElementEntity
extends SpecialManualElements {
    private final Lazy<RenderData> renderData = Lazy.of(() -> new RenderData(entityType, entityData));

    public ManualElementEntity(ManualInstance helper, EntityType<?> entityType, @Nullable CompoundTag entityData) {
        super(helper);
    }

    @Override
    public void render(GuiGraphics graphics, ManualScreen gui, int x, int y, int mx, int my) {
        Entity entity = ((RenderData)this.renderData.get()).entity;
        float yOff = ((RenderData)this.renderData.get()).ySize - 4;
        float scale = ((RenderData)this.renderData.get()).scale;
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushPose();
        modelViewStack.mulPoseMatrix(graphics.pose().last().pose());
        modelViewStack.translate((float)(x + 60), (float)y + yOff, 50.0f);
        modelViewStack.scale(-scale, scale, scale);
        PoseStack mobPoseStack = new PoseStack();
        mobPoseStack.mulPose(new Quaternionf().rotateAxis((float)Math.PI, 0.0f, 0.0f, 1.0f));
        float pitch = yOff / 2.0f - (float)my;
        float yaw = 60 - mx;
        mobPoseStack.mulPose(new Quaternionf().rotateAxis((float)Math.atan(pitch / 40.0f), -1.0f, 0.0f, 0.0f));
        entity.yo = (float)Math.atan(yaw / 40.0f) * 20.0f;
        float yRot = (float)Math.atan(yaw / 40.0f) * 40.0f;
        float xRot = -((float)Math.atan(pitch / 40.0f)) * 20.0f;
        entity.setYRot(yRot);
        entity.setYRot(yRot);
        entity.setXRot(xRot);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).yHeadRot = yRot;
            ((LivingEntity)entity).yHeadRotO = yRot;
            ((LivingEntity)entity).yBodyRot = yRot;
        }
        RenderSystem.applyModelViewMatrix();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        entityRenderDispatcher.setRenderShadow(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, mobPoseStack, (MultiBufferSource)bufferSource, 0xF000F0));
        bufferSource.endBatch();
        entityRenderDispatcher.setRenderShadow(true);
        modelViewStack.popPose();
        RenderSystem.applyModelViewMatrix();
    }

    @Override
    public boolean listForSearch(String searchTag) {
        return false;
    }

    @Override
    public int getPixelsTaken() {
        return ((RenderData)this.renderData.get()).ySize;
    }

    private static class RenderData {
        final Entity entity;
        final float entitySize;
        final float scale;
        final int ySize;

        RenderData(EntityType<?> entityType, CompoundTag entityData) {
            this.entity = entityType.create((Level)Minecraft.getInstance().level);
            if (entityData != null) {
                this.entity.load(entityData);
            }
            this.entitySize = Math.max(this.entity.getBbWidth(), this.entity.getBbHeight());
            this.scale = this.entitySize <= 1.0f ? 36.0f : (this.entitySize <= 3.0f ? 28.0f : 26.0f - this.entitySize);
            this.ySize = this.entitySize <= 2.0f ? 60 : 90;
        }
    }
}

