/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.gui.ManualScreen;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;

public class GuiButtonManualLink
extends Button {
    public String localized;
    @Nullable
    public ManualInstance.ManualLink link;
    ManualScreen gui;
    public List<GuiButtonManualLink> otherParts = ImmutableList.of();

    public GuiButtonManualLink(ManualScreen gui, int x, int y, int w, int h, @Nullable ManualInstance.ManualLink link, String localized) {
        super(x, y, w, h, (Component)Component.empty(), btn -> {
            if (link != null) {
                link.changePage(gui, true);
            }
        }, DEFAULT_NARRATION);
        this.gui = gui;
        this.link = link;
        this.localized = localized;
        if (gui.manual.improveReadability()) {
            this.localized = ChatFormatting.BOLD + localized;
        }
    }

    public void renderWidget(GuiGraphics graphics, int mx, int my, float partialTicks) {
        boolean bl = this.isHovered = mx >= this.getX() && my >= this.getY() && mx < this.getX() + this.width && my < this.getY() + this.height;
        if (this.isHovered) {
            this.drawHovered(graphics, mx, my);
            for (GuiButtonManualLink btn : this.otherParts) {
                if (btn == this) continue;
                btn.drawHovered(graphics, mx, my);
            }
        }
    }

    private void drawHovered(GuiGraphics graphics, int mx, int my) {
        Font font = this.gui.manual.fontRenderer();
        graphics.drawString(font, this.localized, this.getX(), this.getY(), this.gui.manual.getHighlightColour(), false);
        String tooltip = this.link != null ? this.gui.manual.formatLink(this.link) : "Invalid link";
        graphics.renderTooltip(font, Language.getInstance().getVisualOrder((List)ImmutableList.of((Object)Component.literal((String)tooltip))), mx + 8, my + 4);
    }
}

