/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.block;

import de.cech12.solarcooker.Constants;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ReflectorBlock
extends Block {
    public static final IntegerProperty TYPE = IntegerProperty.create((String)"type", (int)1, (int)15);
    protected static final List<Integer> TYPES_WITH_ONE_REFLECTOR = Arrays.asList(1, 2, 4, 8);
    protected static final List<Integer> TYPES_WITH_TWO_REFLECTORS = Arrays.asList(3, 5, 6, 9, 10, 12);
    protected static final List<Integer> TYPES_WITH_THREE_REFLECTORS = Arrays.asList(7, 11, 13, 14);
    protected static final List<Integer> TYPES_WITH_FOUR_REFLECTORS = Collections.singletonList(15);
    protected static final VoxelShape SHAPE_NORTH_WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)5.0);
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)5.0);
    protected static final VoxelShape SHAPE_NORTH_EAST = Block.box((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0);
    protected static final VoxelShape SHAPE_EAST = Block.box((double)11.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);
    protected static final VoxelShape SHAPE_SOUTH_EAST = Block.box((double)11.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.box((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH_WEST = Block.box((double)0.0, (double)0.0, (double)11.0, (double)5.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)0.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0);
    protected static final VoxelShape[] SHAPES = ReflectorBlock.makeShapes();

    private static VoxelShape[] makeShapes() {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(type -> {
            HashSet<VoxelShape> shapes = new HashSet<VoxelShape>();
            if ((type | 8) == type) {
                shapes.add(SHAPE_NORTH_WEST);
                shapes.add(SHAPE_NORTH);
                shapes.add(SHAPE_NORTH_EAST);
            }
            if ((type | 4) == type) {
                shapes.add(SHAPE_NORTH_EAST);
                shapes.add(SHAPE_EAST);
                shapes.add(SHAPE_SOUTH_EAST);
            }
            if ((type | 2) == type) {
                shapes.add(SHAPE_SOUTH_EAST);
                shapes.add(SHAPE_SOUTH);
                shapes.add(SHAPE_SOUTH_WEST);
            }
            if ((type | 1) == type) {
                shapes.add(SHAPE_SOUTH_WEST);
                shapes.add(SHAPE_WEST);
                shapes.add(SHAPE_NORTH_WEST);
            }
            VoxelShape voxelshape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            for (VoxelShape shape : shapes) {
                voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)shape);
            }
            return voxelshape;
        }).toArray(VoxelShape[]::new);
    }

    public static int getType(Direction direction) {
        return switch (direction) {
            case Direction.EAST -> 4;
            case Direction.SOUTH -> 2;
            case Direction.WEST -> 1;
            default -> 8;
        };
    }

    public static boolean isFacingTo(BlockState blockstate, Direction direction) {
        if (direction != Direction.UP && direction != Direction.DOWN) {
            int type = (Integer)blockstate.getValue((Property)TYPE);
            return (type | ReflectorBlock.getType(direction)) == type;
        }
        return false;
    }

    private static int getCount(int type) {
        if (TYPES_WITH_ONE_REFLECTOR.contains(type)) {
            return 1;
        }
        if (TYPES_WITH_TWO_REFLECTORS.contains(type)) {
            return 2;
        }
        if (TYPES_WITH_THREE_REFLECTORS.contains(type)) {
            return 3;
        }
        if (TYPES_WITH_FOUR_REFLECTORS.contains(type)) {
            return 4;
        }
        return 1;
    }

    public ReflectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)Integer.valueOf(ReflectorBlock.getType(Direction.NORTH))));
    }

    @Nonnull
    public List<ItemStack> getDrops(@Nonnull BlockState state, @Nonnull LootParams.Builder context) {
        ItemStack stack;
        List drops = super.getDrops(state, context);
        int count = ReflectorBlock.getCount((Integer)state.getValue((Property)TYPE));
        if (!drops.isEmpty() && count > 1 && (stack = (ItemStack)drops.get(0)).getItem().equals(Constants.REFLECTOR_ITEM.get())) {
            stack.setCount(count);
        }
        return drops;
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nullable BlockGetter worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.solarcooker.reflector.description").withStyle(ChatFormatting.BLUE));
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPES[(Integer)state.getValue((Property)TYPE)];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        Direction direction = context.getHorizontalDirection().getOpposite();
        if (blockstate.is((Block)this)) {
            return (BlockState)blockstate.setValue((Property)TYPE, (Comparable)Integer.valueOf((Integer)blockstate.getValue((Property)TYPE) | ReflectorBlock.getType(direction)));
        }
        return (BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)Integer.valueOf(ReflectorBlock.getType(direction)));
    }

    public boolean canBeReplaced(@Nonnull BlockState state, BlockPlaceContext context) {
        return context.getItemInHand().getItem() == this.asItem() && !ReflectorBlock.isFacingTo(state, context.getHorizontalDirection().getOpposite()) || super.canBeReplaced(state, context);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        int bits;
        if (direction == Rotation.CLOCKWISE_90) {
            bits = 1;
        } else if (direction == Rotation.CLOCKWISE_180) {
            bits = 2;
        } else if (direction == Rotation.COUNTERCLOCKWISE_90) {
            bits = 3;
        } else {
            return state;
        }
        int type = (Integer)state.getValue((Property)TYPE);
        int rotated = (type >> bits | type << 4 - bits) & 0xF;
        return (BlockState)state.setValue((Property)TYPE, (Comparable)Integer.valueOf(rotated));
    }
}

