/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.cech12.solarcooker.Constants;
import de.cech12.solarcooker.block.AbstractSolarCookerBlock;
import de.cech12.solarcooker.blockentity.SolarCookerBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SolarCookerBlockEntityRenderer
implements BlockEntityRenderer<SolarCookerBlockEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("solarcooker", "textures/entity/solar_cooker.png");
    private static final LayerDefinition innerCube = SolarCookerBlockEntityRenderer.createInnerLayerDefinition();
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart inner;
    private final ModelPart lock;

    private static LayerDefinition createInnerLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("inner", CubeListBuilder.create().texOffs(0, 43).addBox(3.0f, 2.0f, 3.0f, 10.0f, 8.0f, 10.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public SolarCookerBlockEntityRenderer(BlockEntityRendererProvider.Context rendererProvider) {
        ModelPart modelpart = rendererProvider.bakeLayer(ModelLayers.CHEST);
        this.bottom = modelpart.getChild("bottom");
        this.lid = modelpart.getChild("lid");
        this.lock = modelpart.getChild("lock");
        this.inner = innerCube.bakeRoot().getChild("inner");
    }

    public void render(SolarCookerBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Level world = blockEntity.getLevel();
        boolean isInWorld = world != null;
        BlockState blockstate = isInWorld ? blockEntity.getBlockState() : (BlockState)Constants.SOLAR_COOKER_BLOCK.get().defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        Block block = blockstate.getBlock();
        if (block instanceof AbstractSolarCookerBlock) {
            ItemStack stack;
            matrixStackIn.pushPose();
            float f = ((Direction)blockstate.getValue((Property)AbstractSolarCookerBlock.FACING)).toYRot();
            matrixStackIn.translate(0.5, 0.5, 0.5);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(-f));
            matrixStackIn.translate(-0.5, -0.5, -0.5);
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE));
            float lidAngle = blockEntity.getOpenNess(partialTicks);
            this.renderModels(matrixStackIn, ivertexbuilder, this.lid, this.lock, this.bottom, this.inner, lidAngle, combinedLightIn, combinedOverlayIn);
            if (isInWorld && !(stack = blockEntity.getItem(0)).isEmpty()) {
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.5, 0.4, 0.5);
                Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, world, 0);
                matrixStackIn.popPose();
            }
            matrixStackIn.popPose();
        }
    }

    private void renderModels(PoseStack matrixStackIn, VertexConsumer bufferIn, ModelPart chestLid, ModelPart chestLatch, ModelPart chestBottom, ModelPart chestInner, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
        chestLatch.xRot = chestLid.xRot = -(lidAngle * 1.5707964f);
        chestLid.render(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        chestLatch.render(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        chestBottom.render(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        chestInner.render(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }
}

