/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.client;

import de.cech12.solarcooker.inventory.SolarCookerContainer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SolarCookerScreen
extends AbstractContainerScreen<SolarCookerContainer> {
    private static final ResourceLocation guiTexture = new ResourceLocation("solarcooker", "textures/gui/container/solar_cooker.png");

    public SolarCookerScreen(SolarCookerContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    public void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        if (this.minecraft != null) {
            int left = this.leftPos;
            int top = this.topPos;
            guiGraphics.blit(guiTexture, left, top, 0, 0, this.imageWidth, this.imageHeight);
            if (((SolarCookerContainer)this.menu).isBurning()) {
                guiGraphics.blit(guiTexture, left + 56, top + 36, 176, 0, 14, 14);
            }
            int progress = ((SolarCookerContainer)this.menu).getCookProgressionScaled();
            guiGraphics.blit(guiTexture, left + 79, top + 34, 176, 14, progress + 1, 16);
            if (((SolarCookerContainer)this.menu).isSunlit()) {
                guiGraphics.blit(guiTexture, left + 55, top + 52, 176, 31, 18, 18);
            }
        }
    }
}

