/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.shinealsprehistoricexpansion.world.features.treedecorators;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.mcreator.shinealsprehistoricexpansion.init.ShinealsPrehistoricExpansionModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.CocoaDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class JuniperForestFruitDecorator
extends CocoaDecorator {
    public static Codec<JuniperForestFruitDecorator> CODEC = Codec.unit(JuniperForestFruitDecorator::new);
    public static TreeDecoratorType<?> DECORATOR_TYPE = new TreeDecoratorType(CODEC);

    @SubscribeEvent
    public static void registerTreeDecorator(RegisterEvent event) {
        event.register(Registries.TREE_DECORATOR_TYPE, new ResourceLocation("shineals_prehistoric_expansion:juniper_forest_tree_fruit_decorator"), () -> DECORATOR_TYPE);
    }

    public JuniperForestFruitDecorator() {
        super(0.2f);
    }

    protected TreeDecoratorType<?> type() {
        return DECORATOR_TYPE;
    }

    public void place(TreeDecorator.Context context) {
        RandomSource randomsource = context.random();
        if (!(randomsource.nextFloat() >= 0.2f)) {
            ObjectArrayList list = context.logs();
            int i = ((BlockPos)list.get(0)).getY();
            list.stream().filter(p_69980_ -> p_69980_.getY() - i <= 2).forEach(p_226026_ -> {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    Direction direction1;
                    BlockPos blockpos;
                    if (!(randomsource.nextFloat() <= 0.25f) || !context.isAir(blockpos = p_226026_.offset((direction1 = direction.getOpposite()).getStepX(), 0, direction1.getStepZ()))) continue;
                    context.setBlock(blockpos, JuniperForestFruitDecorator.oriented(((Block)ShinealsPrehistoricExpansionModBlocks.JUNIPER_BERRY_BUSH.get()).defaultBlockState(), direction1));
                }
            });
        }
    }

    private static BlockState oriented(BlockState blockstate, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> blockstate.getBlock().rotate(blockstate, Rotation.CLOCKWISE_180);
            case Direction.EAST -> blockstate.getBlock().rotate(blockstate, Rotation.CLOCKWISE_90);
            case Direction.WEST -> blockstate.getBlock().rotate(blockstate, Rotation.COUNTERCLOCKWISE_90);
            default -> blockstate;
        };
    }
}

