/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.shinealsprehistoricexpansion.world.features.treedecorators;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TrunkVineDecorator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class JuniperForestTrunkDecorator
extends TrunkVineDecorator {
    public static Codec<JuniperForestTrunkDecorator> CODEC = Codec.unit(JuniperForestTrunkDecorator::new);
    public static TreeDecoratorType<?> DECORATOR_TYPE = new TreeDecoratorType(CODEC);

    @SubscribeEvent
    public static void registerTreeDecorator(RegisterEvent event) {
        event.register(Registries.TREE_DECORATOR_TYPE, new ResourceLocation("shineals_prehistoric_expansion:juniper_forest_tree_trunk_decorator"), () -> DECORATOR_TYPE);
    }

    protected TreeDecoratorType<?> type() {
        return DECORATOR_TYPE;
    }

    public void place(TreeDecorator.Context context) {
        context.logs().forEach(blockpos -> {
            BlockPos pos;
            if (context.random().nextInt(3) > 0 && context.isAir(pos = blockpos.west())) {
                context.setBlock(pos, JuniperForestTrunkDecorator.oriented(Blocks.VINE.defaultBlockState(), Direction.EAST));
            }
            if (context.random().nextInt(3) > 0 && context.isAir(pos = blockpos.east())) {
                context.setBlock(pos, JuniperForestTrunkDecorator.oriented(Blocks.VINE.defaultBlockState(), Direction.WEST));
            }
            if (context.random().nextInt(3) > 0 && context.isAir(pos = blockpos.north())) {
                context.setBlock(pos, JuniperForestTrunkDecorator.oriented(Blocks.VINE.defaultBlockState(), Direction.SOUTH));
            }
            if (context.random().nextInt(3) > 0 && context.isAir(pos = blockpos.south())) {
                context.setBlock(pos, JuniperForestTrunkDecorator.oriented(Blocks.VINE.defaultBlockState(), Direction.NORTH));
            }
        });
    }

    private static BlockState oriented(BlockState blockstate, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> blockstate.getBlock().rotate(blockstate, Rotation.CLOCKWISE_180);
            case Direction.EAST -> blockstate.getBlock().rotate(blockstate, Rotation.CLOCKWISE_90);
            case Direction.WEST -> blockstate.getBlock().rotate(blockstate, Rotation.COUNTERCLOCKWISE_90);
            default -> blockstate;
        };
    }
}

