/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot;

import java.util.List;
import java.util.Objects;
import net.creeperhost.blockshot.mixin.MixinChatComponent;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class ClientUtil {
    public static void sendMessage(Component component, MessageSignature messageSignature) {
        ClientUtil.sendMessage(component, messageSignature, false);
    }

    public static void sendMessage(Component component, MessageSignature messageSignature, boolean quietly) {
        if (!ClientUtil.validState()) {
            return;
        }
        ClientUtil.deleteMessage(messageSignature);
        if (quietly) {
            ClientUtil.addMessageQuietly(component, messageSignature, Minecraft.getInstance().gui.getGuiTicks(), null, false);
        } else {
            ClientUtil.getChat().addMessage(component, messageSignature, null);
        }
    }

    public static void sendMessage(Component component) {
        ClientUtil.sendMessage(component, false);
    }

    public static void sendMessage(Component component, boolean quietly) {
        if (!ClientUtil.validState()) {
            return;
        }
        if (quietly) {
            ClientUtil.addMessageQuietly(component, null, Minecraft.getInstance().gui.getGuiTicks(), null, false);
        } else {
            ClientUtil.getChat().addMessage(component);
        }
    }

    private static ChatComponent getChat() {
        return Minecraft.getInstance().gui.getChat();
    }

    public static boolean validState() {
        return Minecraft.getInstance() != null && ClientUtil.getChat() != null;
    }

    public static void deleteMessage(MessageSignature messageSignature) {
        if (!ClientUtil.validState()) {
            return;
        }
        MixinChatComponent chat = (MixinChatComponent)ClientUtil.getChat();
        chat.getAllMessages().removeIf(e -> Objects.equals(e.signature(), messageSignature));
        chat.getTrimmedMessages().clear();
        for (int i = chat.getAllMessages().size() - 1; i >= 0; --i) {
            GuiMessage guiMessage = chat.getAllMessages().get(i);
            ClientUtil.addMessageQuietly(guiMessage.content(), guiMessage.signature(), guiMessage.addedTime(), guiMessage.tag(), true);
        }
    }

    public static void addMessageQuietly(Component component, @Nullable MessageSignature messageSignature, int i, @Nullable GuiMessageTag guiMessageTag, boolean updateOnly) {
        ChatComponent chat = ClientUtil.getChat();
        MixinChatComponent chatMix = (MixinChatComponent)chat;
        int j = Mth.floor((double)((double)chat.getWidth() / chat.getScale()));
        if (guiMessageTag != null && guiMessageTag.icon() != null) {
            j -= guiMessageTag.icon().width + 4 + 2;
        }
        List list = ComponentRenderUtils.wrapComponents((FormattedText)component, (int)j, (Font)Minecraft.getInstance().font);
        boolean bl2 = chatMix.invokereisChatFocused();
        for (int k = 0; k < list.size(); ++k) {
            FormattedCharSequence formattedCharSequence = (FormattedCharSequence)list.get(k);
            if (bl2 && chatMix.getChatScrollbarPos() > 0) {
                chatMix.setNewMessageSinceScroll(true);
                chat.scrollChat(1);
            }
            boolean bl3 = k == list.size() - 1;
            chatMix.getTrimmedMessages().add(0, new GuiMessage.Line(i, formattedCharSequence, guiMessageTag, bl3));
        }
        while (chatMix.getTrimmedMessages().size() > 100) {
            chatMix.getTrimmedMessages().remove(chatMix.getTrimmedMessages().size() - 1);
        }
        if (!updateOnly) {
            chatMix.getAllMessages().add(0, new GuiMessage(i, component, messageSignature, guiMessageTag));
            while (chatMix.getAllMessages().size() > 100) {
                chatMix.getAllMessages().remove(chatMix.getAllMessages().size() - 1);
            }
        }
    }
}

