/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.creeperhost.blockshot.BlockShot;
import net.creeperhost.blockshot.capture.Encoder;
import net.creeperhost.blockshot.capture.GifEncoder;
import net.creeperhost.blockshot.capture.RecordingHandler;
import net.creeperhost.blockshot.capture.VideoEncoder;
import org.apache.commons.io.IOUtils;

public class Config {
    public static Config INSTANCE;
    public Mode uploadMode = Mode.PROMPT;
    public ButtonPos buttonPos = ButtonPos.BOTTOM_LEFT;
    private EncoderType encoderType = EncoderType.GIF;
    public boolean anonymous;

    public Config() {
        this.anonymous = true;
    }

    public Config(Mode mode) {
        this.uploadMode = mode;
    }

    public Config(Mode mode, boolean anonymous) {
        this.uploadMode = mode;
        this.anonymous = anonymous;
    }

    public void setEncoderType(EncoderType encoderType) {
        if (RecordingHandler.setEncoder(encoderType.createEncoder())) {
            this.encoderType = encoderType;
        }
    }

    public EncoderType getEncoderType() {
        return this.encoderType;
    }

    public static String saveConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return gson.toJson((Object)INSTANCE);
    }

    public static void loadFromFile(File file) {
        Gson gson = new Gson();
        try {
            FileReader fileReader = new FileReader(file);
            INSTANCE = (Config)gson.fromJson((Reader)fileReader, Config.class);
            if (Config.INSTANCE.uploadMode == null) {
                Config.INSTANCE.uploadMode = Mode.PROMPT;
            }
        }
        catch (Exception ex) {
            BlockShot.LOGGER.error("Failed to load config, Resetting to default", (Throwable)ex);
            INSTANCE = new Config();
            Config.saveConfigToFile(BlockShot.configLocation.toFile());
        }
    }

    public static void saveConfigToFile(File file) {
        try (FileOutputStream configOut = new FileOutputStream(file);){
            IOUtils.write((String)Config.saveConfig(), (OutputStream)configOut, (Charset)Charset.defaultCharset());
        }
        catch (Throwable ex) {
            BlockShot.LOGGER.error("An error occurred while saving config to file", ex);
        }
    }

    public static void init(File file) {
        try {
            if (!file.exists()) {
                INSTANCE = new Config();
                FileWriter tileWriter = new FileWriter(file);
                tileWriter.write(Config.saveConfig());
                tileWriter.close();
            } else {
                Config.loadFromFile(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum Mode {
        OFF,
        PROMPT,
        AUTO;


        public Mode next() {
            return Mode.values()[(this.ordinal() + 1) % Mode.values().length];
        }

        public String translatableName() {
            return "gui.blockshot.settings.upload_mode." + this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum ButtonPos {
        TOP_LEFT((sw, bw) -> 10, (sh, bh) -> 10),
        TOP_RIGHT((sw, bw) -> sw - bw - 10, (sh, bh) -> 10),
        BOTTOM_LEFT((sw, bw) -> 10, (sh, bh) -> sh - bh - 10),
        BOTTOM_RIGHT((sw, bw) -> sw - bw - 10, (sh, bh) -> sh - bh - 10);

        private final BiFunction<Integer, Integer, Integer> xGetter;
        private final BiFunction<Integer, Integer, Integer> yGetter;

        private ButtonPos(BiFunction<Integer, Integer, Integer> xGetter, BiFunction<Integer, Integer, Integer> yGetter) {
            this.xGetter = xGetter;
            this.yGetter = yGetter;
        }

        public ButtonPos next() {
            return ButtonPos.values()[(this.ordinal() + 1) % ButtonPos.values().length];
        }

        public String translatableName() {
            return "gui.blockshot.settings.button_pos." + this.name().toLowerCase(Locale.ENGLISH);
        }

        public int getX(int screenWidth, int buttonWidth) {
            return this.xGetter.apply(screenWidth, buttonWidth);
        }

        public int getY(int screenHeight, int buttonHeight) {
            return this.yGetter.apply(screenHeight, buttonHeight);
        }
    }

    public static enum EncoderType {
        GIF(GifEncoder::new, false),
        MOV(VideoEncoder::new, true);

        private final Supplier<Encoder> getEncoder;
        private final boolean requiresPremium;

        private EncoderType(Supplier<Encoder> getEncoder, boolean requiresPremium) {
            this.getEncoder = getEncoder;
            this.requiresPremium = requiresPremium;
        }

        public Encoder createEncoder() {
            return this.getEncoder.get();
        }

        public boolean requiresPremium() {
            return this.requiresPremium;
        }
    }
}

