/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot;

import com.google.common.util.concurrent.AtomicDouble;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import net.creeperhost.blockshot.Config;
import net.creeperhost.blockshot.lib.TrackableByteArrayEntity;
import net.creeperhost.blockshot.repack.net.creeperhost.minetogether.session.MineTogetherSession;
import net.minecraft.client.Minecraft;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class WebUtils {
    public static final Logger LOGGER = LogManager.getLogger();

    public static String get(String url, @Nullable AtomicDouble progress) {
        return WebUtils.executeWebRequest((HttpUriRequest)new HttpGet(url), null, progress, true);
    }

    public static String post(String url, String data, MediaType type, @Nullable AtomicDouble progress) {
        byte[] postData = data.getBytes(StandardCharsets.UTF_8);
        HttpPost httppost = new HttpPost(url);
        httppost.setEntity((HttpEntity)new TrackableByteArrayEntity(postData, progress));
        httppost.setHeader("charset", "utf-8");
        return WebUtils.executeWebRequest((HttpUriRequest)httppost, type, null, true);
    }

    public static String post(String url, byte[] bytes, MediaType type, @Nullable AtomicDouble progress) {
        HttpPost httppost = new HttpPost(url);
        httppost.setEntity((HttpEntity)new TrackableByteArrayEntity(bytes, progress));
        return WebUtils.executeWebRequest((HttpUriRequest)httppost, type, null, true);
    }

    public static String post(String url, File file, MediaType type) {
        HttpPost httppost = new HttpPost(url);
        httppost.setEntity((HttpEntity)new FileEntity(file));
        return WebUtils.executeWebRequest((HttpUriRequest)httppost, type, null, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String executeWebRequest(HttpUriRequest message, @Nullable MediaType type, @Nullable AtomicDouble progress, boolean authHeaders) {
        try (CloseableHttpClient client = WebUtils.buildClient();){
            CloseableHttpResponse response;
            StatusLine status;
            if (authHeaders) {
                WebUtils.authHeaders(message);
            }
            if (type != null) {
                type.apply(message);
            }
            if ((status = (response = client.execute(message)).getStatusLine()).getStatusCode() != 200) {
                LOGGER.error("Web Request failed. Returned response code: {}, Reason: {}", (Object)status.getStatusCode(), (Object)status.getReasonPhrase());
                String string2 = "error";
                return string2;
            }
            String string = WebUtils.handleResponse(response, progress);
            return string;
        }
        catch (IOException e) {
            LOGGER.error("Something went wrong while executing web request", (Throwable)e);
            return "error";
        }
    }

    private static String handleResponse(CloseableHttpResponse response, @Nullable AtomicDouble progress) throws IOException {
        HttpEntity entity = response.getEntity();
        long len = entity.getContentLength();
        try (CloseableHttpResponse closeableHttpResponse = response;){
            String string;
            block17: {
                String res;
                InputStream is;
                block15: {
                    String string2;
                    block16: {
                        is = entity.getContent();
                        try {
                            int n;
                            ByteArrayOutputStream resultBuffer = new ByteArrayOutputStream();
                            byte[] buffer = new byte[512];
                            long count = 0L;
                            while (-1 != (n = is.read(buffer))) {
                                resultBuffer.write(buffer, 0, n);
                                count += (long)n;
                                if (progress == null) continue;
                                progress.set(len > 0L ? (double)count / (double)len : Math.max(1.1, (double)count));
                            }
                            res = resultBuffer.toString();
                            if (!res.isEmpty()) break block15;
                            LOGGER.error("Error executing web request, Empty response");
                            string2 = "error";
                            if (is == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        is.close();
                    }
                    return string2;
                }
                string = res;
                if (is == null) break block17;
                is.close();
            }
            return string;
        }
    }

    public static CloseableHttpClient buildClient() {
        HttpClientBuilder clientBuilder = HttpClients.custom().setUserAgent("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.138 Safari/537.36 Vivaldi/1.8.770.56 BlockShot/1.0.0");
        return clientBuilder.build();
    }

    private static void authHeaders(HttpUriRequest message) throws IOException {
        message.setHeader("Authorization", "Bearer " + MineTogetherSession.getDefault().getToken());
        message.setHeader("Minecraft-Name", Minecraft.getInstance().getUser().getName());
        if (!Config.INSTANCE.anonymous) {
            message.setHeader("Minecraft-Uuid", Minecraft.getInstance().getUser().getProfileId().toString());
        }
    }

    public static enum MediaType {
        PNG("Screencap-Type", "image/png", "Content-Type", "application/x-www-form-urlencoded"),
        GIF("Screencap-Type", "image/gif", "Content-Type", "application/x-www-form-urlencoded"),
        WEBM("Screencap-Type", "video/webm", "Content-Type", "application/x-www-form-urlencoded"),
        JSON("Content-Type", "application/json");

        private final String[] headers;

        private MediaType(String ... headers) {
            this.headers = headers;
        }

        public void apply(HttpUriRequest message) {
            for (int i = 0; i < this.headers.length; i += 2) {
                message.setHeader(this.headers[i], this.headers[i + 1]);
            }
        }
    }
}

