/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.capture;

import com.google.common.util.concurrent.AtomicDouble;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import net.creeperhost.blockshot.BlockShot;
import net.creeperhost.blockshot.ClientUtil;
import net.creeperhost.blockshot.WebUtils;
import net.creeperhost.blockshot.capture.Encoder;
import net.creeperhost.blockshot.capture.ScreenshotHandler;
import net.creeperhost.polylib.client.gif.GifSequenceWriter;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GifEncoder
implements Encoder {
    private static Logger LOGGER = LogManager.getLogger();
    private ExecutorService rendering = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("blockshot-framerenderer-%d").build());
    private ExecutorService encoding = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("blockshot-imageencoder-%d").build());
    private AtomicInteger addedFrames = new AtomicInteger();
    private AtomicInteger processedFrames = new AtomicInteger();
    private boolean isRecording = false;
    private boolean stopping = false;
    private boolean isCanceled = false;
    private long lastTimestamp;
    private long frames;
    private long totalSeconds;
    private AtomicReference<List<BufferedImage>> _frames = new AtomicReference();
    private AtomicDouble uploadProgress = new AtomicDouble(0.0);
    private long currentFrame = 0L;
    private String totalFrames = "";

    @Override
    public void updateCapture() {
        if (this.stopping) {
            return;
        }
        int skipFrames = 6;
        if (BlockShot.getFPS() > 20) {
            skipFrames = BlockShot.getFPS() / 10;
        }
        if (this.frames > (long)skipFrames || this.lastTimestamp != System.currentTimeMillis() / 1000L) {
            this.frames = 0L;
            if (this.lastTimestamp != System.currentTimeMillis() / 1000L) {
                this.lastTimestamp = System.currentTimeMillis() / 1000L;
                ++this.totalSeconds;
            }
            RenderTarget renderTarget = Minecraft.getInstance().getMainRenderTarget();
            NativeImage nativeImage = new NativeImage(renderTarget.width, renderTarget.height, false);
            RenderSystem.bindTexture((int)renderTarget.getColorTextureId());
            nativeImage.downloadTexture(0, true);
            this.addFrame(nativeImage);
            if (this.totalSeconds > 30L) {
                this.stopping = true;
            }
        } else {
            ++this.frames;
        }
    }

    private void addFrame(NativeImage screenImage) {
        CompletableFuture.runAsync(() -> {
            this.addedFrames.incrementAndGet();
            BufferedImage image = this.toBufferedImage(screenImage, 572, 322);
            if (image != null) {
                this._frames.getAndUpdate(a -> {
                    a.add(image);
                    return a;
                });
            }
            this.processedFrames.incrementAndGet();
        }, this.rendering);
    }

    private void begin() {
        if (this._frames == null || this._frames.get() == null) {
            this._frames.set(new ArrayList());
        }
        if (this.isRecording) {
            return;
        }
        this.lastTimestamp = 0L;
        this.frames = 0L;
        this.totalSeconds = 0L;
        this.isRecording = true;
        CompletableFuture.runAsync(() -> {
            this.waitForFinish();
            if (this.isCanceled) {
                this.isCanceled = false;
                ClientUtil.sendMessage((Component)Component.translatable((String)"chat.blockshot.record.canceled"), BlockShot.CHAT_ENCODING_ID);
            } else {
                ClientUtil.sendMessage((Component)Component.translatable((String)"chat.blockshot.record.complete"), BlockShot.CHAT_ENCODING_ID);
                this.generateGif();
            }
            this.addedFrames.set(0);
            this.processedFrames.set(0);
            this.stopping = false;
            this.isRecording = false;
        }, this.encoding);
    }

    private void waitForFinish() {
        while (this.isRecording && !this.stopping || this.addedFrames.get() > this.processedFrames.get()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void generateGif() {
        if (this._frames.get() == null) {
            return;
        }
        List<BufferedImage> frames = this._frames.get();
        BufferedImage firstFrame = frames.get(0);
        GifSequenceWriter writer = null;
        ByteArrayOutputStream outputStream = null;
        ImageOutputStream imageStream = null;
        int duration = (int)(this.totalSeconds / (long)frames.size());
        MutableComponent message = Component.translatable((String)"chat.blockshot.record.preparing.complete");
        ClientUtil.sendMessage((Component)message, BlockShot.CHAT_ENCODING_ID);
        try {
            outputStream = new ByteArrayOutputStream();
            imageStream = ImageIO.createImageOutputStream(outputStream);
            writer = new GifSequenceWriter(imageStream, firstFrame.getType(), duration, true);
            writer.writeToSequence((RenderedImage)firstFrame);
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while writing frames", (Throwable)e);
            IOUtils.closeQuietly((Closeable[])new Closeable[]{outputStream, imageStream});
            return;
        }
        int i = 0;
        int f = frames.size();
        for (BufferedImage frame : frames) {
            try {
                ++i;
                Object dots = "";
                for (int z = 0; z <= i % 3; ++z) {
                    dots = (String)dots + ".";
                }
                this.currentFrame = i;
                this.totalFrames = f + (String)dots;
                writer.writeToSequence((RenderedImage)frame);
            }
            catch (IOException e) {
                LOGGER.error("An error occurred while writing frames", (Throwable)e);
                IOUtils.closeQuietly((Closeable[])new Closeable[]{outputStream, imageStream});
                return;
            }
        }
        try {
            writer.close();
            imageStream.close();
            frames.clear();
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while writing frames", (Throwable)e);
            IOUtils.closeQuietly((Closeable[])new Closeable[]{outputStream, imageStream});
            return;
        }
        this.totalFrames = null;
        this._frames.set(new ArrayList());
        message = Component.translatable((String)"chat.blockshot.record.start.upload");
        ClientUtil.deleteMessage(BlockShot.CHAT_ENCODING_ID);
        ClientUtil.sendMessage((Component)message, BlockShot.CHAT_UPLOAD_ID);
        try {
            byte[] bytes = outputStream.toByteArray();
            outputStream.close();
            ScreenshotHandler.uploadAndAddToChat(bytes, true, "gif", this.uploadProgress, WebUtils.MediaType.GIF);
            outputStream.close();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while writing frames", (Throwable)e);
        }
    }

    @Override
    public void startOrStopRecording() {
        if (this.isRecording) {
            this.stopping = true;
        } else if (this.canRecord() && !this.isWorking()) {
            this.begin();
        }
    }

    @Override
    public void cancelRecording() {
        if (this.isRecording) {
            this.isCanceled = true;
            this.stopping = true;
        }
    }

    @Override
    public boolean isWorking() {
        return this.isRecording;
    }

    private boolean canRecord() {
        return this.processedFrames.get() == 0 && this.addedFrames.get() == 0;
    }

    @Override
    public boolean showRecordIcon() {
        return this.isRecording && !this.stopping;
    }

    @Override
    public List<Component> getHudText() {
        ArrayList<Component> list = new ArrayList<Component>();
        if (!this.stopping) {
            String screenshotKey = Minecraft.getInstance().options.keyScreenshot.getTranslatedKeyMessage().getString();
            list.add((Component)Component.translatable((String)"overlay.blockshot.recording").withStyle(ChatFormatting.RED));
            list.add((Component)Component.translatable((String)"overlay.blockshot.finish", (Object[])new Object[]{screenshotKey}).withStyle(ChatFormatting.GRAY));
            list.add((Component)Component.translatable((String)"overlay.blockshot.cancel", (Object[])new Object[]{screenshotKey}).withStyle(ChatFormatting.GRAY));
        }
        if (this.stopping && this.totalFrames != null) {
            list.add((Component)Component.translatable((String)"overlay.blockshot.encoding_frame_of", (Object[])new Object[]{this.currentFrame, this.totalFrames}).withStyle(ChatFormatting.RED));
        } else if (this.stopping) {
            list.add((Component)Component.translatable((String)"overlay.blockshot.uploading").append(": " + Math.round(this.uploadProgress.get() * 100.0) + "%").withStyle(ChatFormatting.RED));
        }
        return list;
    }
}

