/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.capture;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.creeperhost.blockshot.Auth;
import net.creeperhost.blockshot.BlockShot;
import net.creeperhost.blockshot.Config;
import net.creeperhost.blockshot.capture.Encoder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.joml.Matrix4f;

public class RecordingHandler {
    private static Encoder encoder;

    public static Encoder getEncoder() {
        if (Config.INSTANCE.getEncoderType().requiresPremium() && !Auth.hasPremium()) {
            Config.INSTANCE.setEncoderType(Config.EncoderType.GIF);
        }
        if (encoder == null) {
            RecordingHandler.setEncoder(Config.INSTANCE.getEncoderType().createEncoder());
        }
        return encoder;
    }

    public static boolean setEncoder(Encoder newEncoder) {
        if (encoder != null && encoder.isWorking()) {
            return false;
        }
        encoder = newEncoder;
        return true;
    }

    public static void handleScreenCapture() {
        if (!BlockShot.isActive() || !RecordingHandler.getEncoder().isWorking()) {
            return;
        }
        RecordingHandler.getEncoder().updateCapture();
        RecordingHandler.drawRecordingIndicator(5, 5);
    }

    private static void drawRecordingIndicator(int x, int y) {
        List<Component> hudLines = RecordingHandler.getEncoder().getHudText();
        if (hudLines == null || hudLines.isEmpty()) {
            return;
        }
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.pushPose();
        poseStack.setIdentity();
        poseStack.translate(0.0f, 0.0f, -2000.0f);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableBlend();
        Font font = Minecraft.getInstance().font;
        int recordOffset = RecordingHandler.getEncoder().showRecordIcon() ? 10 : 0;
        int maxWidth = 0;
        for (Component line : hudLines) {
            maxWidth = Math.max(maxWidth, font.width((FormattedText)line));
        }
        int height = hudLines.size() * 9 + 5;
        RecordingHandler.drawRect(poseStack, x, y, maxWidth + 6 + recordOffset, height, -1341124592);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
        int i = 0;
        for (Component line : hudLines) {
            font.drawInBatch(line, (float)(x + 3 + recordOffset), (float)(y + 3 + i), 0xFFFFFF, true, poseStack.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            i += 9;
        }
        bufferSource.endBatch();
        if (System.currentTimeMillis() % 2000L > 1000L && RecordingHandler.getEncoder().showRecordIcon()) {
            RecordingHandler.drawRect(poseStack, x + 3, y + 4, 7, 5, -65536);
            RecordingHandler.drawRect(poseStack, x + 4, y + 3, 5, 7, -65536);
        }
        poseStack.popPose();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableBlend();
    }

    private static void drawRect(PoseStack poseStack, int x, int y, int width, int height, int colour) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix4f = poseStack.last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        bufferBuilder.vertex(matrix4f, (float)x, (float)(y + height), 0.0f).color(colour).endVertex();
        bufferBuilder.vertex(matrix4f, (float)(x + width), (float)(y + height), 0.0f).color(colour).endVertex();
        bufferBuilder.vertex(matrix4f, (float)(x + width), (float)y, 0.0f).color(colour).endVertex();
        bufferBuilder.vertex(matrix4f, (float)x, (float)y, 0.0f).color(colour).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
    }
}

