/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import net.creeperhost.blockshot.Auth;
import net.creeperhost.blockshot.BlockShot;
import net.creeperhost.blockshot.Config;
import net.creeperhost.blockshot.gui.GuiLoadingSpinner;
import net.creeperhost.blockshot.lib.Capture;
import net.creeperhost.blockshot.lib.HistoryManager;
import net.creeperhost.blockshot.lib.TextureCache;
import net.creeperhost.polylib.client.PolyPalette;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiScrolling;
import net.creeperhost.polylib.client.modulargui.elements.GuiSlider;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Axis;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class BlockShotGui
implements GuiProvider {
    private static final SimpleDateFormat DAY_OF_MONTH_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy");
    private static final SimpleDateFormat HH_MM_FORMAT = new SimpleDateFormat("HH:mm");
    private ModularGui gui;
    private int entryWidth = 42;
    private int entryHeight = 42;
    private int historyState = -1;
    private GuiScrolling scrollElement;
    private Capture selected = null;

    public GuiElement<?> createRootElement(ModularGui gui) {
        return PolyPalette.Flat.background((GuiParent)gui);
    }

    public void buildGui(ModularGui gui) {
        this.gui = gui;
        gui.renderScreenBackground(false);
        gui.initFullscreenGui();
        gui.setGuiTitle((Component)Component.translatable((String)"gui.blockshot.title"));
        GuiElement root = gui.getRoot();
        GuiText title = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, gui.getGuiTitle()).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)5.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.RIGHT)));
        if (!BlockShot.isActive()) {
            title.setText((Component)Component.translatable((String)"gui.blockshot.history.not_in_offline").withStyle(ChatFormatting.RED));
            return;
        }
        ((HeaderInfo)((HeaderInfo)((HeaderInfo)new HeaderInfo((GuiParent<?>)root).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.TOP)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)20.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.RIGHT)));
        GuiElement<?> historyPanel = this.createHistoryPanel(root, this.entryWidth);
        GuiButton copyUrl = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)PolyPalette.Flat.button((GuiElement)root, (Component)Component.translatable((String)"gui.blockshot.history.copy_url")).setEnabled(() -> this.selected != null)).onPress(() -> this.activateSelected(true)).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)historyPanel.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)-4.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)80.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiButton view = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)PolyPalette.Flat.button((GuiElement)root, (Component)Component.translatable((String)"gui.blockshot.history.view")).setEnabled(() -> this.selected != null)).onPress(() -> this.activateSelected(false)).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)copyUrl.get(GeoParam.RIGHT), (double)2.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)-4.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)80.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiButton delete = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)PolyPalette.Flat.buttonCaution((GuiElement)root, (Component)Component.translatable((String)"gui.blockshot.history.delete")).setEnabled(() -> this.selected != null)).onPress(this::deleteSelected).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)historyPanel.get(GeoParam.RIGHT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)-4.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)60.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiElement previous = (GuiElement)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, (Component)Component.translatable((String)"gui.blockshot.settings.upload.owner").withStyle(ChatFormatting.UNDERLINE)).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-4.0))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)historyPanel.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)historyPanel.get(GeoParam.RIGHT), (double)12.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        previous = (GuiElement)((GuiButton)((GuiButton)((GuiButton)((GuiButton)PolyPalette.Flat.button((GuiElement)root, (Component)Component.empty()).setTooltipSingle((Component)Component.translatable((String)"gui.blockshot.settings.upload.info"))).onPress(() -> {
            Config.INSTANCE.anonymous = !Config.INSTANCE.anonymous;
            Config.saveConfigToFile(BlockShot.configLocation.toFile());
        }).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-4.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)previous.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)historyPanel.get(GeoParam.RIGHT), (double)12.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        ((GuiButton)previous).getLabel().setTextSupplier(() -> Config.INSTANCE.anonymous ? Component.translatable((String)"gui.blockshot.settings.upload.anonymous") : gui.mc().player.getName());
        previous = (GuiElement)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, (Component)Component.translatable((String)"gui.blockshot.settings.upload_mode").withStyle(ChatFormatting.UNDERLINE)).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-4.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)previous.get(GeoParam.BOTTOM), (double)8.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)historyPanel.get(GeoParam.RIGHT), (double)12.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        previous = (GuiElement)((GuiButton)((GuiButton)((GuiButton)PolyPalette.Flat.button((GuiElement)root, (Component)Component.empty()).onPress(() -> {
            Config.INSTANCE.uploadMode = Config.INSTANCE.uploadMode.next();
            Config.saveConfigToFile(BlockShot.configLocation.toFile());
        }).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-4.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)previous.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)historyPanel.get(GeoParam.RIGHT), (double)12.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        ((GuiButton)previous).getLabel().setTextSupplier(() -> Component.translatable((String)Config.INSTANCE.uploadMode.translatableName()));
        previous = (GuiElement)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, (Component)Component.translatable((String)"gui.blockshot.settings.button_pos").withStyle(ChatFormatting.UNDERLINE)).setTooltipSingle((Component)Component.translatable((String)"gui.blockshot.settings.button_pos.info"))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-4.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)previous.get(GeoParam.BOTTOM), (double)8.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)historyPanel.get(GeoParam.RIGHT), (double)12.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        previous = (GuiElement)((GuiButton)((GuiButton)((GuiButton)((GuiButton)PolyPalette.Flat.button((GuiElement)root, (Component)Component.empty()).onPress(() -> {
            Config.INSTANCE.buttonPos = Config.INSTANCE.buttonPos.next();
            Config.saveConfigToFile(BlockShot.configLocation.toFile());
        }).setTooltipSingle((Component)Component.translatable((String)"gui.blockshot.settings.button_pos.info"))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-4.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)previous.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)historyPanel.get(GeoParam.RIGHT), (double)12.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        ((GuiButton)previous).getLabel().setTextSupplier(() -> Component.translatable((String)Config.INSTANCE.buttonPos.translatableName()));
        previous = (GuiElement)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, (Component)Component.translatable((String)"gui.blockshot.settings.encoder").withStyle(ChatFormatting.UNDERLINE)).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-4.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)previous.get(GeoParam.BOTTOM), (double)8.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)historyPanel.get(GeoParam.RIGHT), (double)12.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        previous = (GuiElement)((GuiButton)((GuiButton)((GuiButton)PolyPalette.Flat.button((GuiElement)root, (Component)Component.translatable((String)"gui.blockshot.settings.encoder.gif")).setToggleMode(() -> Config.INSTANCE.getEncoderType() == Config.EncoderType.GIF || !Auth.hasPremium()).onPress(() -> {
            Config.INSTANCE.setEncoderType(Config.EncoderType.GIF);
            Config.saveConfigToFile(BlockShot.configLocation.toFile());
        }).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-4.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)previous.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)historyPanel.get(GeoParam.RIGHT), (double)12.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        previous = (GuiElement)((GuiButton)((GuiButton)((GuiButton)((GuiButton)PolyPalette.Flat.button((GuiElement)root, (Component)Component.translatable((String)"gui.blockshot.settings.encoder.mov")).setToggleMode(() -> Config.INSTANCE.getEncoderType() == Config.EncoderType.MOV && Auth.hasPremium()).setDisabled(() -> !Auth.hasPremium()).onPress(() -> {
            Config.INSTANCE.setEncoderType(Config.EncoderType.MOV);
            Config.saveConfigToFile(BlockShot.configLocation.toFile());
        }).setTooltipSingle((Component)Component.translatable((String)"gui.blockshot.settings.encoder.mov.info"))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-4.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)previous.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)historyPanel.get(GeoParam.RIGHT), (double)12.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        ((GuiButton)((GuiButton)((GuiButton)PolyPalette.Flat.button((GuiElement)root, (Component)Component.translatable((String)"gui.blockshot.close")).onPress(() -> gui.mc().setScreen(null)).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)historyPanel.get(GeoParam.RIGHT), (double)12.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)historyPanel.get(GeoParam.BOTTOM)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        ((GuiLoadingSpinner)((GuiLoadingSpinner)((GuiLoadingSpinner)new GuiLoadingSpinner((GuiParent<?>)root, new ResourceLocation("blockshot", "textures/gui/loading_spinner.png")).setDoSpin(() -> HistoryManager.instance.isDownloading()).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)historyPanel.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)historyPanel.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)historyPanel.get(GeoParam.BOTTOM)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)historyPanel.get(GeoParam.RIGHT)));
        gui.onTick(() -> this.detectHistoryChanges(false));
        gui.onResize(() -> this.detectHistoryChanges(true));
        gui.onMouseClickPost((aDouble, aDouble2, integer) -> {
            this.selected = null;
        });
        gui.onKeyPressPost((key, code, modifier) -> {
            if (key == 261) {
                this.deleteSelected();
            }
        });
    }

    private void activateSelected(boolean copyUrl) {
        if (this.selected == null) {
            return;
        }
        if (copyUrl) {
            Minecraft.getInstance().keyboardHandler.setClipboard("https://blockshot.ch/" + this.selected.id());
        } else {
            Util.getPlatform().openUri("https://blockshot.ch/" + this.selected.id());
        }
    }

    private void deleteSelected() {
        if (this.selected == null) {
            return;
        }
        HistoryManager.instance.deleteCapture(this.selected);
        this.selected = null;
    }

    private GuiElement<?> createHistoryPanel(GuiElement<?> root, int entryWidth) {
        GuiElement container = (GuiElement)((GuiElement)((GuiElement)((GuiElement)PolyPalette.Flat.contentArea(root).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> (double)this.historyColumns() * (double)entryWidth))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)10.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)30.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)-22.0));
        MutableComponent title = Component.translatable((String)"gui.blockshot.history.title").withStyle(ChatFormatting.UNDERLINE);
        MutableComponent anonWarning = Component.translatable((String)"gui.blockshot.history.anon_warning").withStyle(ChatFormatting.RED);
        ((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)container, () -> BlockShotGui.lambda$createHistoryPanel$23((Component)title, (Component)anonWarning)).setTextColour(0xFFFFFF).setShadow(false).setAlignment(Align.LEFT).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)container.get(GeoParam.TOP), (double)-3.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)container.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.RIGHT)));
        this.scrollElement = new GuiScrolling((GuiParent)container);
        Constraints.bind((ConstrainedGeometry)this.scrollElement, (ConstrainedGeometry)container);
        this.scrollElement.getContentElement().setZStacking(false);
        Assembly scrollBar = PolyPalette.Flat.scrollBar((GuiElement)container, (Axis)Axis.Y);
        ((GuiElement)((GuiElement)((GuiElement)scrollBar.container.setEnabled(() -> this.scrollElement.hiddenSize(Axis.Y) > 0.0).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)container.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)container.get(GeoParam.RIGHT), (double)1.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)container.get(GeoParam.BOTTOM)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)8.0));
        ((GuiSlider)scrollBar.primary).setSliderState(this.scrollElement.scrollState(Axis.Y)).setScrollableElement((GuiElement)this.scrollElement);
        GuiText noHistory = ((GuiText)new GuiText((GuiParent)container, (Component)Component.translatable((String)"gui.blockshot.history.no_history")).setEnabled(HistoryManager.instance::hasNoHistory)).setTextColour(0xFFFFFF).setShadow(false);
        Constraints.bind((ConstrainedGeometry)noHistory, (ConstrainedGeometry)container);
        return container;
    }

    private int historyColumns() {
        return (int)Math.floor(this.gui.xSize() * 0.667 / (double)this.entryWidth);
    }

    private void detectHistoryChanges(boolean force) {
        HistoryManager manager = HistoryManager.instance;
        manager.updateHistory();
        if (this.historyState == manager.getState() && !force) {
            return;
        }
        this.historyState = manager.getState();
        GuiElement content = this.scrollElement.getContentElement();
        content.getChildren().forEach(arg_0 -> ((GuiElement)content).removeChild(arg_0));
        int yOffset = 0;
        int column = 0;
        int columns = this.historyColumns();
        long currentDay = Long.MAX_VALUE;
        for (Capture capture : manager.getCaptureHistory()) {
            long day = TimeUnit.MILLISECONDS.toDays(capture.created() * 1000L + (long)TimeZone.getDefault().getRawOffset());
            if (day != currentDay) {
                currentDay = day;
                MutableComponent dateText = day == TimeUnit.MILLISECONDS.toDays(System.currentTimeMillis() + (long)TimeZone.getDefault().getRawOffset()) ? Component.translatable((String)"gui.blockshot.history.today") : Component.literal((String)DAY_OF_MONTH_FORMAT.format(capture.created() * 1000L));
                if (column != 0) {
                    yOffset += this.entryHeight;
                }
                ((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)content, (Component)dateText.withStyle(ChatFormatting.UNDERLINE)).setTextColour(0xFFFFFF).setShadow(false).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)content.get(GeoParam.TOP), (double)(yOffset + 2)))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.scrollElement.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.scrollElement.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
                yOffset += 12;
                column = 0;
            }
            ((CaptureElement)((CaptureElement)((CaptureElement)new CaptureElement((GuiParent<?>)content, capture).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)content.get(GeoParam.TOP), (double)yOffset))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)content.get(GeoParam.LEFT), (double)(column * this.entryWidth)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)this.entryWidth))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)this.entryHeight));
            if (++column != columns) continue;
            column = 0;
            yOffset += this.entryHeight;
        }
    }

    private static /* synthetic */ Component lambda$createHistoryPanel$23(Component title, Component anonWarning) {
        return Component.empty().append(title).append((Component)(Config.INSTANCE.anonymous ? Component.literal((String)" ").append(anonWarning) : Component.empty()));
    }

    private static class HeaderInfo
    extends GuiElement<HeaderInfo>
    implements BackgroundRender {
        public HeaderInfo(@NotNull GuiParent<?> parent) {
            super(parent);
        }

        public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
            if (HistoryManager.instance.isDownloadError()) {
                render.drawCenteredString((Component)Component.translatable((String)"gui.blockshot.history.download_error"), this.xSize() / 2.0, 15.0, 0xFF0000);
            } else {
                render.pose().pushPose();
                render.pose().translate(10.0f, 2.0f, 0.0f);
                render.pose().scale(0.75f, 0.75f, 0.75f);
                render.drawString((Component)Component.translatable((String)"gui.blockshot.history.how_to_screenshot", (Object[])new Object[]{this.mc().options.keyScreenshot.getTranslatedKeyMessage()}), 0.0, 0.0, 0x707070);
                render.drawString((Component)Component.translatable((String)"gui.blockshot.history.how_to_record", (Object[])new Object[]{this.mc().options.keyScreenshot.getTranslatedKeyMessage()}), 0.0, 10.0, 0x707070);
                render.pose().popPose();
            }
        }
    }

    private class CaptureElement
    extends GuiElement<CaptureElement>
    implements BackgroundRender {
        private final Capture capture;
        private long lastClick;

        public CaptureElement(GuiParent<?> parent, Capture capture) {
            super(parent);
            this.lastClick = 0L;
            this.capture = capture;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.isMouseOver()) {
                BlockShotGui.this.selected = this.capture;
                if (System.currentTimeMillis() - this.lastClick < 500L) {
                    BlockShotGui.this.activateSelected(false);
                    this.mc().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    this.lastClick = 0L;
                } else {
                    this.lastClick = System.currentTimeMillis();
                }
                return true;
            }
            return false;
        }

        public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
            if (this.isMouseOver() || this.capture.equals(BlockShotGui.this.selected)) {
                render.borderRect(this.getRectangle(), 1.0, 0x50808080, -2130706433);
            }
            double size = Math.min(this.xSize(), this.ySize()) / 2.0 - 1.0;
            this.drawTexture(render, this.xCenter() - size, this.yCenter() - size, this.xCenter() + size, this.yCenter() + size);
            render.pose().pushPose();
            render.pose().translate(this.xMin() + 2.0, this.yMax() - 8.0, 0.0);
            render.pose().scale(0.75f, 0.75f, 1.0f);
            render.drawString(HH_MM_FORMAT.format(this.capture.created() * 1000L), 0.0, 0.0, 0x8080FF, false);
            String format = this.capture.format();
            if (format.contains("/")) {
                format = format.substring(format.indexOf("/") + 1);
            }
            render.drawString(format, (double)BlockShotGui.this.entryWidth / 0.75 - 28.0, 0.0, 0xAAAAAA, false);
            render.pose().popPose();
        }

        private void drawTexture(GuiRender render, double xMin, double yMin, double xMax, double yMax) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureCache.loadPreview(this.capture));
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            Matrix4f matrix4f = render.pose().last().pose();
            BufferBuilder bufferbuilder = Tesselator.getInstance().getBuilder();
            bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.vertex(matrix4f, (float)xMin, (float)yMin, 0.0f).uv(0.0f, 0.0f).endVertex();
            bufferbuilder.vertex(matrix4f, (float)xMin, (float)yMax, 0.0f).uv(0.0f, 1.0f).endVertex();
            bufferbuilder.vertex(matrix4f, (float)xMax, (float)yMax, 0.0f).uv(1.0f, 1.0f).endVertex();
            bufferbuilder.vertex(matrix4f, (float)xMax, (float)yMin, 0.0f).uv(1.0f, 0.0f).endVertex();
            BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferbuilder.end());
        }
    }
}

