/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class IconButton
extends Button {
    private static final WidgetSprites SPRITES = new WidgetSprites(new ResourceLocation("widget/button"), new ResourceLocation("widget/button_disabled"), new ResourceLocation("widget/button_highlighted"));
    private final boolean showText;
    private ResourceLocation icon;
    private int iconWidth;
    private int iconHeight;

    public IconButton(int x, int y, int width, int height, @Nullable Component component, Button.OnPress onPress) {
        super(x, y, width, height, (Component)(component == null ? Component.empty() : component), onPress, Button.DEFAULT_NARRATION);
        this.showText = component != null;
    }

    public IconButton setIcon(ResourceLocation icon, int iconWidth, int iconHeight) {
        this.icon = icon;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        return this;
    }

    private int getTextureY() {
        int i = 1;
        if (!this.active) {
            i = 0;
        } else if (this.isHoveredOrFocused()) {
            i = 2;
        }
        return 46 + i * 20;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        guiGraphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int drawX = this.getX() + this.width / 2;
        if (this.icon != null) {
            drawX -= this.iconWidth / 2;
        }
        FormattedCharSequence formattedCharSequence = null;
        if (this.showText) {
            formattedCharSequence = this.getMessage().getVisualOrderText();
            drawX -= minecraft.font.width(formattedCharSequence) / 2 + (this.icon == null ? 0 : 2);
        }
        if (this.icon != null) {
            this.draw(this.icon, guiGraphics.pose(), drawX, this.getY() + this.height / 2 - this.iconHeight / 2, 16, 16);
        }
        if (this.showText) {
            if (this.icon != null) {
                drawX += this.iconWidth + 2;
            }
            guiGraphics.drawString(minecraft.font, formattedCharSequence, drawX, (int)((float)this.getY() + (float)(this.height - 8) / 2.0f), 0xFFFFFF, true);
        }
    }

    private void draw(ResourceLocation resourceLocation, PoseStack poseStack, int x, int y, int width, int height) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = poseStack.last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.vertex(matrix4f, (float)x, (float)y + (float)height, 0.0f).uv(0.0f, 1.0f).endVertex();
        bufferBuilder.vertex(matrix4f, (float)x + (float)width, (float)y + (float)height, 0.0f).uv(1.0f, 1.0f).endVertex();
        bufferBuilder.vertex(matrix4f, (float)x + (float)width, (float)y, 0.0f).uv(1.0f, 0.0f).endVertex();
        bufferBuilder.vertex(matrix4f, (float)x, (float)y, 0.0f).uv(0.0f, 0.0f).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
    }
}

