/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.lib;

import com.mojang.blaze3d.platform.NativeImage;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import net.creeperhost.blockshot.lib.Capture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureCache {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation FALLBACK_RESOURCE = new ResourceLocation("textures/misc/unknown_server.png");
    private static final Map<String, ResourceLocation> PREVIEW_CACHE = new HashMap<String, ResourceLocation>();

    public static ResourceLocation loadPreview(Capture capture) {
        return PREVIEW_CACHE.computeIfAbsent(capture.id(), s -> TextureCache.load(capture.preview(), capture.created()));
    }

    public static void unloadPreview(Capture capture) {
        ResourceLocation resource = PREVIEW_CACHE.remove(capture.id());
        if (resource != null) {
            Minecraft.getInstance().getTextureManager().release(resource);
        }
    }

    private static ResourceLocation load(String base64Texture, long created) {
        try {
            if (StringUtils.isNotBlank((CharSequence)base64Texture) && created > 0L) {
                byte[] bs = Base64.getDecoder().decode(base64Texture.replaceAll("\n", "").getBytes(StandardCharsets.UTF_8));
                return Minecraft.getInstance().getTextureManager().register("blockshot/", new DynamicTexture(NativeImage.read((byte[])bs)));
            }
        }
        catch (Throwable t) {
            LOGGER.warn("An error occurred while loading capture preview", t);
        }
        return FALLBACK_RESOURCE;
    }
}

