/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.net.creeperhost.minetogether.session;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.creeperhost.blockshot.repack.net.creeperhost.minetogether.session.InvalidJWebToken;
import org.jetbrains.annotations.Nullable;

public class JWebToken {
    private static final Gson GSON = new Gson();
    private static final String JWT_HEADER = "{\"alg\":\"ES256\",\"typ\":\"JWT\"}";
    private static final String JWT_HEADER_ENCODED = JWebToken.base64Encode("{\"alg\":\"ES256\",\"typ\":\"JWT\"}");
    private static final long EXPIRY = TimeUnit.HOURS.toMillis(18L);
    private final UUID uuid;
    private final String username;
    private final String uuidHash;
    private final long issued;
    private final long expiry;
    private final String payloadString;
    private final String signature;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public JWebToken(UUID uuid, String username, PrivateKey privateKey) {
        this(uuid, username, privateKey, EXPIRY);
    }

    public JWebToken(UUID uuid, String username, PrivateKey privateKey, long expiry) {
        this.uuid = uuid;
        this.username = username;
        this.uuidHash = JWebToken.hashBytes("SHA-256", uuid.toString().getBytes(StandardCharsets.UTF_8));
        this.issued = System.currentTimeMillis();
        this.expiry = this.issued + expiry;
        JsonObject json = new JsonObject();
        json.addProperty("sub", uuid.toString());
        json.addProperty("usn", username);
        json.addProperty("sha", this.uuidHash);
        json.addProperty("iat", (Number)this.issued);
        json.addProperty("exp", (Number)this.expiry);
        this.payloadString = json.toString();
        this.signature = JWebToken.signPayload(this.payloadString, privateKey);
    }

    private JWebToken(UUID uuid, String username, String uuidHash, long issued, long expiry, String payloadString, String signature) {
        this.uuid = uuid;
        this.username = username;
        this.uuidHash = uuidHash;
        this.issued = issued;
        this.expiry = expiry;
        this.payloadString = payloadString;
        this.signature = signature;
    }

    @Nullable
    public static JWebToken tryParse(String token) {
        try {
            return JWebToken.parse(token);
        }
        catch (InvalidJWebToken ex) {
            return null;
        }
    }

    public static JWebToken parse(String token) throws InvalidJWebToken {
        JsonObject payloadJson;
        String[] splits = token.split("\\.");
        if (splits.length != 3) {
            throw new InvalidJWebToken("Invalid JWT format.");
        }
        if (!splits[0].equals(JWT_HEADER_ENCODED)) {
            throw new InvalidJWebToken("Incorrect JWT header.");
        }
        String payload = splits[1];
        if (payload.isEmpty()) {
            throw new InvalidJWebToken("Payload is empty.");
        }
        String decodedPayload = JWebToken.base64Decode(payload);
        try {
            payloadJson = (JsonObject)GSON.fromJson(decodedPayload, JsonObject.class);
        }
        catch (JsonParseException ex) {
            throw new InvalidJWebToken("Payload is not valid json.", ex);
        }
        JsonElement sub = payloadJson.get("sub");
        if (sub == null || !sub.isJsonPrimitive()) {
            throw new InvalidJWebToken("Payload is missing subject field.");
        }
        String uuid = sub.getAsString();
        JsonElement usn = payloadJson.get("usn");
        if (usn == null || !sub.isJsonPrimitive()) {
            throw new InvalidJWebToken("Payload is missing username field.");
        }
        String username = usn.getAsString();
        JsonElement sha = payloadJson.get("sha");
        if (sha == null || !sub.isJsonPrimitive()) {
            throw new InvalidJWebToken("Payload is missing uuidHash field.");
        }
        String uuidHash = sha.getAsString();
        JsonElement iat = payloadJson.get("iat");
        if (iat == null || !iat.isJsonPrimitive()) {
            throw new InvalidJWebToken("Payload is missing issued at field.");
        }
        long issued = iat.getAsLong();
        JsonElement exp = payloadJson.get("exp");
        if (exp == null || !exp.isJsonPrimitive()) {
            throw new InvalidJWebToken("Payload is missing expiry field.");
        }
        long expiry = exp.getAsLong();
        return new JWebToken(UUID.fromString(uuid), username, uuidHash, issued, expiry, decodedPayload, splits[2]);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getUsername() {
        return this.username;
    }

    public String getUuidHash() {
        return this.uuidHash;
    }

    public long getIssued() {
        return this.issued;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public boolean isSignatureValid(PublicKey publicKey) {
        try {
            Signature ecdsaVerify = Signature.getInstance("SHA256withECDSA");
            ecdsaVerify.initVerify(publicKey);
            ecdsaVerify.update(this.payloadString.getBytes(StandardCharsets.UTF_8));
            return ecdsaVerify.verify(JWebToken.base64DecodeBytes(this.signature));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiry;
    }

    public boolean isValid(PublicKey publicKey) {
        return !this.isExpired() && this.isSignatureValid(publicKey);
    }

    public String toString() {
        return JWT_HEADER_ENCODED + "." + JWebToken.base64Encode(this.payloadString) + "." + this.signature;
    }

    public static boolean isValid(PublicKey publicKey, String token) {
        try {
            return JWebToken.parse(token).isValid(publicKey);
        }
        catch (InvalidJWebToken ex) {
            return false;
        }
    }

    private static String base64Encode(String str) {
        return JWebToken.base64Encode(str.getBytes(StandardCharsets.UTF_8));
    }

    private static String base64Encode(byte[] bytes) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    private static byte[] base64DecodeBytes(String str) {
        return Base64.getUrlDecoder().decode(str);
    }

    private static String base64Decode(String str) {
        return new String(JWebToken.base64DecodeBytes(str), StandardCharsets.UTF_8);
    }

    private static String signPayload(String data, PrivateKey privateKey) {
        try {
            Signature ecdsaSign = Signature.getInstance("SHA256withECDSA");
            ecdsaSign.initSign(privateKey);
            ecdsaSign.update(data.getBytes(StandardCharsets.UTF_8));
            return JWebToken.base64Encode(ecdsaSign.sign());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            throw new RuntimeException("Failed to sign data.", ex);
        }
    }

    private static String hashBytes(String alg, byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance(alg);
            return JWebToken.bytesToHex(digest.digest(bytes));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Failed to hash data.", ex);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }
}

