/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac;

import java.nio.ByteBuffer;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.AACDecoderConfig;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.AACException;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.ChannelConfiguration;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.Profile;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.filterbank.FilterBank;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.syntax.PCE;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.syntax.SyntacticElements;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.syntax.SyntaxConstants;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.transport.ADIFHeader;
import net.creeperhost.blockshot.repack.org.jcodec.common.AudioFormat;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.BitReader;
import net.creeperhost.blockshot.repack.org.jcodec.common.logging.Logger;

public class Decoder
implements SyntaxConstants {
    private final AACDecoderConfig config;
    private final SyntacticElements syntacticElements;
    private final FilterBank filterBank;
    private ADIFHeader adifHeader;

    public static boolean canDecode(Profile profile) {
        return profile.isDecodingSupported();
    }

    public Decoder(ByteBuffer decoderSpecificInfo) throws AACException {
        this.config = AACDecoderConfig.parseMP4DecoderSpecificInfo(decoderSpecificInfo);
        if (this.config == null) {
            throw new IllegalArgumentException("illegal MP4 decoder specific info");
        }
        if (!Decoder.canDecode(this.config.getProfile())) {
            throw new AACException("unsupported profile: " + this.config.getProfile().getDescription());
        }
        this.syntacticElements = new SyntacticElements(this.config);
        this.filterBank = new FilterBank(this.config.isSmallFrameUsed(), this.config.getChannelConfiguration().getChannelCount());
        Logger.debug("profile: {0}", this.config.getProfile());
        Logger.debug("sf: {0}", this.config.getSampleFrequency().getFrequency());
        Logger.debug("channels: {0}", this.config.getChannelConfiguration().getDescription());
    }

    public AACDecoderConfig getConfig() {
        return this.config;
    }

    public ByteBuffer decodeFrame(ByteBuffer frame, ByteBuffer buffer) throws AACException {
        try {
            return this.decode(frame, buffer);
        }
        catch (AACException e) {
            if (!e.isEndOfStream()) {
                throw e;
            }
            Logger.warn("unexpected end of frame");
            return null;
        }
    }

    private ByteBuffer decode(ByteBuffer frame, ByteBuffer buffer) throws AACException {
        BitReader _in;
        if (ADIFHeader.isPresent(frame)) {
            int id = frame.getInt();
            _in = BitReader.createBitReader(frame);
            this.adifHeader = ADIFHeader.readHeader(_in);
            PCE pce = this.adifHeader.getFirstPCE();
            this.config.setProfile(pce.getProfile());
            this.config.setSampleFrequency(pce.getSampleFrequency());
            this.config.setChannelConfiguration(ChannelConfiguration.forInt(pce.getChannelCount()));
        } else {
            _in = BitReader.createBitReader(frame);
        }
        if (!Decoder.canDecode(this.config.getProfile())) {
            throw new AACException("unsupported profile: " + this.config.getProfile().getDescription());
        }
        this.syntacticElements.startNewFrame();
        try {
            this.syntacticElements.decode(_in);
            this.syntacticElements.process(this.filterBank);
            return this.syntacticElements.sendToOutput(buffer);
        }
        catch (Exception e) {
            throw AACException.wrap(e);
        }
    }

    public AudioFormat getMeta() {
        return this.syntacticElements.getMeta();
    }
}

