/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.huffman;

import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.AACException;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.huffman.Codebooks;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.BitReader;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.VLC;

public class Huffman
implements Codebooks {
    private static final boolean[] UNSIGNED = new boolean[]{false, false, true, true, false, false, true, true, true, true, true};
    private static final int QUAD_LEN = 4;
    private static final int PAIR_LEN = 2;

    private Huffman() {
    }

    private static void signValues(BitReader _in, int[] data, int off, int len) throws AACException {
        for (int i = off; i < off + len; ++i) {
            if (data[i] == 0 || !_in.readBool()) continue;
            data[i] = -data[i];
        }
    }

    private static int getEscape(BitReader _in, int s) throws AACException {
        boolean neg = s < 0;
        int i = 4;
        while (_in.readBool()) {
            ++i;
        }
        int j = _in.readNBit(i) | 1 << i;
        return neg ? -j : j;
    }

    public static int decodeScaleFactor(BitReader _in) throws AACException {
        int offset = HCB_SF.readVLC(_in);
        return _HCB_SF[offset][2];
    }

    public static void decodeSpectralData(BitReader _in, int cb, int[] data, int off) throws AACException {
        VLC HCB2 = CODEBOOKS[cb - 1];
        int[][] _HCB = _CODEBOOKS[cb - 1];
        int offset = HCB2.readVLC(_in);
        data[off] = _HCB[offset][2];
        data[off + 1] = _HCB[offset][3];
        if (cb < 5) {
            data[off + 2] = _HCB[offset][4];
            data[off + 3] = _HCB[offset][5];
        }
        if (cb < 11) {
            if (UNSIGNED[cb - 1]) {
                Huffman.signValues(_in, data, off, cb < 5 ? 4 : 2);
            }
        } else if (cb == 11 || cb > 15) {
            Huffman.signValues(_in, data, off, cb < 5 ? 4 : 2);
            if (Math.abs(data[off]) == 16) {
                data[off] = Huffman.getEscape(_in, data[off]);
            }
            if (Math.abs(data[off + 1]) == 16) {
                data[off + 1] = Huffman.getEscape(_in, data[off + 1]);
            }
        } else {
            throw new AACException("Huffman: unknown spectral codebook: " + cb);
        }
    }
}

