/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.tools;

import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.AACException;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.SampleFrequency;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.syntax.ICSInfo;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.syntax.ICStream;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.tools.TNSTables;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.BitReader;

public class TNS {
    private static final int TNS_MAX_ORDER = 20;
    private static final int[] SHORT_BITS = new int[]{1, 4, 3};
    private static final int[] LONG_BITS = new int[]{2, 6, 5};
    private int[] nFilt = new int[8];
    private int[][] length = new int[8][4];
    private int[][] order;
    private boolean[][] direction = new boolean[8][4];
    private float[][][] coef;

    public TNS() {
        this.order = new int[8][4];
        this.coef = new float[8][4][20];
    }

    public void decode(BitReader _in, ICSInfo info) throws AACException {
        int windowCount = info.getWindowCount();
        int[] bits = info.isEightShortFrame() ? SHORT_BITS : LONG_BITS;
        for (int w = 0; w < windowCount; ++w) {
            this.nFilt[w] = _in.readNBit(bits[0]);
            if (this.nFilt[w] == 0) continue;
            int coefRes = _in.read1Bit();
            for (int filt = 0; filt < this.nFilt[w]; ++filt) {
                this.length[w][filt] = _in.readNBit(bits[1]);
                this.order[w][filt] = _in.readNBit(bits[2]);
                if (this.order[w][filt] > 20) {
                    throw new AACException("TNS filter out of range: " + this.order[w][filt]);
                }
                if (this.order[w][filt] == 0) continue;
                this.direction[w][filt] = _in.readBool();
                int coefCompress = _in.read1Bit();
                int coefLen = coefRes + 3 - coefCompress;
                int tmp = 2 * coefCompress + coefRes;
                for (int i = 0; i < this.order[w][filt]; ++i) {
                    this.coef[w][filt][i] = TNSTables.TNS_TABLES[tmp][_in.readNBit(coefLen)];
                }
            }
        }
    }

    public void process(ICStream ics, float[] spec, SampleFrequency sf, boolean decode) {
    }
}

