/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.transport;

import java.nio.ByteBuffer;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.AACException;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.syntax.PCE;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.BitReader;

public final class ADIFHeader {
    private static final long ADIF_ID = 1094994246L;
    private boolean copyrightIDPresent;
    private byte[] copyrightID = new byte[9];
    private boolean originalCopy;
    private boolean home;
    private boolean bitstreamType;
    private int bitrate;
    private int pceCount;
    private int[] adifBufferFullness;
    private PCE[] pces;

    public static boolean isPresent(ByteBuffer bb) throws AACException {
        return (long)bb.duplicate().getInt() == 1094994246L;
    }

    private ADIFHeader() {
    }

    public static ADIFHeader readHeader(BitReader _in) throws AACException {
        ADIFHeader h = new ADIFHeader();
        h.decode(_in);
        return h;
    }

    private void decode(BitReader _in) throws AACException {
        int i;
        this.copyrightIDPresent = _in.readBool();
        if (this.copyrightIDPresent) {
            for (i = 0; i < 9; ++i) {
                this.copyrightID[i] = (byte)_in.readNBit(8);
            }
        }
        this.originalCopy = _in.readBool();
        this.home = _in.readBool();
        this.bitstreamType = _in.readBool();
        this.bitrate = _in.readNBit(23);
        this.pceCount = _in.readNBit(4) + 1;
        this.pces = new PCE[this.pceCount];
        this.adifBufferFullness = new int[this.pceCount];
        for (i = 0; i < this.pceCount; ++i) {
            this.adifBufferFullness[i] = this.bitstreamType ? -1 : _in.readNBit(20);
            this.pces[i] = new PCE();
            this.pces[i].decode(_in);
        }
    }

    public PCE getFirstPCE() {
        return this.pces[0];
    }
}

