/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.api.specific;

import java.nio.ByteBuffer;
import net.creeperhost.blockshot.repack.org.jcodec.api.MediaInfo;
import net.creeperhost.blockshot.repack.org.jcodec.api.specific.ContainerAdaptor;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.H264Decoder;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.H264Utils;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.io.model.Frame;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.io.model.NALUnit;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.io.model.NALUnitType;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.io.model.SeqParameterSet;
import net.creeperhost.blockshot.repack.org.jcodec.common.DemuxerTrackMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.ColorSpace;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Packet;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Picture;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Rational;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Size;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.MP4Packet;

public class AVCMP4Adaptor
implements ContainerAdaptor {
    private H264Decoder decoder;
    private int curENo;
    private Size size;
    private DemuxerTrackMeta meta;

    public AVCMP4Adaptor(DemuxerTrackMeta meta) {
        this.meta = meta;
        this.curENo = -1;
        this.calcBufferSize();
    }

    private void calcBufferSize() {
        ByteBuffer b;
        int w = Integer.MIN_VALUE;
        int h = Integer.MIN_VALUE;
        ByteBuffer bb = this.meta.getCodecPrivate().duplicate();
        while ((b = H264Utils.nextNALUnit(bb)) != null) {
            int hh;
            NALUnit nu = NALUnit.read(b);
            if (nu.type != NALUnitType.SPS) continue;
            SeqParameterSet sps = H264Utils.readSPS(b);
            int ww = sps.picWidthInMbsMinus1 + 1;
            if (ww > w) {
                w = ww;
            }
            if ((hh = SeqParameterSet.getPicHeightInMbs(sps)) <= h) continue;
            h = hh;
        }
        this.size = new Size(w << 4, h << 4);
    }

    @Override
    public Picture decodeFrame(Packet packet, byte[][] data) {
        this.updateState(packet);
        Frame pic = this.decoder.decodeFrame(packet.getData(), data);
        Rational pasp = this.meta.getVideoCodecMeta().getPixelAspectRatio();
        if (pasp != null) {
            // empty if block
        }
        return pic;
    }

    private void updateState(Packet packet) {
        int eNo = ((MP4Packet)packet).getEntryNo();
        if (eNo != this.curENo) {
            this.curENo = eNo;
        }
        if (this.decoder == null) {
            this.decoder = H264Decoder.createH264DecoderFromCodecPrivate(this.meta.getCodecPrivate());
        }
    }

    @Override
    public boolean canSeek(Packet pkt) {
        this.updateState(pkt);
        return H264Utils.idrSlice(H264Utils.splitFrame(pkt.getData()));
    }

    @Override
    public byte[][] allocatePicture() {
        return Picture.create(this.size.getWidth(), this.size.getHeight(), ColorSpace.YUV444).getData();
    }

    @Override
    public MediaInfo getMediaInfo() {
        return new MediaInfo(this.size);
    }
}

