/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.api.transcode;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.creeperhost.blockshot.repack.org.jcodec.api.transcode.PixelStore;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.ColorSpace;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Picture;

public class PixelStoreImpl
implements PixelStore {
    private Random rnd = new Random();
    private int bound = 10;
    private List<Picture> buffers = new ArrayList<Picture>();

    public int getBound() {
        return this.bound;
    }

    public void setBound(int bound) {
        this.bound = bound;
    }

    @Override
    public PixelStore.LoanerPicture getPicture(int width, int height, ColorSpace color) {
        for (Picture picture : this.buffers) {
            if (picture.getWidth() != width || picture.getHeight() != height || picture.getColor() != color) continue;
            this.buffers.remove(picture);
            return new PixelStore.LoanerPicture(picture, 1);
        }
        return new PixelStore.LoanerPicture(Picture.create(width, height, color), 1);
    }

    @Override
    public void putBack(PixelStore.LoanerPicture frame) {
        frame.decRefCnt();
        if (frame.unused()) {
            Picture pixels = frame.getPicture();
            pixels.setCrop(null);
            if (this.buffers.size() == this.bound) {
                this.buffers.set(this.rnd.nextInt(this.bound), pixels);
            } else {
                this.buffers.add(pixels);
            }
        }
    }

    @Override
    public void retake(PixelStore.LoanerPicture frame) {
        frame.incRefCnt();
    }
}

