/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.aac;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.AACException;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.Decoder;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.aac.ADTSParser;
import net.creeperhost.blockshot.repack.org.jcodec.common.AudioCodecMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.AudioDecoder;
import net.creeperhost.blockshot.repack.org.jcodec.common.UsedViaReflection;
import net.creeperhost.blockshot.repack.org.jcodec.common.logging.Logger;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.AudioBuffer;

public class AACDecoder
implements AudioDecoder {
    private Decoder decoder;

    public AACDecoder(ByteBuffer decoderSpecific) throws AACException {
        if (decoderSpecific.remaining() >= 7) {
            ADTSParser.Header header = ADTSParser.read(decoderSpecific);
            if (header != null) {
                decoderSpecific = ADTSParser.adtsToStreamInfo(header);
            }
            Logger.info("Creating AAC decoder from ADTS header.");
        }
        this.decoder = new Decoder(decoderSpecific);
    }

    @Override
    public AudioBuffer decodeFrame(ByteBuffer frame, ByteBuffer dst) throws IOException {
        ADTSParser.read(frame);
        dst.order(ByteOrder.LITTLE_ENDIAN);
        this.decoder.decodeFrame(frame, dst);
        return new AudioBuffer(dst, this.decoder.getMeta(), 0);
    }

    @Override
    public AudioCodecMeta getCodecMeta(ByteBuffer data) throws IOException {
        this.decoder.decodeFrame(data, ByteBuffer.allocate(65536));
        return AudioCodecMeta.fromAudioFormat(this.decoder.getMeta());
    }

    @UsedViaReflection
    public static int probe(ByteBuffer data) {
        if (data.remaining() < 7) {
            return 0;
        }
        ADTSParser.Header header = ADTSParser.read(data);
        if (header != null) {
            return 100;
        }
        return 0;
    }
}

