/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.io.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.io.model.NALUnit;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.io.model.NALUnitType;

public class NALReasemble {
    private static final int FU_TYPE_MASK = 31;
    private static final int FU_STARTEND_MASK = 192;
    private static final int FU_START_MASK = 128;
    private static final int FU_END_MASK = 64;
    private static final int NRI_MASK = 96;
    private static final int FORBIDDEN_MASK = 128;

    public static byte[] defragmentFUANals(List<ByteBuffer> nals) {
        if (nals == null || nals.isEmpty()) {
            return new byte[0];
        }
        ByteBuffer headNAL = nals.get(0);
        NALUnit nalUnit = NALUnit.read(headNAL);
        headNAL.rewind();
        byte headFuIndicator = headNAL.get();
        byte headFuHeader = headNAL.get();
        headNAL.rewind();
        if (NALUnitType.FU_A != nalUnit.type || (headFuHeader & 0x80) == 0 || (headFuHeader & 0xC0) == 192) {
            return new byte[0];
        }
        int datasize = 1;
        for (int i = 0; i < nals.size(); ++i) {
            datasize += nals.get(i).remaining() - 2;
        }
        byte[] data = new byte[datasize];
        ByteBuffer out = ByteBuffer.wrap(data);
        out.put((byte)(headFuIndicator & 0x60 | headFuHeader & 0x1F));
        int validUntilPosition = -1;
        boolean shouldSetFbit = false;
        for (int i = 0; i < nals.size(); ++i) {
            ByteBuffer nal = nals.get(i);
            nal.get();
            byte fuHeader = nal.get();
            if (i > 0 && (fuHeader & 0x80) == 128 || i == nals.size() - 1 && (fuHeader & 0x40) == 0) {
                shouldSetFbit = true;
            }
            if (nal.hasRemaining()) {
                byte[] buffer = new byte[nal.remaining()];
                nal.get(buffer);
                out.put(buffer);
            }
            if (i == nals.size() - 1 || (fuHeader & 0x40) != 64) continue;
            shouldSetFbit = true;
            validUntilPosition = out.position();
            break;
        }
        if (shouldSetFbit) {
            if (validUntilPosition > -1) {
                data = Arrays.copyOf(data, data.length - (data.length - validUntilPosition));
            }
            data[0] = (byte)(0x80 | data[0]);
        }
        return data;
    }

    private NALReasemble() {
    }
}

