/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx;

import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Iterator;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.CXInterface;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.CodecAlgPRiv;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.CodecEncCfg;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.CodecPkt;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.ExtraCFG;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.AlgoFlags;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.GeneralFrameFlags;
import net.creeperhost.blockshot.repack.org.jcodec.common.VideoEncoder;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.ColorSpace;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Picture;

public class VP8Encoder
extends VideoEncoder {
    public static final ColorSpace[] supportedColorSpaces = new ColorSpace[]{ColorSpace.YUV420};
    public static final short INT_TO_BYTE_OFFSET = 128;
    CodecEncCfg cfg;
    ExtraCFG vp8Cfg;
    CodecAlgPRiv ctx;
    int pts = 0;
    int deadline = CXInterface.VPX_DL_REALTIME;

    public static VP8Encoder createVP8Encoder(short qp) {
        return new VP8Encoder(qp);
    }

    public VP8Encoder() {
        this(-1);
    }

    public VP8Encoder(short qp) {
        this.cfg = new CodecEncCfg();
        this.vp8Cfg = new ExtraCFG();
        if (qp >= 0) {
            this.setQp(qp);
        }
    }

    public void setQp(int qp) {
        this.cfg.setRc_max_quantizer((short)qp);
    }

    public void setScmode(int scmode) {
        this.vp8Cfg.setScreen_content_mode(scmode);
    }

    public void setHinter(String hinter) {
        this.vp8Cfg.setHinterId(hinter);
    }

    public void setDeadline(int deadline) {
        this.deadline = deadline;
    }

    @Override
    public VideoEncoder.EncodedFrame encodeFrame(Picture pic, ByteBuffer _buf) {
        if (this.ctx == null) {
            this.cfg.setG_w(pic.getWidth());
            this.cfg.setG_h(pic.getHeight());
            this.ctx = new CodecAlgPRiv(this.cfg, this.vp8Cfg);
        }
        CXInterface.vp8e_encode(this.ctx, pic, this.pts++, 1L, EnumSet.noneOf(AlgoFlags.class), this.deadline);
        CodecPkt ret = CodecAlgPRiv.vpx_codec_get_cx_data(this.ctx.base, new Iterator[1]);
        CodecPkt.FramePacket fp = (CodecPkt.FramePacket)ret.packet;
        ByteBuffer out = _buf.duplicate();
        for (int i = 0; i < fp.sz; ++i) {
            out.put((byte)fp.buf.getRel(i));
        }
        out.flip();
        return new VideoEncoder.EncodedFrame(out, fp.flags.contains((Object)GeneralFrameFlags.FRAME_IS_KEY));
    }

    @Override
    public ColorSpace[] getSupportedColorSpaces() {
        return supportedColorSpaces;
    }

    @Override
    public int estimateBufferSize(Picture frame) {
        return frame.getWidth() * frame.getHeight() >> 1;
    }

    @Override
    public void finish() {
    }
}

