/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8;

import java.util.Arrays;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.BitStream;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.CommonUtils;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.EncodeIntra;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.EncodeMB;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.Extend;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.IDCTBlk;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.InvTrans;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.Quantize;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.RDOpt;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.ReconInter;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.Tokenize;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.CommonData;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Compressor;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Macroblock;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.MacroblockD;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.ModeInfo;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.PickInfoReturn;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.QuantCommon;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.ReferenceCounts;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.TokenExtra;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.UsecTimer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.YV12buffer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.FrameType;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MBPredictionMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MVReferenceFrame;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.Tuning;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessGenArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.subpixfns.BilinearPredict;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.subpixfns.SixtapPredict;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.subpixfns.SubPixFnCollector;

public class EncodeFrame {
    public static final int VP8_ACTIVITY_AVG_MIN = 64;

    static int alt_activity_measure(Compressor cpi, Macroblock x, boolean use_dc_pred) {
        return EncodeIntra.vp8_encode_intra(cpi, x, use_dc_pred);
    }

    static int mb_activity_measure(Compressor cpi, Macroblock x, int mb_row, int mb_col) {
        boolean use_dc_pred = !(mb_col == 0 && mb_row == 0 || mb_col != 0 && mb_row != 0);
        int mb_activity = EncodeFrame.alt_activity_measure(cpi, x, use_dc_pred);
        if (mb_activity < 64) {
            mb_activity = 64;
        }
        return mb_activity;
    }

    static void calc_av_activity(Compressor cpi, long activity_sum) {
        cpi.activity_avg = (int)(activity_sum / (long)cpi.common.MBs);
        if (cpi.activity_avg < 64) {
            cpi.activity_avg = 64;
        }
        cpi.activity_avg = 100000;
    }

    static void build_activity_map(Compressor cpi) {
        Macroblock x = cpi.mb;
        MacroblockD xd = x.e_mbd;
        CommonData cm = cpi.common;
        YV12buffer new_yv12 = cm.yv12_fb[cm.new_fb_idx];
        int recon_y_stride = new_yv12.y_stride;
        long activity_sum = 0L;
        xd.dst.y_buffer = new_yv12.y_buffer.shallowCopy();
        for (int mb_row = 0; mb_row < cm.mb_rows; ++mb_row) {
            xd.up_available = mb_row != 0;
            xd.dst.y_buffer.incBy(mb_row * recon_y_stride * 16);
            for (int mb_col = 0; mb_col < cm.mb_cols; ++mb_col) {
                xd.left_available = mb_col != 0;
                CommonUtils.vp8_copy_mem16x16(x.src.y_buffer, x.src.y_stride, x.thismb, 16);
                int mb_activity = EncodeFrame.mb_activity_measure(cpi, x, mb_row, mb_col);
                activity_sum += (long)mb_activity;
                x.mb_activity_ptr.setAndInc((short)mb_activity);
                x.src.y_buffer.incBy(16);
                xd.dst.y_buffer.incBy(16);
            }
            xd.dst.y_buffer.incBy(16 * cm.mb_cols);
            x.src.y_buffer.incBy(16 * x.src.y_stride - 16 * cm.mb_cols);
            Extend.vp8_extend_mb_row(new_yv12, xd.dst.y_buffer.shallowCopyWithPosInc(16), xd.dst.u_buffer.shallowCopyWithPosInc(8), xd.dst.v_buffer.shallowCopyWithPosInc(8));
        }
        EncodeFrame.calc_av_activity(cpi, activity_sum);
    }

    static void vp8_activity_masking(Compressor cpi, Macroblock x) {
        long act = x.mb_activity_ptr.get();
        long a = act + (long)(2 * cpi.activity_avg);
        long b = 2L * act + (long)cpi.activity_avg;
        x.rdmult = (int)(((long)x.rdmult * b + (a >> 1)) / a);
        x.errorperbit = x.rdmult * 100 / (110 * x.rddiv);
        x.errorperbit = x.errorperbit + (x.errorperbit == 0 ? 1 : 0);
        EncodeFrame.adjust_act_zbin(cpi, x);
    }

    static void adjust_act_zbin(Compressor cpi, Macroblock x) {
        long act = x.mb_activity_ptr.get();
        long a = act + (long)(4 * cpi.activity_avg);
        long b = 4L * act + (long)cpi.activity_avg;
        x.act_zbin_adj = act > (long)cpi.activity_avg ? (int)((b + (a >> 1)) / a) - 1 : 1 - (int)((a + (b >> 1)) / b);
    }

    static void sum_intra_stats(Compressor cpi, Macroblock x) {
        ModeInfo mi = x.e_mbd.mode_info_context.get();
        MBPredictionMode m = mi.mbmi.mode;
        MBPredictionMode uvm = mi.mbmi.uv_mode;
        int n = m.ordinal();
        x.ymode_count[n] = x.ymode_count[n] + 1;
        int n2 = uvm.ordinal();
        x.uv_mode_count[n2] = x.uv_mode_count[n2] + 1;
    }

    static long vp8cx_encode_intra_macroblock(Compressor cpi, Macroblock x, FullAccessGenArrPointer<TokenExtra> t) {
        MacroblockD xd = x.e_mbd;
        ModeInfo mi = x.e_mbd.mode_info_context.get();
        long rate = cpi.sf.RD && cpi.compressor_speed != 2 ? RDOpt.vp8_rd_pick_intra_mode(x) : x.interPicker.vp8_pick_intra_mode(x);
        if (cpi.oxcf.tuning == Tuning.TUNE_SSIM) {
            EncodeFrame.adjust_act_zbin(cpi, x);
            Quantize.vp8_update_zbin_extra(cpi, x);
        }
        if (mi.mbmi.mode == MBPredictionMode.B_PRED) {
            EncodeIntra.vp8_encode_intra4x4mby(x);
        } else {
            EncodeIntra.vp8_encode_intra16x16mby(x);
        }
        EncodeIntra.vp8_encode_intra16x16mbuv(x);
        EncodeFrame.sum_intra_stats(cpi, x);
        Tokenize.vp8_tokenize_mb(cpi, x, t);
        if (mi.mbmi.mode != MBPredictionMode.B_PRED) {
            InvTrans.vp8_inverse_transform_mby(xd);
        }
        IDCTBlk.vp8_dequant_idct_add_uv_block(xd.qcoeff.shallowCopyWithPosInc(256), xd.dequant_uv, xd.dst.u_buffer, xd.dst.v_buffer, xd.dst.uv_stride, xd.eobs.shallowCopyWithPosInc(16));
        return rate;
    }

    static int vp8cx_encode_inter_macroblock(Compressor cpi, Macroblock x, FullAccessGenArrPointer<TokenExtra> t, int recon_yoffset, int recon_uvoffset, int mb_row, int mb_col) {
        MacroblockD xd = x.e_mbd;
        PickInfoReturn retDetails = new PickInfoReturn();
        x.skip = false;
        ModeInfo mi = xd.mode_info_context.get();
        x.encode_breakout = xd.segmentation_enabled != 0 ? cpi.segment_encode_breakout[mi.mbmi.segment_id] : cpi.oxcf.encode_breakout;
        if (cpi.sf.RD) {
            boolean zbin_mode_boost_enabled = x.zbin_mode_boost_enabled;
            if (cpi.sf.use_fastquant_for_pick) {
                x.quantize_b = Quantize.fastQuant;
                x.zbin_mode_boost_enabled = false;
            }
            RDOpt.vp8_rd_pick_inter_mode(cpi, x, recon_yoffset, recon_uvoffset, retDetails, mb_row, mb_col);
            if (cpi.sf.improved_quant) {
                x.quantize_b = Quantize.regularQuant;
            }
            x.zbin_mode_boost_enabled = zbin_mode_boost_enabled;
        } else {
            x.interPicker.pickInterMode(cpi, x, recon_yoffset, recon_uvoffset, retDetails, mb_row, mb_col);
        }
        x.prediction_error += retDetails.distortion;
        x.intra_error = x.intra_error + (x.skip ? 0L : retDetails.intra);
        if (cpi.oxcf.tuning == Tuning.TUNE_SSIM) {
            EncodeFrame.adjust_act_zbin(cpi, x);
        }
        if (xd.segmentation_enabled != 0 && cpi.current_layer == 0 && cpi.cyclic_refresh_mode_enabled && mi.mbmi.segment_id == 1 && (mi.mbmi.ref_frame != MVReferenceFrame.LAST_FRAME || mi.mbmi.mode != MBPredictionMode.ZEROMV)) {
            mi.mbmi.segment_id = 0;
            Quantize.vp8cx_mb_init_quantizer(cpi, x, true);
        }
        x.zbin_mode_boost = 0;
        if (x.zbin_mode_boost_enabled && mi.mbmi.ref_frame != MVReferenceFrame.INTRA_FRAME) {
            x.zbin_mode_boost = mi.mbmi.mode == MBPredictionMode.ZEROMV ? (mi.mbmi.ref_frame != MVReferenceFrame.LAST_FRAME && cpi.oxcf.number_of_layers == 1 ? 12 : 6) : (mi.mbmi.mode == MBPredictionMode.SPLITMV ? 0 : 4);
        }
        if (cpi.sf.improved_quant) {
            Quantize.vp8_update_zbin_extra(cpi, x);
        }
        MVReferenceFrame rf = mi.mbmi.ref_frame;
        x.count_mb_ref_frame_usage.put(rf, x.count_mb_ref_frame_usage.get((Object)rf) + 1);
        if (mi.mbmi.ref_frame == MVReferenceFrame.INTRA_FRAME) {
            EncodeIntra.vp8_encode_intra16x16mbuv(x);
            if (mi.mbmi.mode == MBPredictionMode.B_PRED) {
                EncodeIntra.vp8_encode_intra4x4mby(x);
            } else {
                EncodeIntra.vp8_encode_intra16x16mby(x);
            }
            EncodeFrame.sum_intra_stats(cpi, x);
        } else {
            int ref_fb_idx = cpi.common.frameIdxs.get((Object)mi.mbmi.ref_frame);
            xd.pre.y_buffer = cpi.common.yv12_fb[ref_fb_idx].y_buffer.shallowCopyWithPosInc(recon_yoffset);
            xd.pre.u_buffer = cpi.common.yv12_fb[ref_fb_idx].u_buffer.shallowCopyWithPosInc(recon_uvoffset);
            xd.pre.v_buffer = cpi.common.yv12_fb[ref_fb_idx].v_buffer.shallowCopyWithPosInc(recon_uvoffset);
            if (!x.skip) {
                EncodeMB.vp8_encode_inter16x16(x);
            } else {
                ReconInter.vp8_build_inter16x16_predictors_mb(xd, xd.dst.y_buffer, xd.dst.u_buffer, xd.dst.v_buffer, xd.dst.y_stride, xd.dst.uv_stride);
            }
        }
        if (!x.skip) {
            Tokenize.vp8_tokenize_mb(cpi, x, t);
            if (mi.mbmi.mode != MBPredictionMode.B_PRED) {
                InvTrans.vp8_inverse_transform_mby(xd);
            }
            IDCTBlk.vp8_dequant_idct_add_uv_block(xd.qcoeff.shallowCopyWithPosInc(256), xd.dequant_uv, xd.dst.u_buffer, xd.dst.v_buffer, xd.dst.uv_stride, xd.eobs.shallowCopyWithPosInc(16));
        } else {
            mi.mbmi.mb_skip_coeff = true;
            if (cpi.common.mb_no_coeff_skip) {
                ++x.skip_true_count;
                Tokenize.vp8_fix_contexts(xd);
            } else {
                Tokenize.vp8_stuff_mb(cpi, x, t);
            }
        }
        return retDetails.rate;
    }

    static void encode_mb_row(Compressor cpi, CommonData cm, int mb_row, Macroblock x, MacroblockD xd, FullAccessGenArrPointer<TokenExtra> tp, int[] segment_counts, long[] totalrate) {
        int ref_fb_idx = cm.frameIdxs.get((Object)MVReferenceFrame.LAST_FRAME);
        int dst_fb_idx = cm.new_fb_idx;
        int recon_y_stride = cm.yv12_fb[ref_fb_idx].y_stride;
        int recon_uv_stride = cm.yv12_fb[ref_fb_idx].uv_stride;
        int map_index = mb_row * cpi.common.mb_cols;
        xd.above_context = cm.above_context.shallowCopy();
        xd.up_available = mb_row != 0;
        int recon_yoffset = mb_row * recon_y_stride * 16;
        int recon_uvoffset = mb_row * recon_uv_stride * 8;
        xd.dst.y_buffer = cm.yv12_fb[dst_fb_idx].y_buffer.shallowCopyWithPosInc(recon_yoffset);
        xd.dst.u_buffer = cm.yv12_fb[dst_fb_idx].u_buffer.shallowCopyWithPosInc(recon_uvoffset);
        xd.dst.v_buffer = cm.yv12_fb[dst_fb_idx].v_buffer.shallowCopyWithPosInc(recon_uvoffset);
        cpi.tplist[mb_row].start = tp.shallowCopy();
        xd.mb_to_top_edge = -(mb_row * 16 << 3);
        xd.mb_to_bottom_edge = (cm.mb_rows - 1 - mb_row) * 16 << 3;
        x.mv_row_min = (short)(-(mb_row * 16 + 16));
        x.mv_row_max = (short)((cm.mb_rows - 1 - mb_row) * 16 + 16);
        x.mb_activity_ptr = cpi.mb_activity_map.shallowCopyWithPosInc(map_index);
        for (int mb_col = 0; mb_col < cm.mb_cols; ++mb_col) {
            ModeInfo mi = xd.mode_info_context.get();
            xd.mb_to_left_edge = -(mb_col * 16 << 3);
            xd.mb_to_right_edge = (cm.mb_cols - 1 - mb_col) * 16 << 3;
            x.mv_col_min = (short)(-(mb_col * 16 + 16));
            x.mv_col_max = (short)((cm.mb_cols - 1 - mb_col) * 16 + 16);
            xd.left_available = mb_col != 0;
            x.rddiv = cpi.RDDIV;
            x.rdmult = cpi.RDMULT;
            CommonUtils.vp8_copy_mem16x16(x.src.y_buffer, x.src.y_stride, x.thismb, 16);
            if (cpi.oxcf.tuning == Tuning.TUNE_SSIM) {
                EncodeFrame.vp8_activity_masking(cpi, x);
            }
            if (xd.segmentation_enabled != 0) {
                mi.mbmi.segment_id = cpi.segmentation_map[map_index + mb_col] <= 3 ? cpi.segmentation_map[map_index + mb_col] : 0;
                Quantize.vp8cx_mb_init_quantizer(cpi, x, true);
            } else {
                mi.mbmi.segment_id = 0;
            }
            x.active_ptr = cpi.active_map.shallowCopyWithPosInc(map_index + mb_col);
            if (cm.frame_type == FrameType.KEY_FRAME) {
                totalrate[0] = totalrate[0] + EncodeFrame.vp8cx_encode_intra_macroblock(cpi, x, tp);
            } else {
                totalrate[0] = totalrate[0] + (long)EncodeFrame.vp8cx_encode_inter_macroblock(cpi, x, tp, recon_yoffset, recon_uvoffset, mb_row, mb_col);
                if (cpi.current_layer == 0) {
                    if (mi.mbmi.mode == MBPredictionMode.ZEROMV && mi.mbmi.ref_frame == MVReferenceFrame.LAST_FRAME) {
                        if (cpi.consec_zero_last[map_index + mb_col] < 255) {
                            int n = map_index + mb_col;
                            cpi.consec_zero_last[n] = cpi.consec_zero_last[n] + 1;
                        }
                        if (cpi.consec_zero_last_mvbias[map_index + mb_col] < 255) {
                            int n = map_index + mb_col;
                            cpi.consec_zero_last_mvbias[n] = cpi.consec_zero_last_mvbias[n] + 1;
                        }
                    } else {
                        cpi.consec_zero_last[map_index + mb_col] = 0;
                        cpi.consec_zero_last_mvbias[map_index + mb_col] = 0;
                    }
                    if (x.zero_last_dot_suppress) {
                        cpi.consec_zero_last_mvbias[map_index + mb_col] = 0;
                    }
                }
                if (cpi.current_layer == 0 && cpi.cyclic_refresh_mode_enabled && xd.segmentation_enabled != 0) {
                    cpi.segmentation_map[map_index + mb_col] = mi.mbmi.segment_id;
                    if (mi.mbmi.segment_id != 0) {
                        cpi.cyclic_refresh_map[map_index + mb_col] = -1;
                    } else if (mi.mbmi.mode == MBPredictionMode.ZEROMV && mi.mbmi.ref_frame == MVReferenceFrame.LAST_FRAME) {
                        if (cpi.cyclic_refresh_map[map_index + mb_col] == 1) {
                            cpi.cyclic_refresh_map[map_index + mb_col] = 0;
                        }
                    } else {
                        cpi.cyclic_refresh_map[map_index + mb_col] = 1;
                    }
                }
            }
            cpi.tplist[mb_row].stop = tp.shallowCopy();
            x.gf_active_ptr.inc();
            x.mb_activity_ptr.inc();
            x.src.y_buffer.incBy(16);
            x.src.u_buffer.incBy(8);
            x.src.v_buffer.incBy(8);
            recon_yoffset += 16;
            recon_uvoffset += 8;
            xd.dst.y_buffer.incBy(16);
            xd.dst.u_buffer.incBy(8);
            xd.dst.v_buffer.incBy(8);
            int n = mi.mbmi.segment_id;
            segment_counts[n] = segment_counts[n] + 1;
            xd.mode_info_context.inc();
            x.partition_info.inc();
            xd.above_context.inc();
        }
        Extend.vp8_extend_mb_row(cm.yv12_fb[dst_fb_idx], xd.dst.y_buffer, xd.dst.u_buffer, xd.dst.v_buffer);
        xd.mode_info_context.inc();
        x.partition_info.inc();
    }

    static void init_encode_frame_mb_context(Compressor cpi) {
        cpi.mb.e_mbd.init_encode_frame_mbd_context(cpi);
        cpi.mb.init_encode_frame_mb_context(cpi);
        CommonData cm = cpi.common;
        if (cm.frame_type == FrameType.KEY_FRAME) {
            cm.fc.vp8_init_mbmode_probs();
        }
        cm.yv12_fb[cm.new_fb_idx].vp8_setup_intra_recon();
        for (int kk = 0; kk < cm.mb_cols; ++kk) {
            cm.above_context.getRel(kk).reset();
        }
    }

    static void vp8_encode_frame(Compressor cpi) {
        Macroblock x = cpi.mb;
        CommonData cm = cpi.common;
        MacroblockD xd = x.e_mbd;
        FullAccessGenArrPointer<TokenExtra> tp = cpi.tok.shallowCopy();
        int[] segment_counts = new int[xd.segmentation_enabled != 0 ? 4 : 1];
        long[] totalrate = new long[1];
        CommonUtils.vp8_zero(segment_counts);
        if (cpi.compressor_speed == 2) {
            if (cpi.oxcf.getCpu_used() < 0) {
                cpi.Speed = -cpi.oxcf.getCpu_used();
            } else {
                RDOpt.vp8_auto_select_speed(cpi);
            }
        }
        SubPixFnCollector spfncollector = cm.use_bilinear_mc_filter ? BilinearPredict.bilinear : SixtapPredict.sixtap;
        xd.subpixel_predict = spfncollector.get4x4();
        xd.subpixel_predict8x4 = spfncollector.get8x4();
        xd.subpixel_predict8x8 = spfncollector.get8x8();
        xd.subpixel_predict16x16 = spfncollector.get16x16();
        cpi.mb.skip_true_count = 0;
        cpi.tok_count = 0;
        xd.mode_info_context = cm.mi.shallowCopy();
        CommonUtils.vp8_zero(cpi.mb.MVcount);
        Quantize.vp8cx_frame_init_quantizer(cpi);
        RDOpt.vp8_initialize_rd_consts(cpi, x, QuantCommon.doLookup(cm, CommonData.Quant.Y1, CommonData.Comp.DC, cm.base_qindex));
        x.vp8cx_initialize_me_consts(cm.base_qindex);
        if (cpi.oxcf.tuning == Tuning.TUNE_SSIM) {
            EncodeFrame.init_encode_frame_mb_context(cpi);
            EncodeFrame.build_activity_map(cpi);
        }
        EncodeFrame.init_encode_frame_mb_context(cpi);
        UsecTimer emr_timer = new UsecTimer();
        emr_timer.timerStart();
        for (int mb_row = 0; mb_row < cm.mb_rows; ++mb_row) {
            CommonUtils.vp8_zero(cm.left_context.panes);
            EncodeFrame.encode_mb_row(cpi, cm, mb_row, x, xd, tp, segment_counts, totalrate);
            x.src.y_buffer.incBy(16 * x.src.y_stride - 16 * cm.mb_cols);
            x.src.u_buffer.incBy(8 * x.src.uv_stride - 8 * cm.mb_cols);
            x.src.v_buffer.incBy(8 * x.src.uv_stride - 8 * cm.mb_cols);
        }
        cpi.tok_count = cpi.tok.pointerDiff(tp);
        emr_timer.mark();
        cpi.time_encode_mb_row += emr_timer.elapsed();
        if (xd.segmentation_enabled != 0 && xd.update_mb_segmentation_map) {
            Arrays.fill(xd.mb_segment_tree_probs, 255);
            int tot_count = segment_counts[0] + segment_counts[1] + segment_counts[2] + segment_counts[3];
            if (tot_count != 0) {
                xd.mb_segment_tree_probs[0] = (segment_counts[0] + segment_counts[1]) * 255 / tot_count;
                tot_count = segment_counts[0] + segment_counts[1];
                if (tot_count > 0) {
                    xd.mb_segment_tree_probs[1] = segment_counts[0] * 255 / tot_count;
                }
                if ((tot_count = segment_counts[2] + segment_counts[3]) > 0) {
                    xd.mb_segment_tree_probs[2] = segment_counts[2] * 255 / tot_count;
                }
                for (int i = 0; i < 3; ++i) {
                    if (xd.mb_segment_tree_probs[i] != 0) continue;
                    xd.mb_segment_tree_probs[i] = 1;
                }
            }
        }
        cpi.projected_frame_size = (int)(totalrate[0] >> 8);
        if (cm.frame_type == FrameType.KEY_FRAME) {
            cpi.this_frame_percent_intra = 100;
        } else {
            ReferenceCounts rf = cpi.mb.sumReferenceCounts();
            if (rf.total != 0) {
                cpi.this_frame_percent_intra = rf.intra * 100 / rf.total;
            }
        }
        if (cm.frame_type != FrameType.KEY_FRAME && (cpi.oxcf.number_of_layers > 1 || !cm.refresh_alt_ref_frame && !cm.refresh_golden_frame)) {
            BitStream.vp8_convert_rfct_to_prob(cpi);
        }
    }
}

