/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8;

import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.BoolEncoder;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.TreeCoder;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.TreeWriter;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Compressor;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.EntropyMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.MV;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.MVContext;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Token;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.PositionableIntArrPointer;

public class EncodeMV {
    static void encode_mvcomponent(BoolEncoder w, int v, MVContext mvc) {
        int x;
        PositionableIntArrPointer p = mvc.prob.positionableOnly();
        int n = x = v < 0 ? -v : v;
        if (x < 8) {
            w.vp8_encode_bool(false, p.getRel(0));
            p.incBy(2);
            TreeWriter.vp8_treed_write(w, EntropyMode.vp8_small_mvtree, p, x, 3);
            p.rewind();
            if (x == 0) {
                return;
            }
        } else {
            int i = 0;
            w.vp8_encode_bool(true, p.getRel(0));
            p.incBy(9);
            do {
                w.vp8_encode_bool((x >> i & 1) == 1, p.getRel(i));
            } while (++i < 3);
            i = 9;
            do {
                w.vp8_encode_bool((x >> i & 1) == 1, p.getRel(i));
            } while (--i > 3);
            if ((x & 0xFFF0) > 0) {
                w.vp8_encode_bool((x >> 3 & 1) == 1, p.getRel(3));
            }
            p.rewind();
        }
        w.vp8_encode_bool(v < 0, p.getRel(1));
    }

    static void vp8_encode_motion_vector(BoolEncoder w, MV mv, MVContext[] mvc) {
        EncodeMV.encode_mvcomponent(w, mv.row >> 1, mvc[0]);
        EncodeMV.encode_mvcomponent(w, mv.col >> 1, mvc[1]);
    }

    static short calc_prob(short p, int[] ct) {
        int tot = ct[0] + ct[1];
        if (tot != 0) {
            int x = ct[0] * 255 / tot & 0xFFFFFFFE;
            return (short)(x != 0 ? x : 1);
        }
        return p;
    }

    static int cost_mvcomponent(int v, MVContext mvc) {
        int cost;
        PositionableIntArrPointer p = mvc.prob.positionableOnly();
        int x = v;
        if (x < 8) {
            cost = TreeWriter.vp8_cost_zero(p.getRel(0));
            p.incBy(2);
            cost += TreeWriter.vp8_treed_cost(EntropyMode.vp8_small_mvtree, p, x, 3);
            if (x == 0) {
                return cost;
            }
        } else {
            int i = 0;
            cost = TreeWriter.vp8_cost_one(p.getRel(0));
            p.incBy(9);
            do {
                cost += TreeWriter.vp8_cost_bit(p.getRel(i), x >> i & 1);
            } while (++i < 3);
            i = 9;
            do {
                cost += TreeWriter.vp8_cost_bit(p.getRel(i), x >> i & 1);
            } while (--i > 3);
            if ((x & 0xFFF0) != 0) {
                cost += TreeWriter.vp8_cost_bit(p.getRel(3), x >> 3 & 1);
            }
        }
        return cost;
    }

    static void vp8_build_component_cost_table(FullAccessIntArrPointer[] mvcost, MVContext[] mvc, boolean[] mvc_flag) {
        int i = 1;
        int cost0 = 0;
        int cost1 = 0;
        if (mvc_flag[0]) {
            mvcost[0].set((short)EncodeMV.cost_mvcomponent(0, mvc[0]));
            do {
                cost0 = EncodeMV.cost_mvcomponent(i, mvc[0]);
                mvcost[0].setRel(i, (short)(cost0 + TreeWriter.vp8_cost_zero(mvc[0].prob.getRel(1))));
                mvcost[0].setRel(-i, (short)(cost0 + TreeWriter.vp8_cost_one(mvc[0].prob.getRel(1))));
            } while (++i <= 1023);
        }
        i = 1;
        if (mvc_flag[1]) {
            mvcost[1].set((short)EncodeMV.cost_mvcomponent(0, mvc[1]));
            do {
                cost1 = EncodeMV.cost_mvcomponent(i, mvc[1]);
                mvcost[1].setRel(i, (short)(cost1 + TreeWriter.vp8_cost_zero(mvc[1].prob.getRel(1))));
                mvcost[1].setRel(-i, (short)(cost1 + TreeWriter.vp8_cost_one(mvc[1].prob.getRel(1))));
            } while (++i <= 1023);
        }
    }

    static boolean update(BoolEncoder w, int[] ct, FullAccessIntArrPointer cur_p, int idx, short new_p, int update_p) {
        int cost;
        int new_b;
        int cur_b = TreeWriter.vp8_cost_branch(ct, cur_p.getRel(idx));
        if (cur_b - (new_b = TreeWriter.vp8_cost_branch(ct, new_p)) > (cost = 6 + (TreeWriter.vp8_cost_one(update_p) - TreeWriter.vp8_cost_zero(update_p) + 128 >> 8))) {
            cur_p.setRel(idx, new_p);
            w.vp8_encode_bool(true, update_p);
            TreeWriter.vp8_write_literal(w, new_p >> 1, 7);
            return true;
        }
        w.vp8_encode_bool(false, update_p);
        return false;
    }

    static boolean write_component_probs(BoolEncoder w, MVContext cur_mvc, MVContext default_mvc_, MVContext update_mvc, int[] events, int rc) {
        boolean updated = false;
        FullAccessIntArrPointer Pcur = cur_mvc.prob;
        FullAccessIntArrPointer Pupdate = update_mvc.prob;
        int updateidx = 0;
        int[] is_short_ct = new int[2];
        int[] sign_ct = new int[2];
        int[][] bit_ct = new int[10][2];
        int[] short_ct = new int[8];
        int[][] short_bct = new int[7][2];
        short[] Pnew = new short[19];
        default_mvc_.prob.memcopyout(0, Pnew, 0, 19);
        int c = events[1023];
        is_short_ct[0] = is_short_ct[0] + c;
        short_ct[0] = short_ct[0] + c;
        int j = 1;
        do {
            int c1 = events[1023 + j];
            int c2 = events[1023 - j];
            int c3 = c1 + c2;
            int a = j;
            sign_ct[0] = sign_ct[0] + c1;
            sign_ct[1] = sign_ct[1] + c2;
            if (a < 8) {
                is_short_ct[0] = is_short_ct[0] + c3;
                int n = a;
                short_ct[n] = short_ct[n] + c3;
                continue;
            }
            int k = 9;
            is_short_ct[1] = is_short_ct[1] + c3;
            do {
                int[] nArray = bit_ct[k];
                int n = a >> k & 1;
                nArray[n] = nArray[n] + c3;
            } while (--k >= 0);
        } while (++j <= 1023);
        Pnew[0] = EncodeMV.calc_prob(Pnew[0], is_short_ct);
        Pnew[1] = EncodeMV.calc_prob(Pnew[1], sign_ct);
        short[] p = new short[7];
        int j2 = 0;
        TreeCoder.vp8_tree_probs_from_distribution(8, Token.vp8_small_mvencodings, EntropyMode.vp8_small_mvtree, p, short_bct, short_ct, 256, true);
        do {
            Pnew[2 + j2] = EncodeMV.calc_prob(Pnew[2 + j2], short_bct[j2]);
        } while (++j2 < 7);
        j = 0;
        do {
            Pnew[9 + j] = EncodeMV.calc_prob(Pnew[9 + j], bit_ct[j]);
        } while (++j < 10);
        updated |= EncodeMV.update(w, is_short_ct, Pcur, 0, Pnew[0], Pupdate.getRel(updateidx++));
        updated |= EncodeMV.update(w, sign_ct, Pcur, 1, Pnew[1], Pupdate.getRel(updateidx++));
        j = 0;
        do {
            updated |= EncodeMV.update(w, short_bct[j], Pcur, j + 2, Pnew[j + 2], Pupdate.getRel(updateidx++));
        } while (++j < 7);
        j = 0;
        do {
            updated |= EncodeMV.update(w, bit_ct[j], Pcur, j + 9, Pnew[j + 9], Pupdate.getRel(updateidx++));
        } while (++j < 10);
        return updated;
    }

    static void vp8_write_mvprobs(Compressor cpi) {
        BoolEncoder w = cpi.bc[0];
        MVContext[] mvc = cpi.common.fc.mvc;
        boolean[] flags = new boolean[]{false, false};
        flags[0] = EncodeMV.write_component_probs(w, mvc[0], MVContext.vp8_default_mv_context[0], MVContext.vp8_mv_update_probs[0], cpi.mb.MVcount[0], 0);
        flags[1] = EncodeMV.write_component_probs(w, mvc[1], MVContext.vp8_default_mv_context[1], MVContext.vp8_mv_update_probs[1], cpi.mb.MVcount[1], 1);
        if (flags[0] || flags[1]) {
            EncodeMV.vp8_build_component_cost_table(cpi.mb.mvcost, cpi.common.fc.mvc, flags);
        }
    }
}

