/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8;

import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.Dequantize;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.IDCTllm;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.PositionableIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.ReadOnlyIntArrPointer;

public class IDCTBlk {
    static void vp8_dequant_idct_add_core(int imax, int jmax, PositionableIntArrPointer eobs, FullAccessIntArrPointer q, ReadOnlyIntArrPointer dq, FullAccessIntArrPointer dst, int stride) {
        int dstinc = stride - jmax << 2;
        for (int i = 0; i < imax; ++i) {
            for (int j = 0; j < jmax; ++j) {
                if (eobs.get() > 1) {
                    Dequantize.vp8_dequant_idct_add(q, dq, dst, stride);
                } else {
                    IDCTllm.vp8_dc_only_idct_add(q.get() * dq.get(), dst, stride, dst, stride);
                    q.memset(0, (short)0, 2);
                }
                eobs.inc();
                q.incBy(16);
                dst.incBy(4);
            }
            dst.incBy(dstinc);
        }
    }

    static void vp8_dequant_idct_add_y_block(FullAccessIntArrPointer q, ReadOnlyIntArrPointer dq, FullAccessIntArrPointer dst, int stride, PositionableIntArrPointer eobs) {
        int ep = eobs.getPos();
        int qp = q.getPos();
        int dp = dst.getPos();
        IDCTBlk.vp8_dequant_idct_add_core(4, 4, eobs, q, dq, dst, stride);
        eobs.setPos(ep);
        q.setPos(qp);
        dst.setPos(dp);
    }

    static void vp8_dequant_idct_add_uv_block(FullAccessIntArrPointer q, ReadOnlyIntArrPointer dq, FullAccessIntArrPointer dst_u, FullAccessIntArrPointer dst_v, int stride, PositionableIntArrPointer eobs) {
        int ep = eobs.getPos();
        int qp = q.getPos();
        int dup = dst_u.getPos();
        int dvp = dst_v.getPos();
        IDCTBlk.vp8_dequant_idct_add_core(2, 2, eobs, q, dq, dst_u, stride);
        IDCTBlk.vp8_dequant_idct_add_core(2, 2, eobs, q, dq, dst_v, stride);
        eobs.setPos(ep);
        q.setPos(qp);
        dst_u.setPos(dup);
        dst_v.setPos(dvp);
    }
}

