/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8;

import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.CommonUtils;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.PositionableIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.ReadOnlyIntArrPointer;

public class IDCTllm {
    public static final int cospi8sqrt2minus1 = 20091;
    public static final int sinpi8sqrt2 = 35468;

    public static void vp8_short_idct4x4llm(PositionableIntArrPointer ip, PositionableIntArrPointer pred_ptr, int pred_stride, FullAccessIntArrPointer dst_ptr, int dst_stride) {
        FullAccessIntArrPointer op = IDCTllm.vp8_short_idct4x4NoAdd(ip);
        for (int r = 0; r < 4; ++r) {
            int basePred = r * pred_stride;
            int baseDst = r * dst_stride;
            for (int c = 0; c < 4; ++c) {
                dst_ptr.setRel(baseDst + c, CommonUtils.clipPixel((short)(op.getRel(c) + pred_ptr.getRel(basePred + c))));
            }
            op.incBy(4);
        }
    }

    public static FullAccessIntArrPointer vp8_short_idct4x4NoAdd(PositionableIntArrPointer ip) {
        int d1;
        int c1;
        int temp2;
        int temp1;
        int b1;
        int a1;
        int i;
        int inPos = ip.getPos();
        FullAccessIntArrPointer op = new FullAccessIntArrPointer(16);
        int shortpitch = 4;
        for (i = 0; i < 4; ++i) {
            a1 = ip.get() + ip.getRel(8);
            b1 = ip.get() - ip.getRel(8);
            temp1 = ip.getRel(4) * 35468 >> 16;
            temp2 = ip.getRel(12) + (ip.getRel(12) * 20091 >> 16);
            c1 = temp1 - temp2;
            temp1 = ip.getRel(4) + (ip.getRel(4) * 20091 >> 16);
            temp2 = ip.getRel(12) * 35468 >> 16;
            d1 = temp1 + temp2;
            op.set((short)(a1 + d1));
            op.setRel(12, (short)(a1 - d1));
            op.setRel(4, (short)(b1 + c1));
            op.setRel(8, (short)(b1 - c1));
            ip.inc();
            op.inc();
        }
        ip.setPos(inPos);
        op.rewind();
        for (i = 0; i < 4; ++i) {
            a1 = op.get() + op.getRel(2);
            b1 = op.get() - op.getRel(2);
            temp1 = op.getRel(1) * 35468 >> 16;
            temp2 = op.getRel(3) + (op.getRel(3) * 20091 >> 16);
            c1 = temp1 - temp2;
            temp1 = op.getRel(1) + (op.getRel(1) * 20091 >> 16);
            temp2 = op.getRel(3) * 35468 >> 16;
            d1 = temp1 + temp2;
            op.set((short)(a1 + d1 + 4 >> 3));
            op.setRel(3, (short)(a1 - d1 + 4 >> 3));
            op.setRel(1, (short)(b1 + c1 + 4 >> 3));
            op.setRel(2, (short)(b1 - c1 + 4 >> 3));
            op.incBy(4);
        }
        op.rewind();
        return op;
    }

    static void vp8_dc_only_idct_add(int input_dc, PositionableIntArrPointer pred_ptr, int pred_stride, FullAccessIntArrPointer dst_ptr, int dst_stride) {
        int a1 = input_dc + 4 >> 3;
        for (int r = 0; r < 4; ++r) {
            int dstBase = r * dst_stride;
            int predBase = r * pred_stride;
            for (int c = 0; c < 4; ++c) {
                dst_ptr.setRel(dstBase + c, CommonUtils.clipPixel((short)(a1 + pred_ptr.getRel(predBase + c))));
            }
        }
    }

    public static void vp8_short_inv_walsh4x4(PositionableIntArrPointer ip, FullAccessIntArrPointer mb_dqcoeff) {
        int d1;
        int c1;
        int b1;
        int a1;
        int i;
        int inPos = ip.getPos();
        FullAccessIntArrPointer op = new FullAccessIntArrPointer(16);
        for (i = 0; i < 4; ++i) {
            a1 = ip.get() + ip.getRel(12);
            b1 = ip.getRel(4) + ip.getRel(8);
            c1 = ip.getRel(4) - ip.getRel(8);
            d1 = ip.get() - ip.getRel(12);
            op.set((short)(a1 + b1));
            op.setRel(4, (short)(c1 + d1));
            op.setRel(8, (short)(a1 - b1));
            op.setRel(12, (short)(d1 - c1));
            ip.inc();
            op.inc();
        }
        op.rewind();
        ip.setPos(inPos);
        for (i = 0; i < 4; ++i) {
            a1 = op.get() + op.getRel(3);
            b1 = op.getRel(1) + op.getRel(2);
            c1 = op.getRel(1) - op.getRel(2);
            d1 = op.get() - op.getRel(3);
            int a2 = a1 + b1;
            int b2 = c1 + d1;
            int c2 = a1 - b1;
            int d2 = d1 - c1;
            op.setAndInc((short)(a2 + 3 >> 3));
            op.setAndInc((short)(b2 + 3 >> 3));
            op.setAndInc((short)(c2 + 3 >> 3));
            op.setAndInc((short)(d2 + 3 >> 3));
        }
        op.rewind();
        for (i = 0; i < 16; ++i) {
            mb_dqcoeff.setRel(i << 4, op.getRel(i));
        }
    }

    static void vp8_short_inv_walsh4x4_1(ReadOnlyIntArrPointer input, FullAccessIntArrPointer mb_dqcoeff) {
        int a1 = input.get() + 3 >> 3;
        for (int i = 0; i < 16; ++i) {
            mb_dqcoeff.setRel(i << 4, (short)a1);
        }
    }
}

