/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8;

import java.util.EnumMap;
import java.util.Iterator;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.CommonUtils;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.EncodeIntra;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.FindNearMV;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.MComp;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.RDOpt;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.ReconIntra;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.Variance;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Block;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.BlockD;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Compressor;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.MBModeInfo;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.MV;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Macroblock;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.MacroblockD;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.ModeInfo;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.PickInfoReturn;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.QualityMetrics;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.VarWithNum;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.VarianceFNs;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.VarianceResults;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.BPredictionMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.BlockEnum;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.FrameType;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MBPredictionMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MVReferenceFrame;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.SearchMethods;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessGenArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.ReadOnlyIntArrPointer;

public class PickInter {
    public static int[] nearsaddx_proto = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    public final MV[] best_ref_mv_sb = new MV[]{new MV(), new MV()};
    public final MV[][] mode_mv_sb = new MV[2][MBPredictionMode.count];
    public final MV best_ref_mv = new MV();
    public MV[] mode_mv;
    public final MV mvp = new MV();
    final EnumMap<MBPredictionMode, int[]> pred_error = new EnumMap(MBPredictionMode.class);
    final int[] mdCounts = new int[4];
    final int[] nearsad = new int[nearsaddx_proto.length];

    public PickInter() {
        for (int i = 0; i < this.mode_mv_sb.length; ++i) {
            for (int j = 0; j < this.mode_mv_sb[i].length; ++j) {
                this.mode_mv_sb[i][j] = new MV();
            }
        }
        for (MBPredictionMode m : MBPredictionMode.nonBlockPred) {
            this.pred_error.put(m, new int[1]);
        }
    }

    public void reset() {
        int i;
        for (i = 0; i < this.best_ref_mv_sb.length; ++i) {
            this.best_ref_mv_sb[i].setZero();
        }
        for (i = 0; i < this.mode_mv_sb.length; ++i) {
            for (int j = 0; j < this.mode_mv_sb[i].length; ++j) {
                this.mode_mv_sb[i][j].setZero();
            }
        }
        this.best_ref_mv.setZero();
        this.mvp.setZero();
        CommonUtils.vp8_zero(this.nearsad);
        CommonUtils.vp8_copy(nearsaddx_proto, this.nearsad);
        for (MBPredictionMode m : MBPredictionMode.nonBlockPred) {
            this.pred_error.get((Object)((Object)m))[0] = 0;
        }
    }

    static int macroblock_corner_grad(ReadOnlyIntArrPointer signal, int stride, int offsetx, int offsety, int sgnx, int sgny) {
        int baseStride = offsetx * stride;
        int sgnExtStride = baseStride + sgnx * stride;
        int sgnYExty = offsety + sgny;
        short y1 = signal.getRel(baseStride + offsety);
        short y2 = signal.getRel(baseStride + sgnYExty);
        short y3 = signal.getRel(sgnExtStride + offsety);
        short y4 = signal.getRel(sgnExtStride + sgnYExty);
        return Math.max(Math.max(Math.abs(y1 - y2), Math.abs(y1 - y3)), Math.abs(y1 - y4));
    }

    static void update_mvcount(Macroblock x, MV best_ref_mv) {
        MBModeInfo mbmi = x.e_mbd.mode_info_context.get().mbmi;
        if (mbmi.mode == MBPredictionMode.NEWMV) {
            MV mv = mbmi.mv;
            MV bmv = best_ref_mv;
            int[] nArray = x.MVcount[0];
            int n = 1023 + (mv.row - bmv.row >> 1);
            nArray[n] = nArray[n] + 1;
            int[] nArray2 = x.MVcount[1];
            int n2 = 1023 + (mv.col - bmv.col >> 1);
            nArray2[n2] = nArray2[n2] + 1;
        }
    }

    public void pick_intra_mbuv_mode(Macroblock mb) {
        int expected_vdc;
        int expected_udc;
        MacroblockD x = mb.e_mbd;
        FullAccessIntArrPointer usrc_ptr = mb.block.getRel(16).getSrcPtr();
        FullAccessIntArrPointer vsrc_ptr = mb.block.getRel(20).getSrcPtr();
        int uvsrc_stride = mb.block.getRel((int)16).src_stride;
        short utop_left = x.dst.u_buffer.getRel(-x.dst.uv_stride - 1);
        short vtop_left = x.dst.v_buffer.getRel(-x.dst.uv_stride - 1);
        this.reset();
        if (!x.up_available && !x.left_available) {
            expected_udc = 128;
            expected_vdc = 128;
        } else {
            int i;
            int shift = 2;
            int uaverage = 0;
            int vaverage = 0;
            if (x.up_available) {
                i = 0;
                int relI = -x.dst.uv_stride;
                while (i < 8) {
                    uaverage += x.dst.u_buffer.getRel(relI);
                    vaverage += x.dst.v_buffer.getRel(relI);
                    ++i;
                    ++relI;
                }
                ++shift;
            }
            if (x.left_available) {
                for (i = 0; i < 8; ++i) {
                    uaverage += x.dst.u_buffer.getRel(i * x.dst.uv_stride - 1);
                    vaverage += x.dst.v_buffer.getRel(i * x.dst.uv_stride - 1);
                }
                ++shift;
            }
            expected_udc = CommonUtils.roundPowerOfTwo(uaverage, shift);
            expected_vdc = CommonUtils.roundPowerOfTwo(vaverage, shift);
        }
        for (int i = 0; i < 8; ++i) {
            int j = 0;
            int relJ = -x.dst.uv_stride;
            while (j < 8) {
                short uab = x.dst.u_buffer.getRel(relJ);
                short vab = x.dst.v_buffer.getRel(relJ);
                short ule = x.dst.u_buffer.getRel(i * x.dst.uv_stride - 1);
                short vle = x.dst.v_buffer.getRel(i * x.dst.uv_stride - 1);
                short predu = CommonUtils.clipPixel((short)(ule + uab - utop_left));
                short predv = CommonUtils.clipPixel((short)(vle + vab - vtop_left));
                short u_p = usrc_ptr.getRel(j);
                short v_p = vsrc_ptr.getRel(j);
                short diffU = (short)(u_p - expected_udc);
                short diffV = (short)(v_p - expected_vdc);
                int[] nArray = this.pred_error.get((Object)MBPredictionMode.DC_PRED);
                nArray[0] = nArray[0] + (diffU * diffU + diffV * diffV);
                diffU = (short)(u_p - uab);
                diffV = (short)(v_p - vab);
                int[] nArray2 = this.pred_error.get((Object)MBPredictionMode.V_PRED);
                nArray2[0] = nArray2[0] + (diffU * diffU + diffV * diffV);
                diffU = (short)(u_p - ule);
                diffV = (short)(v_p - vle);
                int[] nArray3 = this.pred_error.get((Object)MBPredictionMode.H_PRED);
                nArray3[0] = nArray3[0] + (diffU * diffU + diffV * diffV);
                diffU = (short)(u_p - predu);
                diffV = (short)(v_p - predv);
                int[] nArray4 = this.pred_error.get((Object)MBPredictionMode.TM_PRED);
                nArray4[0] = nArray4[0] + (diffU * diffU + diffV * diffV);
                ++j;
                ++relJ;
            }
            usrc_ptr.incBy(uvsrc_stride);
            vsrc_ptr.incBy(uvsrc_stride);
            if (i != 3) continue;
            Block ublk = mb.block.getRel(18);
            Block vblk = mb.block.getRel(22);
            usrc_ptr.setPos(ublk.base_src.getPos() + ublk.src);
            vsrc_ptr.setPos(vblk.base_src.getPos() + vblk.src);
        }
        int best_error = Integer.MAX_VALUE;
        MBPredictionMode best_mode = null;
        for (MBPredictionMode pm : MBPredictionMode.nonBlockPred) {
            int pe = this.pred_error.get((Object)pm)[0];
            if (best_error <= pe) continue;
            best_error = pe;
            best_mode = pm;
        }
        assert (best_mode != null);
        mb.e_mbd.mode_info_context.get().mbmi.uv_mode = best_mode;
    }

    static int get_prediction_error(Block be, BlockD b) {
        return Variance.vpx_get4x4sse_cs(be.getSrcPtr(), be.src_stride, b.predictor, 16);
    }

    static void pick_intra4x4block(Macroblock x, BPredictionMode[] bestmode, int ib, EnumMap<BPredictionMode, Integer> mode_costs, QualityMetrics best) {
        BlockD b = x.e_mbd.block.getRel(ib);
        Block be = x.block.getRel(ib);
        int dst_stride = x.e_mbd.dst.y_stride;
        best.error = Long.MAX_VALUE;
        FullAccessIntArrPointer Above = b.getOffsetPointer(x.e_mbd.dst.y_buffer).shallowCopyWithPosInc(-dst_stride);
        FullAccessIntArrPointer yleft = b.getOffsetPointer(x.e_mbd.dst.y_buffer).shallowCopyWithPosInc(-1);
        short top_left = Above.getRel(-1);
        for (BPredictionMode mode : BPredictionMode.basicbmodes) {
            int rate = mode_costs.get((Object)mode);
            x.recon.vp8_intra4x4_predict(Above, yleft, dst_stride, mode, b.predictor, 16, top_left);
            long distortion = PickInter.get_prediction_error(be, b);
            long this_rd = RDOpt.RDCOST(x.rdmult, x.rddiv, rate, distortion);
            if (this_rd >= best.error) continue;
            best.rateBase = rate;
            best.distortion = distortion;
            best.error = this_rd;
            bestmode[0] = mode;
        }
        b.bmi.as_mode(bestmode[0]);
        EncodeIntra.vp8_encode_intra4x4block(x, ib);
    }

    static void pick_intra4x4mby_modes(Macroblock mb, QualityMetrics best) {
        int i;
        MacroblockD xd = mb.e_mbd;
        int cost = mb.mbmode_cost.get((Object)xd.frame_type).get((Object)MBPredictionMode.B_PRED);
        long distortion = 0L;
        ReconIntra.intra_prediction_down_copy(xd);
        EnumMap<BPredictionMode, Integer> bmode_costs = mb.inter_bmode_costs;
        QualityMetrics curr = new QualityMetrics();
        for (i = 0; i < 16; ++i) {
            FullAccessGenArrPointer<ModeInfo> mic = xd.mode_info_context;
            int mis = xd.mode_info_stride;
            BPredictionMode[] best_mode = new BPredictionMode[]{null};
            if (mb.e_mbd.frame_type == FrameType.KEY_FRAME) {
                BPredictionMode A = FindNearMV.above_block_mode(mic, i, mis);
                BPredictionMode L = FindNearMV.left_block_mode(mic, i);
                bmode_costs = mb.bmode_costs.get((Object)A).get((Object)L);
            }
            PickInter.pick_intra4x4block(mb, best_mode, i, bmode_costs, curr);
            cost += curr.rateBase;
            distortion += curr.distortion;
            assert (best_mode[0] != null);
            mic.get().bmi[i].as_mode(best_mode[0]);
            if (distortion > best.distortion) break;
        }
        best.rateBase = cost;
        if (i == 16) {
            best.distortion = distortion;
            best.error = RDOpt.RDCOST(mb.rdmult, mb.rddiv, cost, distortion);
        } else {
            best.distortion = Integer.MAX_VALUE;
            best.error = Integer.MAX_VALUE;
        }
    }

    private static boolean dotArtifactHelper(Macroblock x, ReadOnlyIntArrPointer target_last, int stride, ReadOnlyIntArrPointer last_ref, int shiftx, int shifty, int signx, int signy) {
        int threshold1 = 6;
        int threshold2 = 3;
        int grad_last = PickInter.macroblock_corner_grad(last_ref, stride, shiftx, shifty, signx, signy);
        int grad_source = PickInter.macroblock_corner_grad(target_last, stride, shiftx, shifty, signx, signy);
        if (grad_last >= 6 && grad_source <= 3) {
            ++x.mbs_zero_last_dot_suppress;
            return true;
        }
        return false;
    }

    static boolean check_dot_artifact_candidate(Compressor cpi, Macroblock x, ReadOnlyIntArrPointer target_last, int stride, ReadOnlyIntArrPointer last_ref, int mb_row, int mb_col, int channel) {
        int max_num = cpi.common.MBs / 10;
        int index = mb_row * cpi.common.mb_cols + mb_col;
        int num_frames = 30;
        int shift = 15;
        if (channel > 0) {
            shift = 7;
        }
        if (cpi.oxcf.number_of_layers > 1) {
            num_frames = 20;
        }
        x.zero_last_dot_suppress = false;
        if (cpi.current_layer == 0 && cpi.consec_zero_last_mvbias[index] > num_frames && x.mbs_zero_last_dot_suppress < max_num && cpi.oxcf.screen_content_mode == 0) {
            x.zero_last_dot_suppress = true;
            return PickInter.dotArtifactHelper(x, target_last, stride, last_ref, 0, 0, 1, 1) || PickInter.dotArtifactHelper(x, target_last, stride, last_ref, 0, shift, 1, -1) || PickInter.dotArtifactHelper(x, target_last, stride, last_ref, shift, 0, -1, 1) || PickInter.dotArtifactHelper(x, target_last, stride, last_ref, shift, shift, -1, -1);
        }
        return false;
    }

    private static int updLocalMC(ModeInfo mi, int local_motion_check) {
        if (mi.mbmi.ref_frame != MVReferenceFrame.INTRA_FRAME) {
            MV r = mi.mbmi.mv;
            if (Math.abs(r.row) < 8 && Math.abs(r.col) < 8) {
                ++local_motion_check;
            }
        }
        return local_motion_check;
    }

    static int calculate_zeromv_rd_adjustment(Compressor cpi, Macroblock x, int rd_adjustment) {
        FullAccessGenArrPointer<ModeInfo> mic = new FullAccessGenArrPointer<ModeInfo>(x.e_mbd.mode_info_context);
        int local_motion_check = 0;
        if (cpi.lf_zeromv_pct > 40) {
            mic.dec();
            local_motion_check = PickInter.updLocalMC(mic.get(), local_motion_check);
            mic.incBy(-x.e_mbd.mode_info_stride);
            local_motion_check = PickInter.updLocalMC(mic.get(), local_motion_check);
            mic.inc();
            local_motion_check = PickInter.updLocalMC(mic.get(), local_motion_check);
            if ((x.e_mbd.mb_to_top_edge == 0 || x.e_mbd.mb_to_left_edge == 0) && local_motion_check > 0 || local_motion_check > 2) {
                return 80;
            }
            if (local_motion_check > 0) {
                return 90;
            }
        }
        return rd_adjustment;
    }

    static void vp8_get_inter_mbpred_error(Macroblock mb, VarianceFNs vfp, VarianceResults ret, MV this_mv) {
        Block b = mb.block.get();
        BlockD d = mb.e_mbd.block.get();
        FullAccessIntArrPointer what = b.getSrcPtr();
        int what_stride = b.src_stride;
        int pre_stride = mb.e_mbd.pre.y_stride;
        FullAccessIntArrPointer in_what = d.getOffsetPointer(mb.e_mbd.pre.y_buffer).shallowCopyWithPosInc((this_mv.row >> 3) * pre_stride + (this_mv.col >> 3));
        int xoffset = this_mv.col & 7;
        int yoffset = this_mv.row & 7;
        if ((xoffset | yoffset) != 0) {
            vfp.svf.call(in_what, pre_stride, xoffset, yoffset, what, what_stride, ret);
        } else {
            vfp.vf.call(what, what_stride, in_what, pre_stride, ret);
        }
    }

    static void check_for_encode_breakout(VarianceResults vr, Compressor cpi) {
        Macroblock x = cpi.mb;
        MacroblockD xd = x.e_mbd;
        int threshold = Math.max(x.encode_breakout, xd.block.get().dequant.getRel(1) * xd.block.get().dequant.getRel(1) >> 4);
        if (vr.sse < threshold) {
            x.skip = RDOpt.VP8_UVSSE(cpi) << 1 < x.encode_breakout;
        }
    }

    static long evaluate_inter_mode(VarianceResults ret, int rate2, Compressor cpi, Macroblock x, int rd_adj) {
        ModeInfo currentMI = x.e_mbd.mode_info_context.get();
        MBPredictionMode this_mode = currentMI.mbmi.mode;
        MV mv = currentMI.mbmi.mv;
        if (cpi.repeatFrameDetected || cpi.active_map_enabled && x.active_ptr.get() == 0) {
            ret.variance = 0L;
            ret.sse = 0;
            x.skip = true;
            return Integer.MAX_VALUE;
        }
        if (this_mode != MBPredictionMode.NEWMV || !cpi.sf.half_pixel_search || cpi.common.full_pixel) {
            PickInter.vp8_get_inter_mbpred_error(x, cpi.fn_ptr.get((Object)BlockEnum.BLOCK_16X16), ret, mv);
        }
        long this_rd = RDOpt.RDCOST(x.rdmult, x.rddiv, rate2, ret.variance);
        if (cpi.oxcf.screen_content_mode == 0 && this_mode == MBPredictionMode.ZEROMV && currentMI.mbmi.ref_frame == MVReferenceFrame.LAST_FRAME && cpi.closest_reference_frame == MVReferenceFrame.LAST_FRAME) {
            if (x.is_skin) {
                rd_adj = 100;
            }
            this_rd = (int)(this_rd * (long)rd_adj / 100L);
        }
        PickInter.check_for_encode_breakout(ret, cpi);
        return this_rd;
    }

    /*
     * Enabled aggressive block sorting
     */
    void pickInterMode(Compressor cpi, Macroblock x, int recon_yoffset, int recon_uvoffset, PickInfoReturn ret, int mb_row, int mb_col) {
        Block b = x.block.get();
        MacroblockD xd = x.e_mbd;
        BlockD d = xd.block.get();
        MBModeInfo best_mbmode = new MBModeInfo();
        ModeInfo currentMI = x.e_mbd.mode_info_context.get();
        this.reset();
        long best_rd = Long.MAX_VALUE;
        int rd_adjustment = 100;
        long best_intra_rd = Long.MAX_VALUE;
        QualityMetrics currRde = new QualityMetrics();
        VarianceResults varRes = new VarianceResults();
        long bestsme = Long.MAX_VALUE;
        int best_mode_index = 0;
        varRes.sse = Integer.MAX_VALUE;
        int best_rd_sse = Integer.MAX_VALUE;
        boolean sf_improved_mv_pred = cpi.sf.improved_mv_pred;
        boolean saddone = false;
        int sr = 0;
        FullAccessIntArrPointer[][] plane = new FullAccessIntArrPointer[4][3];
        MVReferenceFrame[] ref_frame_map = new MVReferenceFrame[4];
        int sign_bias = 0;
        boolean dot_artifact_candidate = false;
        RDOpt.get_predictor_pointers(cpi, plane, recon_yoffset, recon_uvoffset);
        if (cpi.ref_frame_flags.contains((Object)MVReferenceFrame.LAST_FRAME)) {
            FullAccessIntArrPointer target_y = x.src.y_buffer;
            FullAccessIntArrPointer target_u = x.block.getRel(16).getSrcPtr();
            FullAccessIntArrPointer target_v = x.block.getRel(20).getSrcPtr();
            int stride = x.src.y_stride;
            int stride_uv = x.block.getRel((int)16).src_stride;
            assert (plane[MVReferenceFrame.LAST_FRAME.ordinal()][0] != null);
            dot_artifact_candidate = PickInter.check_dot_artifact_candidate(cpi, x, target_y, stride, plane[MVReferenceFrame.LAST_FRAME.ordinal()][0], mb_row, mb_col, 0);
            if (!dot_artifact_candidate) {
                assert (plane[MVReferenceFrame.LAST_FRAME.ordinal()][1] != null);
                dot_artifact_candidate = PickInter.check_dot_artifact_candidate(cpi, x, target_u, stride_uv, plane[MVReferenceFrame.LAST_FRAME.ordinal()][1], mb_row, mb_col, 1);
                if (!dot_artifact_candidate) {
                    assert (plane[MVReferenceFrame.LAST_FRAME.ordinal()][2] != null);
                    dot_artifact_candidate = PickInter.check_dot_artifact_candidate(cpi, x, target_v, stride_uv, plane[MVReferenceFrame.LAST_FRAME.ordinal()][2], mb_row, mb_col, 2);
                }
            }
        }
        x.is_skin = false;
        if (cpi.oxcf.screen_content_mode == 0) {
            int block_index = mb_row * cpi.common.mb_cols + mb_col;
            x.is_skin = cpi.skin_map[block_index];
        }
        this.mode_mv = this.mode_mv_sb[sign_bias];
        RDOpt.get_reference_search_order(cpi, ref_frame_map);
        if (ref_frame_map[1] != null) {
            sign_bias = FindNearMV.vp8_find_near_mvs_bias(x.e_mbd, x.e_mbd.mode_info_context, this.mode_mv_sb, this.best_ref_mv_sb, this.mdCounts, ref_frame_map[1], cpi.common.ref_frame_sign_bias) ? 1 : 0;
            this.mode_mv = this.mode_mv_sb[sign_bias];
            this.best_ref_mv.set(this.best_ref_mv_sb[sign_bias]);
        }
        ++x.mbs_tested_so_far;
        ret.intra = Integer.MAX_VALUE;
        x.skip = false;
        currentMI.mbmi.ref_frame = MVReferenceFrame.INTRA_FRAME;
        if (cpi.Speed < 12) {
            rd_adjustment = PickInter.calculate_zeromv_rd_adjustment(cpi, x, rd_adjustment);
        }
        if (dot_artifact_candidate) {
            rd_adjustment = 150;
        }
        block8: for (int mode_index = 0; mode_index < 20; ++mode_index) {
            MBPredictionMode this_mode;
            long this_rd = Long.MAX_VALUE;
            MVReferenceFrame this_ref_frame = ref_frame_map[RDOpt.vp8_ref_frame_order[mode_index]];
            if (best_rd <= (long)x.rd_threshes[mode_index] || this_ref_frame == null) continue;
            currentMI.mbmi.ref_frame = this_ref_frame;
            if (currentMI.mbmi.ref_frame != MVReferenceFrame.INTRA_FRAME) {
                x.e_mbd.pre.y_buffer = plane[this_ref_frame.ordinal()][0];
                x.e_mbd.pre.u_buffer = plane[this_ref_frame.ordinal()][1];
                x.e_mbd.pre.v_buffer = plane[this_ref_frame.ordinal()][2];
                if (sign_bias != 0 != cpi.common.ref_frame_sign_bias.get((Object)this_ref_frame)) {
                    sign_bias = cpi.common.ref_frame_sign_bias.get((Object)this_ref_frame) != false ? 1 : 0;
                    this.mode_mv = this.mode_mv_sb[sign_bias];
                    this.best_ref_mv.set(this.best_ref_mv_sb[sign_bias]);
                }
            }
            if (x.mode_test_hit_counts[mode_index] != 0 && cpi.mode_check_freq[mode_index] > 1 && x.mbs_tested_so_far <= cpi.mode_check_freq[mode_index] * x.mode_test_hit_counts[mode_index]) {
                int n = mode_index;
                x.rd_thresh_mult[n] = x.rd_thresh_mult[n] + 4;
                if (x.rd_thresh_mult[mode_index] > 512) {
                    x.rd_thresh_mult[mode_index] = 512;
                }
                x.rd_threshes[mode_index] = (cpi.rd_baseline_thresh[mode_index] >> 7) * x.rd_thresh_mult[mode_index];
                continue;
            }
            int n = mode_index;
            x.mode_test_hit_counts[n] = x.mode_test_hit_counts[n] + 1;
            int rate2 = 0;
            varRes.variance = 0L;
            currentMI.mbmi.mode = this_mode = RDOpt.vp8_mode_order[mode_index];
            currentMI.mbmi.uv_mode = MBPredictionMode.DC_PRED;
            int frame_cost = x.ref_frame_cost[currentMI.mbmi.ref_frame.ordinal()];
            rate2 += frame_cost;
            if (cpi.is_src_frame_alt_ref && cpi.oxcf.arnr_max_frames == 0 && (this_mode != MBPredictionMode.ZEROMV || currentMI.mbmi.ref_frame != MVReferenceFrame.ALTREF_FRAME)) continue;
            switch (this_mode) {
                case B_PRED: {
                    varRes.variance = best_rd_sse;
                    PickInter.pick_intra4x4mby_modes(x, currRde);
                    if (currRde.distortion == Integer.MAX_VALUE) {
                        this_rd = Integer.MAX_VALUE;
                        break;
                    }
                    Variance.variance(b.base_src, b.src_stride, x.e_mbd.predictor, 16, varRes, 16, 16);
                    this_rd = RDOpt.RDCOST(x.rdmult, x.rddiv, rate2 += currRde.rateBase, varRes.variance);
                    if (this_rd >= best_intra_rd) break;
                    best_intra_rd = this_rd;
                    ret.intra = varRes.variance;
                    break;
                }
                case SPLITMV: {
                    break;
                }
                case DC_PRED: 
                case V_PRED: 
                case H_PRED: 
                case TM_PRED: {
                    x.recon.vp8_build_intra_predictors_mby_s(xd, xd.dst.y_buffer.shallowCopyWithPosInc(-xd.dst.y_stride), xd.dst.y_buffer.shallowCopyWithPosInc(-1), xd.dst.y_stride, xd.predictor, 16);
                    Variance.variance(b.base_src, b.src_stride, x.e_mbd.predictor, 16, varRes, 16, 16);
                    this_rd = RDOpt.RDCOST(x.rdmult, x.rddiv, rate2 += x.mbmode_cost.get((Object)x.e_mbd.frame_type).get((Object)currentMI.mbmi.mode).intValue(), varRes.variance);
                    if (this_rd >= best_intra_rd) break;
                    best_intra_rd = this_rd;
                    ret.intra = varRes.variance;
                    break;
                }
                case NEWMV: {
                    int further_steps;
                    int n2 = 0;
                    int sadpb = x.sadperbit16;
                    MV mvp_full = new MV();
                    short col_min = (short)((this.best_ref_mv.col + 7 >> 3) - MComp.MAX_FULL_PEL_VAL);
                    short row_min = (short)((this.best_ref_mv.row + 7 >> 3) - MComp.MAX_FULL_PEL_VAL);
                    short col_max = (short)((this.best_ref_mv.col >> 3) + MComp.MAX_FULL_PEL_VAL);
                    short row_max = (short)((this.best_ref_mv.row >> 3) + MComp.MAX_FULL_PEL_VAL);
                    short tmp_col_min = x.mv_col_min;
                    short tmp_col_max = x.mv_col_max;
                    short tmp_row_min = x.mv_row_min;
                    short tmp_row_max = x.mv_row_max;
                    int speed_adjust = cpi.Speed > 5 ? (cpi.Speed >= 8 ? 3 : 2) : 1;
                    int step_param = cpi.sf.first_step + speed_adjust;
                    if (sf_improved_mv_pred) {
                        if (!saddone) {
                            RDOpt.vp8_cal_sad(cpi, xd, x, recon_yoffset, this.nearsad);
                            saddone = true;
                        }
                        sr = RDOpt.vp8_mv_pred(cpi, x.e_mbd, x.e_mbd.mode_info_context, this.mvp, currentMI.mbmi.ref_frame, cpi.common.ref_frame_sign_bias, sr, this.nearsad);
                        if ((sr += speed_adjust) > step_param) {
                            step_param = sr;
                        }
                        mvp_full.set(this.mvp.div8());
                    } else {
                        this.mvp.set(this.best_ref_mv);
                        mvp_full.set(this.mvp.div8());
                    }
                    if (x.mv_col_min < col_min) {
                        x.mv_col_min = col_min;
                    }
                    if (x.mv_col_max > col_max) {
                        x.mv_col_max = col_max;
                    }
                    if (x.mv_row_min < row_min) {
                        x.mv_row_min = row_min;
                    }
                    if (x.mv_row_max > row_max) {
                        x.mv_row_max = row_max;
                    }
                    int n3 = further_steps = cpi.Speed >= 8 ? 0 : cpi.sf.max_step_search_steps - 1 - step_param;
                    if (cpi.sf.search_method == SearchMethods.HEX) {
                        bestsme = x.hex.apply(x, true, cpi.fn_ptr.get((Object)BlockEnum.BLOCK_16X16), mvp_full, this.best_ref_mv, d.bmi.mv);
                        this.mode_mv[MBPredictionMode.NEWMV.ordinal()].set(d.bmi.mv);
                    } else {
                        VarWithNum varAndNum = new VarWithNum();
                        cpi.diamond_search_sad.call(x, b, d, mvp_full, d.bmi.mv, step_param, sadpb, varAndNum, cpi.fn_ptr.get((Object)BlockEnum.BLOCK_16X16), x.mvcost, this.best_ref_mv);
                        bestsme = varAndNum.var;
                        this.mode_mv[MBPredictionMode.NEWMV.ordinal()].set(d.bmi.mv);
                        varAndNum.num00 = 0;
                        for (n2 = varAndNum.num00; n2 < further_steps; ++n2) {
                            if (varAndNum.num00 != 0) {
                                --varAndNum.num00;
                                continue;
                            }
                            cpi.diamond_search_sad.call(x, b, d, mvp_full, d.bmi.mv, step_param + n2, sadpb, varAndNum, cpi.fn_ptr.get((Object)BlockEnum.BLOCK_16X16), x.mvcost, this.best_ref_mv);
                            long thissme = varAndNum.var;
                            if (thissme < bestsme) {
                                bestsme = thissme;
                                this.mode_mv[MBPredictionMode.NEWMV.ordinal()].set(d.bmi.mv);
                                continue;
                            }
                            d.bmi.mv.set(this.mode_mv[MBPredictionMode.NEWMV.ordinal()]);
                        }
                    }
                    x.mv_col_min = tmp_col_min;
                    x.mv_col_max = tmp_col_max;
                    x.mv_row_min = tmp_row_min;
                    x.mv_row_max = tmp_row_max;
                    if (bestsme < Integer.MAX_VALUE) {
                        cpi.find_fractional_mv_step.call(x, b, d, d.bmi.mv, this.best_ref_mv, x.errorperbit, cpi.fn_ptr.get((Object)BlockEnum.BLOCK_16X16), cpi.mb.mvcost, varRes);
                    }
                    this.mode_mv[MBPredictionMode.NEWMV.ordinal()].set(d.bmi.mv);
                    FindNearMV.vp8_clamp_mv2(this.mode_mv[this_mode.ordinal()], xd);
                    rate2 += MComp.vp8_mv_bit_cost(this.mode_mv[MBPredictionMode.NEWMV.ordinal()], this.best_ref_mv, cpi.mb.mvcost, 128);
                }
                case NEARESTMV: 
                case NEARMV: {
                    if (this.mode_mv[this_mode.ordinal()].isZero()) continue block8;
                }
                case ZEROMV: {
                    MV tmpmvzmv = this.mode_mv[this_mode.ordinal()];
                    if (tmpmvzmv.row >> 3 < x.mv_row_min || tmpmvzmv.row >> 3 > x.mv_row_max || tmpmvzmv.col >> 3 < x.mv_col_min || tmpmvzmv.col >> 3 > x.mv_col_max) continue block8;
                    currentMI.mbmi.mv.set(this.mode_mv[this_mode.ordinal()]);
                    this_rd = PickInter.evaluate_inter_mode(varRes, rate2 += RDOpt.vp8_cost_mv_ref(this_mode, this.mdCounts), cpi, x, rd_adjustment);
                }
            }
            if (this_rd < best_rd || x.skip) {
                best_mode_index = mode_index;
                ret.rate = rate2;
                ret.distortion = varRes.variance;
                best_rd_sse = varRes.sse;
                best_rd = this_rd;
                best_mbmode.copyIn(currentMI.mbmi);
                x.rd_thresh_mult[mode_index] = x.rd_thresh_mult[mode_index] >= 34 ? x.rd_thresh_mult[mode_index] - 2 : 32;
                x.rd_threshes[mode_index] = (cpi.rd_baseline_thresh[mode_index] >> 7) * x.rd_thresh_mult[mode_index];
            } else {
                int n4 = mode_index;
                x.rd_thresh_mult[n4] = x.rd_thresh_mult[n4] + 4;
                if (x.rd_thresh_mult[mode_index] > 512) {
                    x.rd_thresh_mult[mode_index] = 512;
                }
                x.rd_threshes[mode_index] = (cpi.rd_baseline_thresh[mode_index] >> 7) * x.rd_thresh_mult[mode_index];
            }
            if (x.skip) break;
        }
        RDOpt.reduceActivationThreshold(cpi, best_mode_index);
        long this_rdbin = ret.distortion >> 7;
        if (this_rdbin >= 1024L) {
            this_rdbin = 1023L;
        }
        int n = (int)this_rdbin;
        x.error_bins[n] = x.error_bins[n] + 1;
        if (RDOpt.adjustToZeroMVForAltref(cpi, best_mbmode)) {
            return;
        }
        if (!x.skip) {
            currentMI.mbmi.copyIn(best_mbmode);
        }
        if (MBPredictionMode.basicModes.contains((Object)best_mbmode.mode)) {
            this.pick_intra_mbuv_mode(x);
        }
        if (sign_bias != 0 != cpi.common.ref_frame_sign_bias.get((Object)currentMI.mbmi.ref_frame)) {
            this.best_ref_mv.set(this.best_ref_mv_sb[sign_bias != 0 ? 0 : 1]);
        }
        PickInter.update_mvcount(x, this.best_ref_mv);
    }

    public long vp8_pick_intra_mode(Macroblock x) {
        long error16x16 = Long.MAX_VALUE;
        QualityMetrics curr = new QualityMetrics();
        curr.distortion = Long.MAX_VALUE;
        long best_rate = 0L;
        MBPredictionMode best_mode = MBPredictionMode.DC_PRED;
        Block b = x.block.get();
        MacroblockD xd = x.e_mbd;
        VarianceResults varRes = new VarianceResults();
        MBModeInfo mbmi = xd.mode_info_context.get().mbmi;
        mbmi.ref_frame = MVReferenceFrame.INTRA_FRAME;
        this.pick_intra_mbuv_mode(x);
        FullAccessIntArrPointer yabove = xd.dst.y_buffer.shallowCopyWithPosInc(-xd.dst.y_stride);
        FullAccessIntArrPointer yleft = xd.dst.y_buffer.shallowCopyWithPosInc(-1);
        Iterator iterator = MBPredictionMode.nonBlockPred.iterator();
        while (iterator.hasNext()) {
            MBPredictionMode mode;
            mbmi.mode = mode = (MBPredictionMode)((Object)iterator.next());
            x.recon.vp8_build_intra_predictors_mby_s(xd, yabove, yleft, xd.dst.y_stride, xd.predictor, 16);
            Variance.variance(b.base_src, b.src_stride, xd.predictor, 16, varRes, 16, 16);
            curr.rateBase = x.mbmode_cost.get((Object)xd.frame_type).get((Object)mode);
            long this_rd = RDOpt.RDCOST(x.rdmult, x.rddiv, curr.rateBase, varRes.variance);
            if (error16x16 <= this_rd) continue;
            error16x16 = this_rd;
            best_mode = mode;
            curr.distortion = varRes.sse;
            best_rate = curr.rateBase;
        }
        mbmi.mode = best_mode;
        PickInter.pick_intra4x4mby_modes(x, curr);
        if (curr.error < error16x16) {
            mbmi.mode = MBPredictionMode.B_PRED;
            best_rate = curr.rateBase;
        }
        return best_rate;
    }
}

