/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.VP8Util;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.VPXConst;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.EncodeMB;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.FindNearMV;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.IDCTllm;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.MComp;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.OnyxIf;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.PickInter;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.Quantize;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.ReconInter;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.ReconIntra;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.TreeWriter;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.Variance;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.BestMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.BestSegInfo;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Block;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.BlockD;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.CommonData;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Compressor;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.DCTValueConstants;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Entropy;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.EntropyContextPlanes;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.EntropyMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.FrameContext;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.MBModeInfo;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.MV;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Macroblock;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.MacroblockD;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.ModeInfo;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Partition_Info;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.PickInfoReturn;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.QualityMetrics;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.QuantCommon;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Token;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.VarWithNum;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.VarianceFNs;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.VarianceResults;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.YV12buffer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.BPredictionMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.BlockEnum;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.FrameType;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MBPredictionMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MVReferenceFrame;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.PlaneType;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.ThrModes;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.TokenAlphabet;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessGenArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.ReadOnlyIntArrPointer;

public class RDOpt {
    public static final int[] vp8_ref_frame_order = new int[]{1, 0, 1, 1, 2, 2, 3, 3, 2, 3, 0, 0, 0, 1, 2, 3, 1, 2, 3, 0};
    public static MBPredictionMode[] vp8_mode_order = new MBPredictionMode[]{MBPredictionMode.ZEROMV, MBPredictionMode.DC_PRED, MBPredictionMode.NEARESTMV, MBPredictionMode.NEARMV, MBPredictionMode.ZEROMV, MBPredictionMode.NEARESTMV, MBPredictionMode.ZEROMV, MBPredictionMode.NEARESTMV, MBPredictionMode.NEARMV, MBPredictionMode.NEARMV, MBPredictionMode.V_PRED, MBPredictionMode.H_PRED, MBPredictionMode.TM_PRED, MBPredictionMode.NEWMV, MBPredictionMode.NEWMV, MBPredictionMode.NEWMV, MBPredictionMode.SPLITMV, MBPredictionMode.SPLITMV, MBPredictionMode.SPLITMV, MBPredictionMode.B_PRED};
    static final int[] segmentation_to_sseshift = new int[]{3, 3, 2, 0};
    static final int[] auto_speed_thresh = new int[]{1000, 200, 150, 130, 150, 125, 120, 115, 115, 115, 115, 115, 115, 115, 115, 115, 105};
    static final int[] rd_iifactor = new int[]{4, 4, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    static long RDCOST(int RM, int DM, int R, long D) {
        return (long)(128 + R * RM >> 8) + (long)DM * D;
    }

    static void get_plane_pointers(YV12buffer fb, FullAccessIntArrPointer[] plane, int recon_yoffset, int recon_uvoffset) {
        plane[0] = fb.y_buffer.shallowCopyWithPosInc(recon_yoffset);
        plane[1] = fb.u_buffer.shallowCopyWithPosInc(recon_uvoffset);
        plane[2] = fb.v_buffer.shallowCopyWithPosInc(recon_uvoffset);
    }

    static void get_predictor_pointers(Compressor cpi, FullAccessIntArrPointer[][] plane, int recon_yoffset, int recon_uvoffset) {
        for (MVReferenceFrame rf : MVReferenceFrame.interFrames) {
            if (!cpi.ref_frame_flags.contains((Object)rf)) continue;
            RDOpt.get_plane_pointers(cpi.common.yv12_fb[cpi.common.frameIdxs.get((Object)rf)], plane[rf.ordinal()], recon_yoffset, recon_uvoffset);
        }
    }

    static void get_reference_search_order(Compressor cpi, MVReferenceFrame[] ref_frame_map) {
        int i = 0;
        for (MVReferenceFrame rf : MVReferenceFrame.values()) {
            if (!MVReferenceFrame.validFrames.contains((Object)rf) || !cpi.ref_frame_flags.contains((Object)rf) && !MVReferenceFrame.INTRA_FRAME.equals((Object)rf)) continue;
            ref_frame_map[i++] = rf;
        }
        while (i < 4) {
            ref_frame_map[i] = null;
            ++i;
        }
    }

    static int rd_cost_mbuv(Macroblock mb) {
        int cost = 0;
        MacroblockD x = mb.e_mbd;
        EntropyContextPlanes t_above = new EntropyContextPlanes(x.above_context.get());
        EntropyContextPlanes t_left = new EntropyContextPlanes(x.left_context);
        for (int b = 16; b < 24; ++b) {
            cost += RDOpt.cost_coeffs(mb, x.block.getRel(b), PlaneType.UV, t_above.panes.shallowCopyWithPosInc(BlockD.vp8_block2above[b]), t_left.panes.shallowCopyWithPosInc(BlockD.vp8_block2left[b]));
        }
        return cost;
    }

    static int vp8_rdcost_mby(Macroblock mb) {
        int cost = 0;
        MacroblockD x = mb.e_mbd;
        EntropyContextPlanes t_above = new EntropyContextPlanes(mb.e_mbd.above_context.get());
        EntropyContextPlanes t_left = new EntropyContextPlanes(mb.e_mbd.left_context);
        for (int b = 0; b < 16; ++b) {
            cost += RDOpt.cost_coeffs(mb, x.block.getRel(b), PlaneType.Y_NO_DC, t_above.panes.shallowCopyWithPosInc(BlockD.vp8_block2above[b]), t_left.panes.shallowCopyWithPosInc(BlockD.vp8_block2left[b]));
        }
        return cost += RDOpt.cost_coeffs(mb, x.block.getRel(24), PlaneType.Y2, t_above.panes.shallowCopyWithPosInc(BlockD.vp8_block2above[24]), t_left.panes.shallowCopyWithPosInc(BlockD.vp8_block2left[24]));
    }

    static int cost_coeffs(Macroblock mb, BlockD b, PlaneType type, FullAccessIntArrPointer a, FullAccessIntArrPointer l) {
        int c;
        int corig = c = type.start_coeff;
        short eob = b.eob.get();
        int cost = 0;
        FullAccessIntArrPointer qcoeff_ptr = b.qcoeff;
        short pt = (short)(a.get() + l.get());
        assert (eob <= 16);
        while (c < eob) {
            short v = qcoeff_ptr.getRel(VPXConst.zigzag[c]);
            TokenAlphabet t = DCTValueConstants.getTokenValue((int)v).token;
            cost += mb.token_costs[type.ordinal()][VP8Util.SubblockConstants.vp8CoefBands[c]][pt][t.ordinal()];
            cost += DCTValueConstants.getValueCost(v);
            pt = t.previousTokenClass;
            ++c;
        }
        if (c < 16) {
            cost += mb.token_costs[type.ordinal()][VP8Util.SubblockConstants.vp8CoefBands[c]][pt][TokenAlphabet.DCT_EOB_TOKEN.ordinal()];
        }
        pt = (short)(c != corig ? 1 : 0);
        a.set(l.set(pt));
        return cost;
    }

    static int vp8_block_error(ReadOnlyIntArrPointer coeff, ReadOnlyIntArrPointer dqcoeff) {
        int error = 0;
        for (int i = 0; i < 16; ++i) {
            int this_diff = coeff.getRel(i) - dqcoeff.getRel(i);
            error += this_diff * this_diff;
        }
        return error;
    }

    static int vp8_mbuverror(Macroblock mb) {
        int error = 0;
        for (int i = 16; i < 24; ++i) {
            Block be = mb.block.getRel(i);
            BlockD bd = mb.e_mbd.block.getRel(i);
            error += RDOpt.vp8_block_error(be.coeff, bd.dqcoeff);
        }
        return error;
    }

    static int labels2mode(Macroblock x, int[] labelings, int which_label, BPredictionMode this_mode, MV this_mv, MV best_ref_mv, ReadOnlyIntArrPointer[] mvcost) {
        MacroblockD xd = x.e_mbd;
        FullAccessGenArrPointer<ModeInfo> mic = xd.mode_info_context;
        int mis = xd.mode_info_stride;
        int cost = 0;
        int thismvcost = 0;
        int i = 0;
        do {
            BPredictionMode m;
            int row = i >> 2;
            int col = i & 3;
            if (labelings[i] != which_label) continue;
            if (col != 0 && labelings[i] == labelings[i - 1]) {
                m = BPredictionMode.LEFT4X4;
            } else if (row != 0 && labelings[i] == labelings[i - 4]) {
                m = BPredictionMode.ABOVE4X4;
            } else {
                MV left_mv;
                m = this_mode;
                switch (m) {
                    case NEW4X4: {
                        thismvcost = MComp.vp8_mv_bit_cost(this_mv, best_ref_mv, mvcost, 102);
                        break;
                    }
                    case LEFT4X4: {
                        this_mv.set(col != 0 ? xd.block.getRel((int)(i - 1)).bmi.mv : FindNearMV.left_block_mv(mic, i));
                        break;
                    }
                    case ABOVE4X4: {
                        this_mv.set(row != 0 ? xd.block.getRel((int)(i - 4)).bmi.mv : FindNearMV.above_block_mv(mic, i, mis));
                        break;
                    }
                    case ZERO4X4: {
                        this_mv.setZero();
                        break;
                    }
                }
                if (m == BPredictionMode.ABOVE4X4 && (left_mv = new MV(col != 0 ? xd.block.getRel((int)(i - 1)).bmi.mv : FindNearMV.left_block_mv(mic, i))).equals(this_mv)) {
                    m = BPredictionMode.LEFT4X4;
                }
                cost = x.inter_bmode_costs.get((Object)m);
            }
            xd.block.getRel((int)i).bmi.mv.set(this_mv);
            x.partition_info.get().bmi[i].mode = m;
            x.partition_info.get().bmi[i].mv.set(this_mv);
        } while (++i < 16);
        return cost += thismvcost;
    }

    static int rdcost_mbsegment_y(Macroblock mb, int[] labels, int which_label, FullAccessIntArrPointer ta, FullAccessIntArrPointer tl) {
        int cost = 0;
        MacroblockD x = mb.e_mbd;
        for (int b = 0; b < 16; ++b) {
            if (labels[b] != which_label) continue;
            cost += RDOpt.cost_coeffs(mb, x.block.getRel(b), PlaneType.Y_WITH_DC, ta.shallowCopyWithPosInc(BlockD.vp8_block2above[b]), tl.shallowCopyWithPosInc(BlockD.vp8_block2left[b]));
        }
        return cost;
    }

    static int vp8_encode_inter_mb_segment(Macroblock x, int[] labels, int which_label) {
        int distortion = 0;
        int pre_stride = x.e_mbd.pre.y_stride;
        FullAccessIntArrPointer base_pre = x.e_mbd.pre.y_buffer.shallowCopy();
        for (int i = 0; i < 16; ++i) {
            if (labels[i] != which_label) continue;
            BlockD bd = x.e_mbd.block.getRel(i);
            Block be = x.block.getRel(i);
            ReconInter.vp8_build_inter_predictors_b(bd, 16, base_pre, pre_stride, x.e_mbd.subpixel_predict);
            EncodeMB.vp8_subtract_b(be, bd, 16);
            x.short_fdct4x4.call(be.src_diff, be.coeff, 32);
            x.quantize_b.call(be, bd);
            distortion += RDOpt.vp8_block_error(be.coeff, bd.dqcoeff);
        }
        return distortion;
    }

    static void rd_check_segment(Compressor cpi, Macroblock x, BestSegInfo bsi, BlockEnum segmentation) {
        int i;
        int br = 0;
        int bd = 0;
        int this_segment_rd = 0;
        int rate = 0;
        int sbr = 0;
        int sbd = 0;
        int segmentyrate = 0;
        EntropyContextPlanes t_above = new EntropyContextPlanes(x.e_mbd.above_context.get());
        EntropyContextPlanes t_left = new EntropyContextPlanes(x.e_mbd.left_context);
        EntropyContextPlanes t_above_b = new EntropyContextPlanes();
        EntropyContextPlanes t_left_b = new EntropyContextPlanes();
        br = 0;
        bd = 0;
        VarianceFNs v_fn_ptr = cpi.fn_ptr.get((Object)segmentation);
        int[] labels = EntropyMode.vp8_mbsplits[segmentation.ordinal()];
        int label_count = EntropyMode.vp8_mbsplit_count[segmentation.ordinal()];
        int label_mv_thresh = 1 * bsi.mvthresh / label_count;
        rate = TreeWriter.vp8_cost_token(EntropyMode.vp8_mbsplit_tree, EntropyMode.vp8_mbsplit_probs, Token.vp8_mbsplit_encodings[segmentation.ordinal()]);
        this_segment_rd = (int)((long)this_segment_rd + RDOpt.RDCOST(x.rdmult, x.rddiv, rate += RDOpt.vp8_cost_mv_ref(MBPredictionMode.SPLITMV, bsi.mdcounts), 0L));
        br += rate;
        for (i = 0; i < label_count; ++i) {
            MV[] mode_mv = new MV[BPredictionMode.bpredModecount];
            for (int j = 0; j < mode_mv.length; ++j) {
                mode_mv[j] = new MV();
            }
            long best_label_rd = Long.MAX_VALUE;
            BPredictionMode mode_selected = BPredictionMode.ZERO4X4;
            int bestlabelyrate = 0;
            for (BPredictionMode this_mode : BPredictionMode.fourfour) {
                EntropyContextPlanes t_above_s = new EntropyContextPlanes(t_above);
                EntropyContextPlanes t_left_s = new EntropyContextPlanes(t_left);
                FullAccessIntArrPointer ta_s = t_above_s.panes.shallowCopy();
                FullAccessIntArrPointer tl_s = t_left_s.panes.shallowCopy();
                if (this_mode == BPredictionMode.NEW4X4) {
                    long thissme;
                    int step_param = 0;
                    long bestsme = Long.MAX_VALUE;
                    MV temp_mv = new MV();
                    if (best_label_rd < (long)label_mv_thresh) break;
                    if (cpi.compressor_speed != 0) {
                        if (segmentation == BlockEnum.BLOCK_8X16 || segmentation == BlockEnum.BLOCK_16X8) {
                            bsi.mvp.set(bsi.sv_mvp[i]);
                            if (i == 1 && segmentation == BlockEnum.BLOCK_16X8) {
                                bsi.mvp.set(bsi.sv_mvp[2]);
                            }
                            step_param = bsi.sv_istep.getRel(i);
                        }
                        if (segmentation == BlockEnum.BLOCK_4X4 && i > 0) {
                            bsi.mvp.set(x.e_mbd.block.getRel((int)(i - 1)).bmi.mv);
                            if (i == 4 || i == 8 || i == 12) {
                                bsi.mvp.set(x.e_mbd.block.getRel((int)(i - 4)).bmi.mv);
                            }
                            step_param = 2;
                        }
                    }
                    int further_steps = MComp.MAX_MVSEARCH_STEPS - 1 - step_param;
                    int sadpb = x.sadperbit4;
                    MV mvp_full = bsi.mvp.div8();
                    int n = FindNearMV.vp8_mbsplit_offset[segmentation.ordinal()][i];
                    Block b = x.block.getRel(n);
                    BlockD d = x.e_mbd.block.getRel(n);
                    VarWithNum varAndNum = new VarWithNum();
                    cpi.diamond_search_sad.call(x, b, d, mvp_full, mode_mv[BPredictionMode.NEW4X4.ordinal()], step_param, sadpb, varAndNum, v_fn_ptr, x.mvcost, bsi.ref_mv);
                    bestsme = varAndNum.var;
                    varAndNum.num00 = 0;
                    for (n = varAndNum.num00; n < further_steps; ++n) {
                        if (varAndNum.num00 != 0) {
                            --varAndNum.num00;
                            continue;
                        }
                        cpi.diamond_search_sad.call(x, b, d, mvp_full, temp_mv, step_param + n, sadpb, varAndNum, v_fn_ptr, x.mvcost, bsi.ref_mv);
                        thissme = varAndNum.var;
                        if (thissme >= bestsme) continue;
                        bestsme = thissme;
                        mode_mv[BPredictionMode.NEW4X4.ordinal()].set(temp_mv);
                    }
                    int sseshift = segmentation_to_sseshift[segmentation.ordinal()];
                    if (cpi.compressor_speed == 0 && bestsme >> sseshift > 4000L) {
                        FindNearMV.vp8_clamp_mv(mvp_full, x.mv_col_min, x.mv_col_max, x.mv_row_min, x.mv_row_max);
                        thissme = cpi.full_search_sad.call(x, b, d, mvp_full, sadpb, 16, v_fn_ptr, x.mvcost, bsi.ref_mv);
                        if (thissme < bestsme) {
                            bestsme = thissme;
                            mode_mv[BPredictionMode.NEW4X4.ordinal()].set(d.bmi.mv);
                        } else {
                            d.bmi.mv.set(mode_mv[BPredictionMode.NEW4X4.ordinal()]);
                        }
                    }
                    if (bestsme < Integer.MAX_VALUE) {
                        VarianceResults res = new VarianceResults();
                        cpi.find_fractional_mv_step.call(x, b, d, mode_mv[BPredictionMode.NEW4X4.ordinal()], bsi.ref_mv, x.errorperbit, v_fn_ptr, x.mvcost, res);
                    }
                }
                rate = RDOpt.labels2mode(x, labels, i, this_mode, mode_mv[this_mode.ordinal()], bsi.ref_mv, x.mvcost);
                if (mode_mv[this_mode.ordinal()].row >> 3 < x.mv_row_min || mode_mv[this_mode.ordinal()].row >> 3 > x.mv_row_max || mode_mv[this_mode.ordinal()].col >> 3 < x.mv_col_min || mode_mv[this_mode.ordinal()].col >> 3 > x.mv_col_max) continue;
                int distortion = RDOpt.vp8_encode_inter_mb_segment(x, labels, i) / 4;
                int labelyrate = RDOpt.rdcost_mbsegment_y(x, labels, i, ta_s, tl_s);
                long this_rd = RDOpt.RDCOST(x.rdmult, x.rddiv, rate += labelyrate, distortion);
                if (this_rd >= best_label_rd) continue;
                sbr = rate;
                sbd = distortion;
                bestlabelyrate = labelyrate;
                mode_selected = this_mode;
                best_label_rd = this_rd;
                t_above.panes.memcopyin(0, t_above_s.panes, 0, t_above.panes.size());
                t_left.panes.memcopyin(0, t_left_s.panes, 0, t_left.panes.size());
            }
            t_above.panes.memcopyin(0, t_above_b.panes, 0, t_above.panes.size());
            t_left.panes.memcopyin(0, t_left_b.panes, 0, t_left.panes.size());
            RDOpt.labels2mode(x, labels, i, mode_selected, mode_mv[mode_selected.ordinal()], bsi.ref_mv, x.mvcost);
            br += sbr;
            bd += sbd;
            segmentyrate += bestlabelyrate;
            this_segment_rd = (int)((long)this_segment_rd + best_label_rd);
            if ((long)this_segment_rd >= bsi.segment_rd) break;
        }
        if ((long)this_segment_rd < bsi.segment_rd) {
            bsi.r = br;
            bsi.d = bd;
            bsi.segment_yrate = segmentyrate;
            bsi.segment_rd = this_segment_rd;
            bsi.segment_num = segmentation;
            for (i = 0; i < 16; ++i) {
                bsi.mvs[i].set(x.partition_info.get().bmi[i].mv);
                bsi.modes[i] = x.partition_info.get().bmi[i].mode;
                bsi.eobs[i] = x.e_mbd.eobs.getRel(i);
            }
        }
    }

    static void vp8_cal_step_param(short sr, FullAccessIntArrPointer sp) {
        int step = 0;
        if (sr > MComp.MAX_FIRST_STEP) {
            sr = MComp.MAX_FIRST_STEP;
        } else if (sr < 1) {
            sr = 1;
        }
        while ((sr = (short)(sr >> 1)) != 0) {
            step = (short)(step + 1);
        }
        sp.set((short)(MComp.MAX_MVSEARCH_STEPS - 1 - step));
    }

    private static short seghelper(Compressor cpi, Macroblock x, BestSegInfo bsi, BlockEnum bekind) {
        int mvp2;
        int mvp1;
        if (bekind == BlockEnum.BLOCK_8X16) {
            mvp1 = 2;
            mvp2 = 1;
        } else {
            mvp1 = 1;
            mvp2 = 2;
        }
        short sr = (short)Math.max(Math.abs(bsi.sv_mvp[0].row - bsi.sv_mvp[mvp1].row) >> 3, Math.abs(bsi.sv_mvp[0].col - bsi.sv_mvp[mvp1].col) >> 3);
        RDOpt.vp8_cal_step_param(sr, bsi.sv_istep);
        bsi.sv_istep.inc();
        sr = (short)Math.max(Math.abs(bsi.sv_mvp[mvp2].row - bsi.sv_mvp[3].row) >> 3, Math.abs(bsi.sv_mvp[mvp2].col - bsi.sv_mvp[3].col) >> 3);
        RDOpt.vp8_cal_step_param(sr, bsi.sv_istep);
        bsi.sv_istep.dec();
        RDOpt.rd_check_segment(cpi, x, bsi, bekind);
        return sr;
    }

    static void vp8_rd_pick_best_mbsegmentation(Compressor cpi, Macroblock x, MV best_ref_mv, long best_rd, int[] mdcounts, QualityMetrics best, int mvthresh) {
        int i;
        BestSegInfo bsi = new BestSegInfo(best_rd, best_ref_mv, mvthresh, mdcounts);
        if (cpi.compressor_speed == 0) {
            for (BlockEnum be : BlockEnum.allBut1616) {
                RDOpt.rd_check_segment(cpi, x, bsi, be);
            }
        } else {
            RDOpt.rd_check_segment(cpi, x, bsi, BlockEnum.BLOCK_8X8);
            if (bsi.segment_rd < best_rd) {
                short col_min = (short)((best_ref_mv.col + 7 >> 3) - MComp.MAX_FULL_PEL_VAL);
                short row_min = (short)((best_ref_mv.row + 7 >> 3) - MComp.MAX_FULL_PEL_VAL);
                short col_max = (short)((best_ref_mv.col >> 3) + MComp.MAX_FULL_PEL_VAL);
                short row_max = (short)((best_ref_mv.row >> 3) + MComp.MAX_FULL_PEL_VAL);
                short tmp_col_min = x.mv_col_min;
                short tmp_col_max = x.mv_col_max;
                short tmp_row_min = x.mv_row_min;
                short tmp_row_max = x.mv_row_max;
                if (x.mv_col_min < col_min) {
                    x.mv_col_min = col_min;
                }
                if (x.mv_col_max > col_max) {
                    x.mv_col_max = col_max;
                }
                if (x.mv_row_min < row_min) {
                    x.mv_row_min = row_min;
                }
                if (x.mv_row_max > row_max) {
                    x.mv_row_max = row_max;
                }
                bsi.sv_mvp[0].set(bsi.mvs[0]);
                bsi.sv_mvp[1].set(bsi.mvs[2]);
                bsi.sv_mvp[2].set(bsi.mvs[8]);
                bsi.sv_mvp[3].set(bsi.mvs[10]);
                short sr = RDOpt.seghelper(cpi, x, bsi, BlockEnum.BLOCK_8X16);
                sr = (short)Math.max(Math.abs(bsi.sv_mvp[0].row - bsi.sv_mvp[2].row) >> 3, Math.abs(bsi.sv_mvp[0].col - bsi.sv_mvp[2].col) >> 3);
                RDOpt.vp8_cal_step_param(sr, bsi.sv_istep);
                sr = (short)Math.max(Math.abs(bsi.sv_mvp[1].row - bsi.sv_mvp[3].row) >> 3, Math.abs(bsi.sv_mvp[1].col - bsi.sv_mvp[3].col) >> 3);
                bsi.sv_istep.inc();
                RDOpt.vp8_cal_step_param(sr, bsi.sv_istep);
                bsi.sv_istep.dec();
                RDOpt.rd_check_segment(cpi, x, bsi, BlockEnum.BLOCK_8X16);
                sr = RDOpt.seghelper(cpi, x, bsi, BlockEnum.BLOCK_16X8);
                if (cpi.sf.no_skip_block4x4_search || bsi.segment_num == BlockEnum.BLOCK_8X8) {
                    bsi.mvp.set(bsi.sv_mvp[0]);
                    RDOpt.rd_check_segment(cpi, x, bsi, BlockEnum.BLOCK_4X4);
                }
                x.mv_col_min = tmp_col_min;
                x.mv_col_max = tmp_col_max;
                x.mv_row_min = tmp_row_min;
                x.mv_row_max = tmp_row_max;
            }
        }
        for (i = 0; i < 16; ++i) {
            BlockD bd = x.e_mbd.block.getRel(i);
            bd.bmi.mv.set(bsi.mvs[i]);
            bd.eob.set(bsi.eobs[i]);
        }
        best.rateBase = bsi.r;
        best.distortion = bsi.d;
        best.rateComp = bsi.segment_yrate;
        x.e_mbd.mode_info_context.get().mbmi.partitioning = bsi.segment_num;
        Partition_Info partInfo = x.partition_info.get();
        partInfo.count = EntropyMode.vp8_mbsplit_count[bsi.segment_num.ordinal()];
        for (i = 0; i < partInfo.count; ++i) {
            int j = FindNearMV.vp8_mbsplit_offset[bsi.segment_num.ordinal()][i];
            partInfo.bmi[i].mode = bsi.modes[j];
            partInfo.bmi[i].mv.set(bsi.mvs[j]);
        }
        partInfo.bmi[15].mv.set(bsi.mvs[15]);
        best.error = bsi.segment_rd;
    }

    static void rd_inter4x4_uv(Compressor cpi, Macroblock x, QualityMetrics best, boolean fullpixel) {
        ReconInter.vp8_build_inter4x4_predictors_mbuv(x.e_mbd);
        EncodeMB.vp8_subtract_mbuv(x.src_diff, x.src.u_buffer, x.src.v_buffer, x.src.uv_stride, x.e_mbd.getFreshUPredPtr(), x.e_mbd.getFreshVPredPtr(), 8);
        EncodeMB.vp8_transform_mbuv(x);
        Quantize.vp8_quantize_mbuv(x);
        best.rateBase = RDOpt.rd_cost_mbuv(x);
        best.distortion = RDOpt.vp8_mbuverror(x) >> 2;
        best.error = RDOpt.RDCOST(x.rdmult, x.rddiv, best.rateBase, best.distortion);
    }

    static void rd_pick_intra_mbuv_mode(Macroblock x, QualityMetrics rd) {
        MBPredictionMode mode_selected = null;
        rd.error = Long.MAX_VALUE;
        MacroblockD xd = x.e_mbd;
        FullAccessIntArrPointer vpred_ptr = xd.getFreshVPredPtr();
        FullAccessIntArrPointer upred_ptr = xd.getFreshUPredPtr();
        FullAccessIntArrPointer uabove = xd.dst.u_buffer.shallowCopyWithPosInc(-xd.dst.uv_stride);
        FullAccessIntArrPointer vabove = xd.dst.v_buffer.shallowCopyWithPosInc(-xd.dst.uv_stride);
        FullAccessIntArrPointer uleft = xd.dst.u_buffer.shallowCopyWithPosInc(-1);
        FullAccessIntArrPointer vleft = xd.dst.v_buffer.shallowCopyWithPosInc(-1);
        ModeInfo mi = xd.mode_info_context.get();
        Iterator iterator = MBPredictionMode.nonBlockPred.iterator();
        while (iterator.hasNext()) {
            int this_distortion;
            MBPredictionMode mode;
            mi.mbmi.uv_mode = mode = (MBPredictionMode)((Object)iterator.next());
            x.recon.vp8_build_intra_predictors_mbuv_s(xd, uabove, vabove, uleft, vleft, xd.dst.uv_stride, upred_ptr, vpred_ptr, 8);
            EncodeMB.vp8_subtract_mbuv(x.src_diff, x.src.u_buffer, x.src.v_buffer, x.src.uv_stride, upred_ptr, vpred_ptr, 8);
            EncodeMB.vp8_transform_mbuv(x);
            Quantize.vp8_quantize_mbuv(x);
            int rate_to = RDOpt.rd_cost_mbuv(x);
            int this_rate = rate_to + x.intra_uv_mode_cost[xd.frame_type.ordinal()][mi.mbmi.uv_mode.ordinal()];
            long this_rd = RDOpt.RDCOST(x.rdmult, x.rddiv, this_rate, this_distortion = RDOpt.vp8_mbuverror(x) / 4);
            if (this_rd >= rd.error) continue;
            rd.error = this_rd;
            rd.distortion = this_distortion;
            rd.rateComp = this_rate;
            rd.rateBase = rate_to;
            mode_selected = mode;
        }
        assert (mode_selected != null);
        mi.mbmi.uv_mode = mode_selected;
    }

    static int vp8_mbblock_error(Macroblock mb, int dc) {
        int error = 0;
        for (int i = 0; i < 16; ++i) {
            Block be = mb.block.getRel(i);
            BlockD bd = mb.e_mbd.block.getRel(i);
            int berror = 0;
            for (int j = dc; j < 16; ++j) {
                int this_diff = be.coeff.getRel(j) - bd.dqcoeff.getRel(j);
                berror += this_diff * this_diff;
            }
            error += berror;
        }
        return error;
    }

    static void macro_block_yrd(Macroblock mb, QualityMetrics best) {
        MacroblockD x = mb.e_mbd;
        Block mb_y2 = mb.block.getRel(24);
        BlockD x_y2 = x.block.getRel(24);
        FullAccessIntArrPointer Y2DCPtr = mb_y2.src_diff.shallowCopy();
        EncodeMB.vp8_subtract_mby(mb.src_diff, mb.block.get().base_src, mb.block.get().src_stride, mb.e_mbd.predictor, 16);
        for (int bi = 0; bi < 16; bi += 2) {
            mb.short_fdct8x4.call(mb.block.getRel((int)bi).src_diff, mb.block.getRel((int)bi).coeff, 32);
            Y2DCPtr.setAndInc(mb.block.getRel((int)bi).coeff.get());
            Y2DCPtr.setAndInc(mb.block.getRel((int)bi).coeff.getRel(16));
        }
        mb.short_walsh4x4.call(mb_y2.src_diff, mb_y2.coeff, 8);
        for (int b = 0; b < 16; ++b) {
            mb.quantize_b.call(mb.block.getRel(b), mb.e_mbd.block.getRel(b));
        }
        mb.quantize_b.call(mb_y2, x_y2);
        int d = RDOpt.vp8_mbblock_error(mb, 1) << 2;
        best.distortion = (d += RDOpt.vp8_block_error(mb_y2.coeff, x_y2.dqcoeff)) >> 4;
        best.rateBase = RDOpt.vp8_rdcost_mby(mb);
    }

    static void rd_pick_intra16x16mby_mode(Macroblock x, QualityMetrics rd) {
        MBPredictionMode mode_selected = null;
        MacroblockD xd = x.e_mbd;
        QualityMetrics curr = new QualityMetrics();
        rd.error = Long.MAX_VALUE;
        ModeInfo mi = xd.mode_info_context.get();
        Iterator iterator = MBPredictionMode.nonBlockPred.iterator();
        while (iterator.hasNext()) {
            MBPredictionMode mode;
            mi.mbmi.mode = mode = (MBPredictionMode)((Object)iterator.next());
            x.recon.vp8_build_intra_predictors_mby_s(xd, xd.dst.y_buffer.shallowCopyWithPosInc(-xd.dst.y_stride), xd.dst.y_buffer.shallowCopyWithPosInc(-1), xd.dst.y_stride, xd.predictor, 16);
            RDOpt.macro_block_yrd(x, curr);
            int temp = curr.rateBase + x.mbmode_cost.get((Object)xd.frame_type).get((Object)mi.mbmi.mode);
            long this_rd = RDOpt.RDCOST(x.rdmult, x.rddiv, temp, curr.distortion);
            if (this_rd >= rd.error) continue;
            mode_selected = mode;
            rd.error = this_rd;
            rd.rateBase = temp;
            rd.rateComp = curr.rateComp;
            rd.distortion = curr.distortion;
        }
        assert (mode_selected != null);
        mi.mbmi.mode = mode_selected;
    }

    static void copy_predictor(FullAccessIntArrPointer dst, ReadOnlyIntArrPointer predictor) {
        for (int i = 0; i < 13; i += 4) {
            dst.setRel(i, predictor.getRel(i));
        }
    }

    static void rd_pick_intra4x4block(Macroblock x, Block be, BlockD b, BPredictionMode[] bestmode, EnumMap<BPredictionMode, Integer> bmode_costs, FullAccessIntArrPointer a, FullAccessIntArrPointer l, QualityMetrics best) {
        int rate = 0;
        best.error = Long.MAX_VALUE;
        FullAccessIntArrPointer ta = a;
        FullAccessIntArrPointer tempa = a;
        FullAccessIntArrPointer tl = l;
        FullAccessIntArrPointer templ = l;
        FullAccessIntArrPointer best_predictor = new FullAccessIntArrPointer(64);
        FullAccessIntArrPointer best_dqcoeff = new FullAccessIntArrPointer(16);
        int dst_stride = x.e_mbd.dst.y_stride;
        FullAccessIntArrPointer dst = b.getOffsetPointer(x.e_mbd.dst.y_buffer);
        FullAccessIntArrPointer Above = dst.shallowCopyWithPosInc(-dst_stride);
        FullAccessIntArrPointer yleft = dst.shallowCopyWithPosInc(-1);
        short top_left = Above.getRel(-1);
        for (BPredictionMode mode : BPredictionMode.bintramodes) {
            int distortion;
            rate = bmode_costs.get((Object)mode);
            x.recon.vp8_intra4x4_predict(Above, yleft, dst_stride, mode, b.predictor, 16, top_left);
            EncodeMB.vp8_subtract_b(be, b, 16);
            x.short_fdct4x4.call(be.src_diff, be.coeff, 32);
            x.quantize_b.call(be, b);
            tempa = ta.shallowCopy();
            int ratey = RDOpt.cost_coeffs(x, b, PlaneType.Y_WITH_DC, tempa, templ = tl.shallowCopy());
            long this_rd = RDOpt.RDCOST(x.rdmult, x.rddiv, rate += ratey, distortion = RDOpt.vp8_block_error(be.coeff, b.dqcoeff) >> 2);
            if (this_rd >= best.error) continue;
            best.rateBase = rate;
            best.rateComp = ratey;
            best.distortion = distortion;
            best.error = this_rd;
            bestmode[0] = mode;
            a.set(tempa.get());
            l.set(templ.get());
            RDOpt.copy_predictor(best_predictor, b.predictor);
            best_dqcoeff.memcopyin(0, b.dqcoeff, 0, 16);
        }
        b.bmi.as_mode(bestmode[0]);
        IDCTllm.vp8_short_idct4x4llm(best_dqcoeff, best_predictor, 16, dst, dst_stride);
    }

    static void rd_pick_intra4x4mby_modes(Macroblock mb, QualityMetrics best) {
        MacroblockD xd = mb.e_mbd;
        int cost = mb.mbmode_cost.get((Object)xd.frame_type).get((Object)MBPredictionMode.B_PRED);
        int distortion = 0;
        int tot_rate_y = 0;
        long total_rd = 0L;
        EntropyContextPlanes t_above = new EntropyContextPlanes(mb.e_mbd.above_context.get());
        EntropyContextPlanes t_left = new EntropyContextPlanes(mb.e_mbd.left_context);
        ReconIntra.intra_prediction_down_copy(xd);
        EnumMap<BPredictionMode, Integer> bmode_costs = mb.inter_bmode_costs;
        QualityMetrics rdTemp = new QualityMetrics();
        ModeInfo mi = xd.mode_info_context.get();
        for (int i = 0; i < 16; ++i) {
            int mis = xd.mode_info_stride;
            BPredictionMode[] best_mode = new BPredictionMode[]{null};
            if (mb.e_mbd.frame_type == FrameType.KEY_FRAME) {
                BPredictionMode A = FindNearMV.above_block_mode(xd.mode_info_context, i, mis);
                BPredictionMode L = FindNearMV.left_block_mode(xd.mode_info_context, i);
                bmode_costs = mb.bmode_costs.get((Object)A).get((Object)L);
            }
            RDOpt.rd_pick_intra4x4block(mb, mb.block.getRel(i), xd.block.getRel(i), best_mode, bmode_costs, t_above.panes.shallowCopyWithPosInc(BlockD.vp8_block2above[i]), t_left.panes.shallowCopyWithPosInc(BlockD.vp8_block2left[i]), rdTemp);
            total_rd += rdTemp.error;
            cost += rdTemp.rateBase;
            distortion = (int)((long)distortion + rdTemp.distortion);
            tot_rate_y += rdTemp.rateComp;
            assert (best_mode[0] != null);
            mi.bmi[i].as_mode(best_mode[0]);
            if (total_rd >= best.error) break;
        }
        if (total_rd >= best.error) {
            best.error = Integer.MAX_VALUE;
            return;
        }
        best.rateBase = cost;
        best.rateComp = tot_rate_y;
        best.distortion = distortion;
        best.error = RDOpt.RDCOST(mb.rdmult, mb.rddiv, cost, distortion);
    }

    /*
     * Enabled aggressive block sorting
     */
    static void vp8_rd_pick_inter_mode(Compressor cpi, Macroblock x, int recon_yoffset, int recon_uvoffset, PickInfoReturn ret, int mb_row, int mb_col) {
        int i;
        Block b = x.block.get();
        BlockD d = x.e_mbd.block.get();
        ModeInfo mi = x.e_mbd.mode_info_context.get();
        MacroblockD xd = x.e_mbd;
        PickInter mvDetails = x.interPicker;
        mvDetails.reset();
        int best_mode_index = 0;
        BestMode best_mode = new BestMode();
        QualityMetrics rdy = new QualityMetrics();
        QualityMetrics rduv = new QualityMetrics();
        QualityMetrics rduvComplete = new QualityMetrics();
        int uv_intra_tteob = 0;
        boolean uv_intra_done = false;
        MBPredictionMode uv_intra_mode = MBPredictionMode.DC_PRED;
        boolean saddone = false;
        int sr = 0;
        FullAccessIntArrPointer[][] plane = new FullAccessIntArrPointer[4][3];
        MVReferenceFrame[] ref_frame_map = new MVReferenceFrame[4];
        boolean sign_bias = false;
        int intra_rd_penalty = 10 * QuantCommon.doLookup(cpi.common, CommonData.Quant.Y1, CommonData.Comp.DC, cpi.common.base_qindex);
        mvDetails.mode_mv = mvDetails.mode_mv_sb[sign_bias ? 1 : 0];
        RDOpt.get_reference_search_order(cpi, ref_frame_map);
        if (ref_frame_map[1] != MVReferenceFrame.INTRA_FRAME) {
            boolean psb = sign_bias;
            if (psb != (sign_bias = FindNearMV.vp8_find_near_mvs_bias(x.e_mbd, x.e_mbd.mode_info_context, mvDetails.mode_mv_sb, mvDetails.best_ref_mv_sb, mvDetails.mdCounts, ref_frame_map[1], cpi.common.ref_frame_sign_bias))) {
                mvDetails.mode_mv = mvDetails.mode_mv_sb[sign_bias ? 1 : 0];
            }
            mvDetails.best_ref_mv.set(mvDetails.best_ref_mv_sb[sign_bias ? 1 : 0]);
        }
        RDOpt.get_predictor_pointers(cpi, plane, recon_yoffset, recon_uvoffset);
        ret.intra = Integer.MAX_VALUE;
        ++x.mbs_tested_so_far;
        x.skip = false;
        block8: for (int mode_index = 0; mode_index < 20; ++mode_index) {
            MBPredictionMode this_mode;
            long this_rd = Long.MAX_VALUE;
            boolean[] disable_skip = new boolean[]{false};
            AtomicInteger other_cost = new AtomicInteger();
            MVReferenceFrame this_ref_frame = ref_frame_map[vp8_ref_frame_order[mode_index]];
            if (best_mode.rd <= (long)x.rd_threshes[mode_index] || this_ref_frame == null) continue;
            mi.mbmi.mode = this_mode = vp8_mode_order[mode_index];
            mi.mbmi.ref_frame = this_ref_frame;
            if (cpi.is_src_frame_alt_ref && cpi.oxcf.arnr_max_frames == 0 && (this_mode != MBPredictionMode.ZEROMV || mi.mbmi.ref_frame != MVReferenceFrame.ALTREF_FRAME)) continue;
            if (mi.mbmi.ref_frame != MVReferenceFrame.INTRA_FRAME) {
                assert (plane[this_ref_frame.ordinal()][0] != null && plane[this_ref_frame.ordinal()][1] != null && plane[this_ref_frame.ordinal()][2] != null);
                x.e_mbd.pre.y_buffer = plane[this_ref_frame.ordinal()][0];
                x.e_mbd.pre.u_buffer = plane[this_ref_frame.ordinal()][1];
                x.e_mbd.pre.v_buffer = plane[this_ref_frame.ordinal()][2];
                if (sign_bias != cpi.common.ref_frame_sign_bias.get((Object)this_ref_frame)) {
                    sign_bias = cpi.common.ref_frame_sign_bias.get((Object)this_ref_frame);
                    mvDetails.mode_mv = mvDetails.mode_mv_sb[sign_bias ? 1 : 0];
                    mvDetails.best_ref_mv.set(mvDetails.best_ref_mv_sb[sign_bias ? 1 : 0]);
                }
            }
            if (x.mode_test_hit_counts[mode_index] != 0 && cpi.mode_check_freq[mode_index] > 1 && x.mbs_tested_so_far <= cpi.mode_check_freq[mode_index] * x.mode_test_hit_counts[mode_index]) {
                int n = mode_index;
                x.rd_thresh_mult[n] = x.rd_thresh_mult[n] + 4;
                if (x.rd_thresh_mult[mode_index] > 512) {
                    x.rd_thresh_mult[mode_index] = 512;
                }
                x.rd_threshes[mode_index] = (cpi.rd_baseline_thresh[mode_index] >> 7) * x.rd_thresh_mult[mode_index];
                continue;
            }
            int n = mode_index;
            x.mode_test_hit_counts[n] = x.mode_test_hit_counts[n] + 1;
            if (x.zbin_mode_boost_enabled) {
                x.zbin_mode_boost = this_ref_frame == MVReferenceFrame.INTRA_FRAME ? 0 : (vp8_mode_order[mode_index] == MBPredictionMode.ZEROMV ? (this_ref_frame != MVReferenceFrame.LAST_FRAME ? 12 : 6) : (vp8_mode_order[mode_index] == MBPredictionMode.SPLITMV ? 0 : 4));
                Quantize.vp8_update_zbin_extra(cpi, x);
            }
            if (!uv_intra_done && this_ref_frame == MVReferenceFrame.INTRA_FRAME) {
                RDOpt.rd_pick_intra_mbuv_mode(x, rduv);
                uv_intra_mode = mi.mbmi.uv_mode;
                for (i = 16; i < 24; uv_intra_tteob += x.e_mbd.eobs.getRel(i), ++i) {
                }
                uv_intra_done = true;
            }
            switch (this_mode) {
                case B_PRED: {
                    QualityMetrics rdtemp = new QualityMetrics();
                    rdtemp.error = best_mode.yrd;
                    rdtemp.rateBase = rdy.rateBase;
                    RDOpt.rd_pick_intra4x4mby_modes(x, rdtemp);
                    rdy.rateBase += rdtemp.rateBase;
                    rdy.distortion += rdtemp.distortion;
                    rdy.rateComp = rdtemp.rateComp;
                    if (rdtemp.error < best_mode.yrd) {
                        assert (uv_intra_done);
                        rdy.rateBase += rduv.rateBase;
                        rduvComplete.rateComp = rduv.rateComp;
                        rdy.distortion += rduv.distortion;
                        rduvComplete.distortion = rduv.distortion;
                        break;
                    }
                    this_rd = Integer.MAX_VALUE;
                    disable_skip[0] = true;
                    break;
                }
                case SPLITMV: {
                    QualityMetrics rryde = new QualityMetrics();
                    rryde.rateComp = rdy.rateComp;
                    int this_rd_thresh = vp8_ref_frame_order[mode_index] == 1 ? x.rd_threshes[ThrModes.THR_NEW1.ordinal()] : x.rd_threshes[ThrModes.THR_NEW3.ordinal()];
                    this_rd_thresh = vp8_ref_frame_order[mode_index] == 2 ? x.rd_threshes[ThrModes.THR_NEW2.ordinal()] : this_rd_thresh;
                    RDOpt.vp8_rd_pick_best_mbsegmentation(cpi, x, mvDetails.best_ref_mv, best_mode.yrd, mvDetails.mdCounts, rryde, this_rd_thresh);
                    rdy.rateBase += rryde.rateBase;
                    rdy.distortion += rryde.distortion;
                    rdy.rateComp = rryde.rateComp;
                    if (rryde.error < best_mode.yrd) {
                        QualityMetrics rde = new QualityMetrics();
                        RDOpt.rd_inter4x4_uv(cpi, x, rde, cpi.common.full_pixel);
                        rdy.rateBase = rde.rateBase;
                        rdy.distortion = rde.distortion;
                        break;
                    }
                    this_rd = Integer.MAX_VALUE;
                    disable_skip[0] = true;
                    break;
                }
                case DC_PRED: 
                case V_PRED: 
                case H_PRED: 
                case TM_PRED: {
                    mi.mbmi.ref_frame = MVReferenceFrame.INTRA_FRAME;
                    x.recon.vp8_build_intra_predictors_mby_s(xd, xd.dst.y_buffer.shallowCopyWithPosInc(-xd.dst.y_stride), xd.dst.y_buffer.shallowCopyWithPosInc(-1), xd.dst.y_stride, xd.predictor, 16);
                    QualityMetrics rde = new QualityMetrics();
                    RDOpt.macro_block_yrd(x, rde);
                    rdy.rateBase += rde.rateComp;
                    rdy.distortion += rde.distortion;
                    rdy.rateComp += x.mbmode_cost.get((Object)x.e_mbd.frame_type).get((Object)mi.mbmi.mode).intValue();
                    assert (uv_intra_done);
                    rdy.rateBase += rduv.rateBase;
                    rduvComplete.rateBase = rduv.rateBase;
                    rduvComplete.distortion += rduv.distortion;
                    rduvComplete.distortion = rduv.distortion;
                    break;
                }
                case NEWMV: {
                    long bestsme = Long.MAX_VALUE;
                    int step_param = cpi.sf.first_step;
                    boolean do_refine = true;
                    int sadpb = x.sadperbit16;
                    MV mvp_full = new MV();
                    short col_min = (short)((mvDetails.best_ref_mv.col + 7 >> 3) - MComp.MAX_FULL_PEL_VAL);
                    short row_min = (short)((mvDetails.best_ref_mv.row + 7 >> 3) - MComp.MAX_FULL_PEL_VAL);
                    short col_max = (short)((mvDetails.best_ref_mv.col >> 3) + MComp.MAX_FULL_PEL_VAL);
                    short row_max = (short)((mvDetails.best_ref_mv.row >> 3) + MComp.MAX_FULL_PEL_VAL);
                    short tmp_col_min = x.mv_col_min;
                    short tmp_col_max = x.mv_col_max;
                    short tmp_row_min = x.mv_row_min;
                    short tmp_row_max = x.mv_row_max;
                    if (!saddone) {
                        RDOpt.vp8_cal_sad(cpi, xd, x, recon_yoffset, mvDetails.nearsad);
                        saddone = true;
                    }
                    RDOpt.vp8_mv_pred(cpi, x.e_mbd, x.e_mbd.mode_info_context, mvDetails.mvp, mi.mbmi.ref_frame, cpi.common.ref_frame_sign_bias, sr, mvDetails.nearsad);
                    mvp_full.set(mvDetails.mvp.div8());
                    if (x.mv_col_min < col_min) {
                        x.mv_col_min = col_min;
                    }
                    if (x.mv_col_max > col_max) {
                        x.mv_col_max = col_max;
                    }
                    if (x.mv_row_min < row_min) {
                        x.mv_row_min = row_min;
                    }
                    if (x.mv_row_max > row_max) {
                        x.mv_row_max = row_max;
                    }
                    if (sr > step_param) {
                        step_param = sr;
                    }
                    VarWithNum varAndNum = new VarWithNum();
                    cpi.diamond_search_sad.call(x, b, d, mvp_full, d.bmi.mv, step_param, sadpb, varAndNum, cpi.fn_ptr.get((Object)BlockEnum.BLOCK_16X16), x.mvcost, mvDetails.best_ref_mv);
                    bestsme = varAndNum.var;
                    mvDetails.mode_mv[MBPredictionMode.NEWMV.ordinal()].set(d.bmi.mv);
                    int further_steps = cpi.sf.max_step_search_steps - 1 - step_param;
                    int n2 = varAndNum.num00;
                    varAndNum.num00 = 0;
                    if (n2 > further_steps) {
                        do_refine = false;
                    }
                    while (n2 < further_steps) {
                        ++n2;
                        if (varAndNum.num00 != 0) {
                            --varAndNum.num00;
                            continue;
                        }
                        cpi.diamond_search_sad.call(x, b, d, mvp_full, d.bmi.mv, step_param + n2, sadpb, varAndNum, cpi.fn_ptr.get((Object)BlockEnum.BLOCK_16X16), x.mvcost, mvDetails.best_ref_mv);
                        long thissme = varAndNum.var;
                        if (varAndNum.num00 > further_steps - n2) {
                            do_refine = false;
                        }
                        if (thissme < bestsme) {
                            bestsme = thissme;
                            mvDetails.mode_mv[MBPredictionMode.NEWMV.ordinal()].set(d.bmi.mv);
                            continue;
                        }
                        d.bmi.mv.set(mvDetails.mode_mv[MBPredictionMode.NEWMV.ordinal()]);
                    }
                    if (do_refine) {
                        int search_range = 8;
                        long thissme = cpi.refining_search_sad.call(x, b, d, d.bmi.mv, sadpb, search_range, cpi.fn_ptr.get((Object)BlockEnum.BLOCK_16X16), x.mvcost, mvDetails.best_ref_mv);
                        if (thissme < bestsme) {
                            bestsme = thissme;
                            mvDetails.mode_mv[MBPredictionMode.NEWMV.ordinal()].set(d.bmi.mv);
                        } else {
                            d.bmi.mv.set(mvDetails.mode_mv[MBPredictionMode.NEWMV.ordinal()]);
                        }
                    }
                    x.mv_col_min = tmp_col_min;
                    x.mv_col_max = tmp_col_max;
                    x.mv_row_min = tmp_row_min;
                    x.mv_row_max = tmp_row_max;
                    if (bestsme < Integer.MAX_VALUE) {
                        VarianceResults res = new VarianceResults();
                        cpi.find_fractional_mv_step.call(x, b, d, d.bmi.mv, mvDetails.best_ref_mv, x.errorperbit, cpi.fn_ptr.get((Object)BlockEnum.BLOCK_16X16), x.mvcost, res);
                    }
                    mvDetails.mode_mv[MBPredictionMode.NEWMV.ordinal()].set(d.bmi.mv);
                    rdy.rateBase += MComp.vp8_mv_bit_cost(mvDetails.mode_mv[MBPredictionMode.NEWMV.ordinal()], mvDetails.best_ref_mv, x.mvcost, 96);
                }
                case NEARESTMV: 
                case NEARMV: {
                    FindNearMV.vp8_clamp_mv2(mvDetails.mode_mv[this_mode.ordinal()], xd);
                    if ((this_mode == MBPredictionMode.NEARMV || this_mode == MBPredictionMode.NEARESTMV) && mvDetails.mode_mv[this_mode.ordinal()].isZero()) continue block8;
                }
                case ZEROMV: {
                    if (mvDetails.mode_mv[this_mode.ordinal()].row >> 3 < x.mv_row_min || mvDetails.mode_mv[this_mode.ordinal()].row >> 3 > x.mv_row_max || mvDetails.mode_mv[this_mode.ordinal()].col >> 3 < x.mv_col_min || mvDetails.mode_mv[this_mode.ordinal()].col >> 3 > x.mv_col_max) continue block8;
                    RDOpt.vp8_set_mbmode_and_mvs(x, this_mode, mvDetails.mode_mv[this_mode.ordinal()]);
                    this_rd = RDOpt.evaluate_inter_mode_rd(mvDetails.mdCounts, rdy, rduvComplete, disable_skip, cpi, x);
                }
            }
            this_rd = RDOpt.calculate_final_rd_costs(this_rd, rdy, rduvComplete, other_cost, disable_skip[0], uv_intra_tteob, intra_rd_penalty, cpi, x);
            if (mi.mbmi.ref_frame == MVReferenceFrame.INTRA_FRAME && this_rd < best_mode.intra_rd) {
                best_mode.intra_rd = this_rd;
                ret.intra = rdy.distortion;
            }
            if (this_rd < best_mode.rd || x.skip) {
                best_mode_index = mode_index;
                ret.rate = rdy.rateBase;
                ret.distortion = rdy.distortion;
                if (MBPredictionMode.basicModes.contains((Object)this_mode)) {
                    mi.mbmi.uv_mode = uv_intra_mode;
                    mi.mbmi.mv.setZero();
                }
                RDOpt.update_best_mode(best_mode, this_rd, rdy, rduvComplete, other_cost.get(), x);
                x.rd_thresh_mult[mode_index] = x.rd_thresh_mult[mode_index] >= 34 ? x.rd_thresh_mult[mode_index] - 2 : 32;
            } else {
                int n3 = mode_index;
                x.rd_thresh_mult[n3] = x.rd_thresh_mult[n3] + 4;
                if (x.rd_thresh_mult[mode_index] > 512) {
                    x.rd_thresh_mult[mode_index] = 512;
                }
            }
            x.rd_threshes[mode_index] = (cpi.rd_baseline_thresh[mode_index] >> 7) * x.rd_thresh_mult[mode_index];
            if (x.skip) break;
        }
        RDOpt.reduceActivationThreshold(cpi, best_mode_index);
        if (RDOpt.adjustToZeroMVForAltref(cpi, best_mode.mbmode)) {
            return;
        }
        mi.mbmi.copyIn(best_mode.mbmode);
        if (best_mode.mbmode.mode == MBPredictionMode.B_PRED) {
            for (i = 0; i < 16; ++i) {
                mi.bmi[i].as_mode(best_mode.bmodes[i].as_mode());
            }
        }
        if (best_mode.mbmode.mode == MBPredictionMode.SPLITMV) {
            for (i = 0; i < 16; ++i) {
                mi.bmi[i].mv.set(best_mode.bmodes[i].mv);
            }
            x.partition_info.get().copyin(best_mode.partition);
            mi.mbmi.mv.set(x.partition_info.get().bmi[15].mv);
        }
        if (sign_bias != cpi.common.ref_frame_sign_bias.get((Object)mi.mbmi.ref_frame)) {
            mvDetails.best_ref_mv.set(mvDetails.best_ref_mv_sb[sign_bias ? 0 : 1]);
        }
        RDOpt.rd_update_mvcount(x, mvDetails.best_ref_mv);
    }

    static void vp8_set_mbmode_and_mvs(Macroblock x, MBPredictionMode mb, MV mv) {
        ModeInfo mi = x.e_mbd.mode_info_context.get();
        mi.mbmi.mode = mb;
        mi.mbmi.mv.set(mv);
    }

    static long vp8_rd_pick_intra_mode(Macroblock x) {
        ModeInfo mi = x.e_mbd.mode_info_context.get();
        mi.mbmi.ref_frame = MVReferenceFrame.INTRA_FRAME;
        QualityMetrics resUV = new QualityMetrics();
        RDOpt.rd_pick_intra_mbuv_mode(x, resUV);
        QualityMetrics res16 = new QualityMetrics();
        RDOpt.rd_pick_intra16x16mby_mode(x, res16);
        QualityMetrics res4 = new QualityMetrics();
        res4.error = res16.error;
        RDOpt.rd_pick_intra4x4mby_modes(x, res4);
        if (res4.error < res16.error) {
            mi.mbmi.mode = MBPredictionMode.B_PRED;
            res16.rateComp = res4.rateComp;
        }
        return resUV.rateComp + res16.rateComp;
    }

    static void insertsortsad(long[] arr, int[] idx, int len) {
        for (int i = 1; i <= len - 1; ++i) {
            for (int j = 0; j < i; ++j) {
                if (arr[j] <= arr[i]) continue;
                long temp = arr[i];
                int tempi = idx[i];
                for (int k = i; k > j; --k) {
                    arr[k] = arr[k - 1];
                    idx[k] = idx[k - 1];
                }
                arr[j] = temp;
                idx[j] = tempi;
            }
        }
    }

    static void insertsortmv(int[] arr, int len) {
        for (int i = 1; i <= len - 1; ++i) {
            for (int j = 0; j < i; ++j) {
                if (arr[j] <= arr[i]) continue;
                int temp = arr[i];
                for (int k = i; k > j; --k) {
                    arr[k] = arr[k - 1];
                }
                arr[j] = temp;
            }
        }
    }

    static int vp8_mv_pred(Compressor cpi, MacroblockD xd, FullAccessGenArrPointer<ModeInfo> herePtr, MV mvp, MVReferenceFrame refframe, EnumMap<MVReferenceFrame, Boolean> ref_frame_sign_bias, int sr, int[] near_sadidx) {
        ModeInfo here = herePtr.get();
        ModeInfo above = herePtr.getRel(-xd.mode_info_stride);
        ModeInfo left = herePtr.getRel(-1);
        ModeInfo aboveleft = herePtr.getRel(-xd.mode_info_stride - 1);
        ModeInfo[] around = new ModeInfo[]{above, left, aboveleft};
        MV[] near_mvs = new MV[8];
        MVReferenceFrame[] near_ref = new MVReferenceFrame[8];
        MV mv = new MV();
        int vcnt = 0;
        boolean find = false;
        int[] mvx = new int[8];
        int[] mvy = new int[8];
        if (here.mbmi.ref_frame != MVReferenceFrame.INTRA_FRAME) {
            int i;
            int j;
            for (j = 0; j < near_mvs.length; ++j) {
                near_mvs[j] = new MV();
                near_ref[j] = MVReferenceFrame.INTRA_FRAME;
            }
            j = 0;
            while (j < around.length) {
                if (around[j].mbmi.ref_frame != MVReferenceFrame.INTRA_FRAME) {
                    near_mvs[vcnt].set(around[j].mbmi.mv);
                    FindNearMV.mv_bias(ref_frame_sign_bias.get((Object)around[j].mbmi.ref_frame), refframe, near_mvs[vcnt], ref_frame_sign_bias);
                    near_ref[vcnt] = around[j].mbmi.ref_frame;
                }
                ++j;
                ++vcnt;
            }
            if (cpi.common.last_frame_type != FrameType.KEY_FRAME) {
                int mb_offset = (-xd.mb_to_top_edge / 128 + 1) * (xd.mode_info_stride + 1) + (-xd.mb_to_left_edge / 128 + 1);
                int[] shiftsForNearby = new int[]{0, -xd.mode_info_stride - 1, -1, 1, xd.mode_info_stride + 1};
                int j2 = 0;
                while (j2 < shiftsForNearby.length) {
                    if (cpi.lf_ref_frame[mb_offset + shiftsForNearby[j2]] != MVReferenceFrame.INTRA_FRAME) {
                        near_mvs[vcnt].set(cpi.lfmv[mb_offset + shiftsForNearby[j2]]);
                        FindNearMV.mv_bias(cpi.lf_ref_frame_sign_bias[mb_offset + shiftsForNearby[j2]], refframe, near_mvs[vcnt], ref_frame_sign_bias);
                        near_ref[vcnt] = cpi.lf_ref_frame[mb_offset + shiftsForNearby[j2]];
                    }
                    ++j2;
                    ++vcnt;
                }
            }
            for (i = 0; i < vcnt; ++i) {
                if (near_ref[near_sadidx[i]] == MVReferenceFrame.INTRA_FRAME || here.mbmi.ref_frame != near_ref[near_sadidx[i]]) continue;
                mv.set(near_mvs[near_sadidx[i]]);
                find = true;
                if (i < 3) {
                    sr = 3;
                    break;
                }
                sr = 2;
                break;
            }
            if (!find) {
                for (i = 0; i < vcnt; ++i) {
                    mvx[i] = near_mvs[i].row;
                    mvy[i] = near_mvs[i].col;
                }
                RDOpt.insertsortmv(mvx, vcnt);
                RDOpt.insertsortmv(mvy, vcnt);
                mv.row = (short)mvx[vcnt / 2];
                mv.col = (short)mvy[vcnt / 2];
                sr = 0;
            }
        }
        mvp.set(mv);
        FindNearMV.vp8_clamp_mv2(mvp, xd);
        return sr;
    }

    static void vp8_cal_sad(Compressor cpi, MacroblockD xd, Macroblock x, int recon_yoffset, int[] near_sadidx) {
        long[] near_sad = new long[8];
        Block b = x.block.get();
        FullAccessIntArrPointer src_y_ptr = b.base_src;
        if (xd.mb_to_top_edge == 0 && xd.mb_to_left_edge == 0) {
            near_sad[2] = Integer.MAX_VALUE;
            near_sad[1] = Integer.MAX_VALUE;
            near_sad[0] = Integer.MAX_VALUE;
        } else if (xd.mb_to_top_edge == 0) {
            near_sad[2] = Integer.MAX_VALUE;
            near_sad[0] = Integer.MAX_VALUE;
            near_sad[1] = cpi.fn_ptr.get((Object)((Object)BlockEnum.BLOCK_16X16)).sdf.call(src_y_ptr, b.src_stride, xd.dst.y_buffer.shallowCopyWithPosInc(-16), xd.dst.y_stride);
        } else if (xd.mb_to_left_edge == 0) {
            near_sad[2] = Integer.MAX_VALUE;
            near_sad[1] = Integer.MAX_VALUE;
            near_sad[0] = cpi.fn_ptr.get((Object)((Object)BlockEnum.BLOCK_16X16)).sdf.call(src_y_ptr, b.src_stride, xd.dst.y_buffer.shallowCopyWithPosInc(-xd.dst.y_stride * 16), xd.dst.y_stride);
        } else {
            near_sad[0] = cpi.fn_ptr.get((Object)((Object)BlockEnum.BLOCK_16X16)).sdf.call(src_y_ptr, b.src_stride, xd.dst.y_buffer.shallowCopyWithPosInc(-xd.dst.y_stride * 16), xd.dst.y_stride);
            near_sad[1] = cpi.fn_ptr.get((Object)((Object)BlockEnum.BLOCK_16X16)).sdf.call(src_y_ptr, b.src_stride, xd.dst.y_buffer.shallowCopyWithPosInc(-16), xd.dst.y_stride);
            near_sad[2] = cpi.fn_ptr.get((Object)((Object)BlockEnum.BLOCK_16X16)).sdf.call(src_y_ptr, b.src_stride, xd.dst.y_buffer.shallowCopyWithPosInc(-xd.dst.y_stride * 16 - 16), xd.dst.y_stride);
        }
        if (cpi.common.last_frame_type != FrameType.KEY_FRAME) {
            int lfrIdx = cpi.common.frameIdxs.get((Object)MVReferenceFrame.LAST_FRAME);
            FullAccessIntArrPointer pre_y_buffer = cpi.common.yv12_fb[lfrIdx].y_buffer.shallowCopyWithPosInc(recon_yoffset);
            int pre_y_stride = cpi.common.yv12_fb[lfrIdx].y_stride;
            if (xd.mb_to_top_edge == 0) {
                near_sad[4] = Integer.MAX_VALUE;
            }
            if (xd.mb_to_left_edge == 0) {
                near_sad[5] = Integer.MAX_VALUE;
            }
            if (xd.mb_to_right_edge == 0) {
                near_sad[6] = Integer.MAX_VALUE;
            }
            if (xd.mb_to_bottom_edge == 0) {
                near_sad[7] = Integer.MAX_VALUE;
            }
            if (near_sad[4] != Integer.MAX_VALUE) {
                near_sad[4] = cpi.fn_ptr.get((Object)((Object)BlockEnum.BLOCK_16X16)).sdf.call(src_y_ptr, b.src_stride, pre_y_buffer.shallowCopyWithPosInc(-pre_y_stride * 16), pre_y_stride);
            }
            if (near_sad[5] != Integer.MAX_VALUE) {
                near_sad[5] = cpi.fn_ptr.get((Object)((Object)BlockEnum.BLOCK_16X16)).sdf.call(src_y_ptr, b.src_stride, pre_y_buffer.shallowCopyWithPosInc(-16), pre_y_stride);
            }
            near_sad[3] = cpi.fn_ptr.get((Object)((Object)BlockEnum.BLOCK_16X16)).sdf.call(src_y_ptr, b.src_stride, pre_y_buffer, pre_y_stride);
            if (near_sad[6] != Integer.MAX_VALUE) {
                near_sad[6] = cpi.fn_ptr.get((Object)((Object)BlockEnum.BLOCK_16X16)).sdf.call(src_y_ptr, b.src_stride, pre_y_buffer.shallowCopyWithPosInc(16), pre_y_stride);
            }
            if (near_sad[7] != Integer.MAX_VALUE) {
                near_sad[7] = cpi.fn_ptr.get((Object)((Object)BlockEnum.BLOCK_16X16)).sdf.call(src_y_ptr, b.src_stride, pre_y_buffer.shallowCopyWithPosInc(pre_y_stride * 16), pre_y_stride);
            }
        }
        if (cpi.common.last_frame_type != FrameType.KEY_FRAME) {
            RDOpt.insertsortsad(near_sad, near_sadidx, 8);
        } else {
            RDOpt.insertsortsad(near_sad, near_sadidx, 3);
        }
    }

    static int vp8_cost_mv_ref(MBPredictionMode m, int[] near_mv_ref_ct) {
        short[] p = new short[BlockD.VP8_MVREFS - 1];
        assert (MBPredictionMode.NEARESTMV.ordinal() <= m.ordinal() && m.ordinal() <= MBPredictionMode.SPLITMV.ordinal());
        FindNearMV.vp8_mv_ref_probs(p, near_mv_ref_ct);
        return TreeWriter.vp8_cost_token(EntropyMode.vp8_mv_ref_tree, new ReadOnlyIntArrPointer(p, 0), Token.vp8_mv_ref_encoding_array[m.ordinal() - MBPredictionMode.NEARESTMV.ordinal()]);
    }

    static int VP8_UVSSE(Compressor cpi) {
        Macroblock x = cpi.mb;
        FullAccessIntArrPointer upred_ptr = x.block.getRel(16).getSrcPtr();
        FullAccessIntArrPointer vpred_ptr = x.block.getRel(20).getSrcPtr();
        int uv_stride = x.block.getRel((int)16).src_stride;
        VarianceResults ret1 = new VarianceResults();
        VarianceResults ret2 = new VarianceResults();
        ModeInfo mi = x.e_mbd.mode_info_context.get();
        int mv_row = mi.mbmi.mv.row;
        int mv_col = mi.mbmi.mv.col;
        int pre_stride = x.e_mbd.pre.uv_stride;
        mv_row = mv_row < 0 ? --mv_row : ++mv_row;
        mv_col = mv_col < 0 ? --mv_col : ++mv_col;
        int offset = ((mv_row /= 2) >> 3) * pre_stride + ((mv_col /= 2) >> 3);
        FullAccessIntArrPointer uptr = x.e_mbd.pre.u_buffer.shallowCopyWithPosInc(offset);
        FullAccessIntArrPointer vptr = x.e_mbd.pre.v_buffer.shallowCopyWithPosInc(offset);
        if (((mv_row | mv_col) & 7) != 0) {
            VarianceFNs.SVF svfn = cpi.varFns.default_fn_ptr.get((Object)((Object)BlockEnum.BLOCK_8X8)).svf;
            svfn.call(uptr, pre_stride, mv_col & 7, mv_row & 7, upred_ptr, uv_stride, ret2);
            svfn.call(vptr, pre_stride, mv_col & 7, mv_row & 7, vpred_ptr, uv_stride, ret1);
        } else {
            Variance.variance(uptr, pre_stride, upred_ptr, uv_stride, ret2, 8, 8);
            Variance.variance(vptr, pre_stride, vpred_ptr, uv_stride, ret1, 8, 8);
        }
        return ret2.sse + ret1.sse;
    }

    static void rd_inter16x16_uv(Compressor cpi, Macroblock x, QualityMetrics ret, boolean fullpixel) {
        ReconInter.vp8_build_inter16x16_predictors_mbuv(x.e_mbd);
        EncodeMB.vp8_subtract_mbuv(x.src_diff, x.src.u_buffer, x.src.v_buffer, x.src.uv_stride, x.e_mbd.getFreshUPredPtr(), x.e_mbd.getFreshVPredPtr(), 8);
        EncodeMB.vp8_transform_mbuv(x);
        Quantize.vp8_quantize_mbuv(x);
        ret.rateBase = RDOpt.rd_cost_mbuv(x);
        ret.distortion = RDOpt.vp8_mbuverror(x) >> 4;
        ret.error = RDOpt.RDCOST(x.rdmult, x.rddiv, ret.rateBase, ret.distortion);
    }

    static long evaluate_inter_mode_rd(int[] mdcounts, QualityMetrics rdy, QualityMetrics rduv, boolean[] disable_skip, Compressor cpi, Macroblock x) {
        MBPredictionMode this_mode = x.e_mbd.mode_info_context.get().mbmi.mode;
        Block b = x.block.get();
        MacroblockD xd = x.e_mbd;
        ReconInter.vp8_build_inter16x16_predictors_mby(x.e_mbd, x.e_mbd.predictor, 16);
        if (cpi.active_map_enabled && x.active_ptr.get() == 0) {
            x.skip = true;
        } else if (x.encode_breakout != 0) {
            int sse2;
            short q2dc;
            VarianceResults res = new VarianceResults();
            int threshold = xd.block.get().dequant.getRel(1) * xd.block.get().dequant.getRel(1) >> 4;
            if (threshold < x.encode_breakout) {
                threshold = x.encode_breakout;
            }
            Variance.variance(b.base_src, b.src_stride, x.e_mbd.predictor, 16, res, 16, 16);
            if (res.sse < threshold && ((long)res.sse - res.variance < (long)((q2dc = xd.block.getRel((int)24).dequant.get()) * q2dc >> 4) || (long)(res.sse / 2) > res.variance && (long)res.sse - res.variance < 64L) && (sse2 = RDOpt.VP8_UVSSE(cpi)) << 1 < threshold) {
                x.skip = true;
                rdy.distortion = res.sse + sse2;
                rdy.rateBase = 500;
                rduv.rateBase = 0;
                rduv.distortion = sse2;
                disable_skip[0] = true;
                return RDOpt.RDCOST(x.rdmult, x.rddiv, rdy.rateBase, rdy.distortion);
            }
        }
        rdy.rateBase += RDOpt.vp8_cost_mv_ref(this_mode, mdcounts);
        QualityMetrics rde = new QualityMetrics();
        RDOpt.macro_block_yrd(x, rde);
        rdy.rateBase += rde.rateComp;
        rdy.distortion += rde.distortion;
        RDOpt.rd_inter16x16_uv(cpi, x, rde, cpi.common.full_pixel);
        rduv.rateBase += rde.rateComp;
        rdy.distortion += rde.distortion;
        return Integer.MAX_VALUE;
    }

    static long calculate_final_rd_costs(long this_rd, QualityMetrics rdy, QualityMetrics rduv, AtomicInteger other_cost, boolean disable_skip, int uv_intra_tteob, int intra_rd_penalty, Compressor cpi, Macroblock x) {
        ModeInfo mi = x.e_mbd.mode_info_context.get();
        MBPredictionMode this_mode = mi.mbmi.mode;
        if (cpi.common.mb_no_coeff_skip) {
            other_cost.addAndGet(TreeWriter.vp8_cost_bit(cpi.prob_skip_false, 0));
            rdy.rateBase += other_cost.get();
        }
        rdy.rateBase += x.ref_frame_cost[mi.mbmi.ref_frame.ordinal()];
        if (!disable_skip) {
            if (cpi.common.mb_no_coeff_skip) {
                int i;
                boolean has_y2_block = !MBPredictionMode.has_no_y_block.contains((Object)this_mode);
                int tteob = 0;
                if (has_y2_block) {
                    tteob += x.e_mbd.eobs.getRel(24);
                }
                for (i = 0; i < 16; ++i) {
                    if (x.e_mbd.eobs.getRel(i) <= (has_y2_block ? (short)1 : 0)) continue;
                    ++tteob;
                }
                if (mi.mbmi.ref_frame != MVReferenceFrame.INTRA_FRAME) {
                    for (i = 16; i < 24; ++i) {
                        tteob += x.e_mbd.eobs.getRel(i);
                    }
                } else {
                    tteob += uv_intra_tteob;
                }
                if (tteob == 0) {
                    rdy.rateBase -= rdy.rateComp + rduv.rateComp;
                    rduv.rateComp = 0;
                    if (cpi.prob_skip_false != 0) {
                        int prob_skip_cost = TreeWriter.vp8_cost_bit(cpi.prob_skip_false, 1);
                        rdy.rateBase += (prob_skip_cost -= TreeWriter.vp8_cost_bit(cpi.prob_skip_false, 0));
                        other_cost.addAndGet(prob_skip_cost);
                    }
                }
            }
            if ((this_rd = RDOpt.RDCOST(x.rdmult, x.rddiv, rdy.rateBase, rdy.distortion)) < Integer.MAX_VALUE && mi.mbmi.ref_frame == MVReferenceFrame.INTRA_FRAME) {
                this_rd += (long)intra_rd_penalty;
            }
        }
        return this_rd;
    }

    static void update_best_mode(BestMode best_mode, long this_rd, QualityMetrics rdy, QualityMetrics rduv, int other_cost, Macroblock x) {
        ModeInfo mi = x.e_mbd.mode_info_context.get();
        MBPredictionMode this_mode = mi.mbmi.mode;
        best_mode.yrd = RDOpt.RDCOST(x.rdmult, x.rddiv, rdy.rateComp - rduv.rateComp - (other_cost += x.ref_frame_cost[mi.mbmi.ref_frame.ordinal()]), rdy.distortion - rduv.distortion);
        best_mode.rd = this_rd;
        best_mode.mbmode.copyIn(mi.mbmi);
        best_mode.partition.copyin(x.partition_info.get());
        if (MBPredictionMode.has_no_y_block.contains((Object)this_mode)) {
            for (int i = 0; i < 16; ++i) {
                best_mode.bmodes[i] = x.e_mbd.block.getRel((int)i).bmi;
            }
        }
    }

    static void rd_update_mvcount(Macroblock x, MV best_ref_mv) {
        ModeInfo mi = x.e_mbd.mode_info_context.get();
        if (mi.mbmi.mode == MBPredictionMode.SPLITMV) {
            for (int i = 0; i < x.partition_info.get().count; ++i) {
                if (x.partition_info.get().bmi[i].mode != BPredictionMode.NEW4X4) continue;
                int[] nArray = x.MVcount[0];
                int n = 1023 + (x.partition_info.get().bmi[i].mv.row - best_ref_mv.row >> 1);
                nArray[n] = nArray[n] + 1;
                int[] nArray2 = x.MVcount[1];
                int n2 = 1023 + (x.partition_info.get().bmi[i].mv.col - best_ref_mv.col >> 1);
                nArray2[n2] = nArray2[n2] + 1;
            }
        } else if (mi.mbmi.mode == MBPredictionMode.NEWMV) {
            int[] nArray = x.MVcount[0];
            int n = 1023 + (mi.mbmi.mv.row - best_ref_mv.row >> 1);
            nArray[n] = nArray[n] + 1;
            int[] nArray3 = x.MVcount[1];
            int n3 = 1023 + (mi.mbmi.mv.col - best_ref_mv.col >> 1);
            nArray3[n3] = nArray3[n3] + 1;
        }
    }

    static void vp8_auto_select_speed(Compressor cpi) {
        int milliseconds_for_compress = (int)(1000000.0 / cpi.framerate);
        if (cpi.avg_pick_mode_time < (milliseconds_for_compress = milliseconds_for_compress * (16 - cpi.oxcf.getCpu_used()) / 16) && cpi.avg_encode_time - cpi.avg_pick_mode_time < milliseconds_for_compress) {
            if (cpi.avg_pick_mode_time == 0) {
                cpi.Speed = 4;
            } else {
                if (milliseconds_for_compress * 100 < cpi.avg_encode_time * 95) {
                    cpi.Speed += 2;
                    cpi.avg_pick_mode_time = 0;
                    cpi.avg_encode_time = 0;
                    if (cpi.Speed > 16) {
                        cpi.Speed = 16;
                    }
                }
                if (milliseconds_for_compress * 100 > cpi.avg_encode_time * auto_speed_thresh[cpi.Speed]) {
                    --cpi.Speed;
                    cpi.avg_pick_mode_time = 0;
                    cpi.avg_encode_time = 0;
                    if (cpi.Speed < 4) {
                        cpi.Speed = 4;
                    }
                }
            }
        } else {
            cpi.Speed += 4;
            if (cpi.Speed > 16) {
                cpi.Speed = 16;
            }
            cpi.avg_pick_mode_time = 0;
            cpi.avg_encode_time = 0;
        }
    }

    static void fill_token_costs(int[][][][] c, short[][][][] p) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 3; ++k) {
                    if (k == 0 && j > (i == 0 ? 1 : 0)) {
                        TreeWriter.vp8_cost_tokens2(c[i][j][k], new ReadOnlyIntArrPointer(p[i][j][k], 0), Entropy.vp8_coef_tree, 2);
                        continue;
                    }
                    TreeWriter.vp8_cost_tokens(c[i][j][k], new ReadOnlyIntArrPointer(p[i][j][k], 0), Entropy.vp8_coef_tree);
                }
            }
        }
    }

    static void vp8_initialize_rd_consts(Compressor cpi, Macroblock x, int Qvalue) {
        int i;
        double capped_q = Qvalue < 160 ? (double)Qvalue : 160.0;
        double rdconst = 2.8;
        cpi.RDMULT = (int)(rdconst * (capped_q * capped_q));
        if (cpi.mb.zbin_over_quant > 0) {
            double oq_factor = 1.0 + 0.0015625 * (double)cpi.mb.zbin_over_quant;
            double modq = (int)(capped_q * oq_factor);
            cpi.RDMULT = (int)(rdconst * (modq * modq));
        }
        cpi.mb.errorperbit = Math.max(cpi.RDMULT / 110, 1);
        OnyxIf.vp8_set_speed_features(cpi);
        for (i = 0; i < 20; ++i) {
            x.mode_test_hit_counts[i] = 0;
        }
        int q = (int)Math.pow(Qvalue, 1.25);
        if (q < 8) {
            q = 8;
        }
        if (cpi.RDMULT > 1000) {
            cpi.RDDIV = 1;
            cpi.RDMULT /= 100;
            for (i = 0; i < 20; ++i) {
                x.rd_threshes[i] = cpi.sf.thresh_mult[i] < Integer.MAX_VALUE ? cpi.sf.thresh_mult[i] * q / 100 : Integer.MAX_VALUE;
                cpi.rd_baseline_thresh[i] = x.rd_threshes[i];
            }
        } else {
            cpi.RDDIV = 100;
            for (i = 0; i < 20; ++i) {
                x.rd_threshes[i] = cpi.sf.thresh_mult[i] < Integer.MAX_VALUE / q ? cpi.sf.thresh_mult[i] * q : Integer.MAX_VALUE;
                cpi.rd_baseline_thresh[i] = x.rd_threshes[i];
            }
        }
        FrameContext l = cpi.lfc_n;
        if (cpi.common.refresh_alt_ref_frame) {
            l = cpi.lfc_a;
        } else if (cpi.common.refresh_golden_frame) {
            l = cpi.lfc_g;
        }
        RDOpt.fill_token_costs(cpi.mb.token_costs, l.coef_probs);
        cpi.rd_costs.vp8_init_mode_costs(cpi);
    }

    static void reduceActivationThreshold(Compressor cpi, int best_mode_index) {
        if (cpi.rd_baseline_thresh[best_mode_index] > 0 && cpi.rd_baseline_thresh[best_mode_index] < 0x1FFFFFFF) {
            Macroblock x = cpi.mb;
            int best_adjustment = x.rd_thresh_mult[best_mode_index] >> 3;
            x.rd_thresh_mult[best_mode_index] = x.rd_thresh_mult[best_mode_index] >= 32 + best_adjustment ? x.rd_thresh_mult[best_mode_index] - best_adjustment : 32;
            x.rd_threshes[best_mode_index] = (cpi.rd_baseline_thresh[best_mode_index] >> 7) * x.rd_thresh_mult[best_mode_index];
        }
    }

    static boolean adjustToZeroMVForAltref(Compressor cpi, MBModeInfo best_mbmode) {
        if (cpi.is_src_frame_alt_ref && (best_mbmode.mode != MBPredictionMode.ZEROMV || best_mbmode.ref_frame != MVReferenceFrame.ALTREF_FRAME)) {
            Macroblock x = cpi.mb;
            ModeInfo mi = x.e_mbd.mode_info_context.get();
            mi.mbmi.mode = MBPredictionMode.ZEROMV;
            mi.mbmi.ref_frame = MVReferenceFrame.ALTREF_FRAME;
            mi.mbmi.mv.setZero();
            mi.mbmi.uv_mode = MBPredictionMode.DC_PRED;
            mi.mbmi.mb_skip_coeff = cpi.common.mb_no_coeff_skip;
            mi.mbmi.partitioning = BlockEnum.BLOCK_16X8;
            return true;
        }
        return false;
    }
}

