/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8;

import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.CommonUtils;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.Variance;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.VarianceFNs;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.VarianceResults;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.PositionableIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.subpixfns.BilinearPredict;

public class SubpixelVariance
implements VarianceFNs.SVF {
    static final int FILTER_BITS = 7;
    private final int w;
    private final int h;
    private final FullAccessIntArrPointer biliX;
    private final FullAccessIntArrPointer biliY;

    static void var_filter_block2d_bil(PositionableIntArrPointer src_ptr, FullAccessIntArrPointer ref_ptr, int src_pixels_per_line, int pixel_step, int output_height, int output_width, int[] filter) {
        int baseSrc = 0;
        int baseRef = 0;
        for (int i = 0; i < output_height; ++i) {
            int basePS = baseSrc + pixel_step;
            for (int j = 0; j < output_width; ++j) {
                ref_ptr.setRel(baseRef + j, (short)CommonUtils.roundPowerOfTwo(src_ptr.getRel(baseSrc + j) * filter[0] + src_ptr.getRel(basePS + j) * filter[1], 7));
            }
            baseSrc += src_pixels_per_line;
            baseRef += output_width;
        }
    }

    public SubpixelVariance(int w, int h) {
        this.w = w;
        this.h = h;
        this.biliX = new FullAccessIntArrPointer((h + 1) * w);
        this.biliY = new FullAccessIntArrPointer(h * w);
    }

    @Override
    public void call(PositionableIntArrPointer src_ptr, int src_stride, int xoff, int yoff, PositionableIntArrPointer ref_ptr, int ref_stride, VarianceResults sse) {
        SubpixelVariance.var_filter_block2d_bil(src_ptr, this.biliX, src_stride, 1, this.h + 1, this.w, BilinearPredict.vp8_bilinear_filters[xoff]);
        SubpixelVariance.var_filter_block2d_bil(this.biliX, this.biliY, this.w, this.w, this.h, this.w, BilinearPredict.vp8_bilinear_filters[yoff]);
        Variance.variance(this.biliY, this.w, ref_ptr, ref_stride, sse, this.w, this.h);
    }
}

