/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8;

import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.VP8Util;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.VPXConst;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.BlockD;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Compressor;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.DCTValueConstants;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.EntropyContextPlanes;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Macroblock;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.MacroblockD;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.TokenExtra;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.TokenValue;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.PlaneType;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.TokenAlphabet;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessGenArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessIntArrPointer;

public class Tokenize {
    private static TokenExtra configureToken(FullAccessGenArrPointer<TokenExtra> tp, TokenAlphabet tok, Compressor cpi, PlaneType type, int band, int pt, boolean skip) {
        int typ = type.ordinal();
        TokenExtra t = tp.get();
        if (t == null) {
            t = new TokenExtra();
            tp.setAndInc(t);
        } else {
            tp.inc();
        }
        t.Token = tok;
        t.context_tree = cpi.common.fc.coef_probs[typ][band][pt];
        t.skip_eob_node = skip;
        int[] nArray = cpi.mb.coef_counts[typ][band][pt];
        int n = tok.ordinal();
        nArray[n] = nArray[n] + 1;
        return t;
    }

    private static void configureAsEob(FullAccessGenArrPointer<TokenExtra> tp, Compressor cpi, PlaneType type, int band, int pt, boolean skip) {
        Tokenize.configureToken(tp, TokenAlphabet.DCT_EOB_TOKEN, cpi, type, band, pt, skip);
    }

    private static int configureAsGeneric(FullAccessGenArrPointer<TokenExtra> tp, Compressor cpi, int v, PlaneType type, int band, int pt, boolean skip) {
        TokenValue tv = DCTValueConstants.getTokenValue(v);
        TokenAlphabet token = tv.token;
        TokenExtra t = Tokenize.configureToken(tp, token, cpi, type, band, pt, skip);
        t.Extra = tv.extra;
        return token.previousTokenClass;
    }

    static void tokenize2nd_order_b(Macroblock x, FullAccessGenArrPointer<TokenExtra> tp, Compressor cpi) {
        MacroblockD xd = x.e_mbd;
        Tokenize.singleBlockfinalizeTokenize(PlaneType.Y2, tp, cpi, 24, xd.above_context.get().panes, xd.left_context.panes);
    }

    static void tokenize1st_order_b(Macroblock x, FullAccessGenArrPointer<TokenExtra> tp, PlaneType type, Compressor cpi) {
        int block;
        MacroblockD xd = x.e_mbd;
        FullAccessIntArrPointer a = xd.above_context.get().panes;
        FullAccessIntArrPointer l = xd.left_context.panes;
        for (block = 0; block < 16; ++block) {
            Tokenize.singleBlockfinalizeTokenize(type, tp, cpi, block, a, l);
        }
        for (block = 16; block < 24; ++block) {
            Tokenize.singleBlockfinalizeTokenize(PlaneType.UV, tp, cpi, block, a, l);
        }
    }

    private static void singleBlockfinalizeTokenize(PlaneType type, FullAccessGenArrPointer<TokenExtra> tp, Compressor cpi, int block, FullAccessIntArrPointer a, FullAccessIntArrPointer l) {
        BlockD bd = cpi.mb.e_mbd.block.getRel(block);
        short eob = bd.eob.get();
        FullAccessIntArrPointer qcoeff_ptr = bd.qcoeff;
        int aPos = BlockD.vp8_block2above[block];
        int lPos = BlockD.vp8_block2left[block];
        int pt = a.getRel(aPos) + l.getRel(lPos);
        int c = type.start_coeff;
        if (c >= eob) {
            Tokenize.configureAsEob(tp, cpi, type, c, pt, false);
            a.setRel(aPos, l.setRel(lPos, (short)0));
            return;
        }
        short v = qcoeff_ptr.getRel(c);
        pt = Tokenize.configureAsGeneric(tp, cpi, v, type, c, pt, false);
        ++c;
        assert (eob <= 16);
        while (c < eob) {
            int rc = VPXConst.zigzag[c];
            v = qcoeff_ptr.getRel(rc);
            pt = Tokenize.configureAsGeneric(tp, cpi, v, type, VP8Util.SubblockConstants.vp8CoefBands[c], pt, pt == 0);
            ++c;
        }
        if (c < 16) {
            Tokenize.configureAsEob(tp, cpi, type, VP8Util.SubblockConstants.vp8CoefBands[c], pt, false);
        }
        a.setRel(aPos, l.setRel(lPos, (short)1));
    }

    private static void stuffOrderHelper(FullAccessGenArrPointer<TokenExtra> tp, FullAccessIntArrPointer a, FullAccessIntArrPointer l, Compressor cpi, Macroblock x, PlaneType plane, int band) {
        int pt = a.get() + l.get();
        Tokenize.configureAsEob(tp, cpi, plane, band, pt, false);
        a.set(l.set((short)0));
    }

    static void stuff2nd_order_b(FullAccessGenArrPointer<TokenExtra> tp, FullAccessIntArrPointer a, FullAccessIntArrPointer l, Compressor cpi, Macroblock x) {
        Tokenize.stuffOrderHelper(tp, a, l, cpi, x, PlaneType.Y2, 0);
    }

    static void stuff1st_order_b(FullAccessGenArrPointer<TokenExtra> tp, FullAccessIntArrPointer a, FullAccessIntArrPointer l, PlaneType type, Compressor cpi, Macroblock x) {
        Tokenize.stuffOrderHelper(tp, a, l, cpi, x, type, type == PlaneType.Y_NO_DC ? 0 : 1);
    }

    static void stuff1st_order_buv(FullAccessGenArrPointer<TokenExtra> tp, FullAccessIntArrPointer a, FullAccessIntArrPointer l, Compressor cpi, Macroblock x) {
        Tokenize.stuffOrderHelper(tp, a, l, cpi, x, PlaneType.UV, 0);
    }

    static void vp8_stuff_mb(Compressor cpi, Macroblock x, FullAccessGenArrPointer<TokenExtra> t) {
        int b;
        MacroblockD xd = x.e_mbd;
        EntropyContextPlanes A = xd.above_context.get();
        EntropyContextPlanes L = xd.left_context;
        PlaneType plane_type = PlaneType.Y_WITH_DC;
        if (xd.hasSecondOrder()) {
            Tokenize.stuff2nd_order_b(t, A.panes.shallowCopyWithPosInc(BlockD.vp8_block2above[24]), L.panes.shallowCopyWithPosInc(BlockD.vp8_block2left[24]), cpi, x);
            plane_type = PlaneType.Y_NO_DC;
        }
        for (b = 0; b < 16; ++b) {
            Tokenize.stuff1st_order_b(t, A.panes.shallowCopyWithPosInc(BlockD.vp8_block2above[b]), L.panes.shallowCopyWithPosInc(BlockD.vp8_block2left[b]), plane_type, cpi, x);
        }
        for (b = 16; b < 24; ++b) {
            Tokenize.stuff1st_order_buv(t, A.panes.shallowCopyWithPosInc(BlockD.vp8_block2above[b]), L.panes.shallowCopyWithPosInc(BlockD.vp8_block2left[b]), cpi, x);
        }
    }

    static boolean mb_is_skippable(MacroblockD x, boolean has_y2_block) {
        boolean skip = true;
        int i = 0;
        int imax = 24;
        if (has_y2_block) {
            ++imax;
            for (i = 0; i < 16 && skip; skip &= x.eobs.getRel(i) < 2, ++i) {
            }
        }
        while (i < imax && skip) {
            skip &= x.eobs.getRel(i) == 0;
            ++i;
        }
        return skip;
    }

    static void vp8_fix_contexts(MacroblockD x) {
        if (x.hasSecondOrder()) {
            x.above_context.get().panes.memset(0, (short)0, x.above_context.get().panes.size());
            x.left_context.panes.memset(0, (short)0, x.left_context.panes.size());
        } else {
            x.above_context.get().panes.memset(0, (short)0, x.above_context.get().panes.size() - 1);
            x.left_context.panes.memset(0, (short)0, x.left_context.panes.size() - 1);
        }
    }

    static void vp8_tokenize_mb(Compressor cpi, Macroblock x, FullAccessGenArrPointer<TokenExtra> t) {
        MacroblockD xd = x.e_mbd;
        boolean has_y2_block = xd.hasSecondOrder();
        xd.mode_info_context.get().mbmi.mb_skip_coeff = Tokenize.mb_is_skippable(xd, has_y2_block);
        if (xd.mode_info_context.get().mbmi.mb_skip_coeff) {
            if (!cpi.common.mb_no_coeff_skip) {
                Tokenize.vp8_stuff_mb(cpi, x, t);
            } else {
                Tokenize.vp8_fix_contexts(xd);
                ++x.skip_true_count;
            }
            return;
        }
        PlaneType plane_type = PlaneType.Y_WITH_DC;
        if (has_y2_block) {
            Tokenize.tokenize2nd_order_b(x, t, cpi);
            plane_type = PlaneType.Y_NO_DC;
        }
        Tokenize.tokenize1st_order_b(x, t, plane_type, cpi);
    }
}

